/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.selectors.variables;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TObjectDoubleMap;
import gnu.trove.map.hash.TObjectDoubleHashMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.loop.monitors.IMonitorContradiction;
import org.chocosolver.solver.search.loop.monitors.IMonitorRestart;
import org.chocosolver.solver.search.strategy.selectors.variables.VariableSelector;
import org.chocosolver.solver.variables.IVariableMonitor;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;

public abstract class AbstractCriterionBasedVariableSelector<V extends Variable>
implements VariableSelector<V>,
IVariableMonitor<V>,
IMonitorContradiction,
IMonitorRestart {
    private final BiFunction<Propagator<?>, double[], double[]> remapWeights = (p, w) -> {
        if (w == null) {
            w = new double[p.getNbVars()];
        } else if (((double[])w).length < p.getNbVars()) {
            w = new double[p.getNbVars()];
            double[] nw = new double[p.getNbVars()];
            System.arraycopy(w, 0, nw, 0, ((double[])w).length);
            w = nw;
        }
        return w;
    };
    protected static final int FLUSH_TOPS = 20;
    protected static final double FLUSH_RATIO = 18.0;
    protected int flushThs;
    protected final HashSet<Object> tops = new HashSet();
    protected int loop = 0;
    private final Random random;
    private final IStateInt last;
    private final TIntArrayList bests = new TIntArrayList();
    protected final Solver solver;
    final IEnvironment environment;
    int conflicts = 0;
    final HashMap<Propagator<?>, Element> failCount = new HashMap();
    private final HashMap<Variable, Integer> observed = new HashMap();
    final TObjectDoubleMap<Variable> weights = new TObjectDoubleHashMap<Variable>(15, 1.5f, 0.0);
    final HashMap<Propagator<?>, double[]> refinedWeights = new HashMap();
    static final double[] rw = new double[]{0.0};

    public AbstractCriterionBasedVariableSelector(V[] vars, long seed, int flush) {
        this.random = new Random(seed);
        this.solver = vars[0].getModel().getSolver();
        this.environment = vars[0].getModel().getEnvironment();
        this.last = this.environment.makeInt(vars.length - 1);
        this.flushThs = flush;
    }

    @Override
    public final V getVariable(V[] vars) {
        V best = null;
        this.bests.resetQuick();
        double w = Double.NEGATIVE_INFINITY;
        int to = this.last.get();
        for (int idx = 0; idx <= to; ++idx) {
            int domSize = vars[idx].getDomainSize();
            if (domSize > 1) {
                double weight = this.weight(vars[idx]) / (double)domSize;
                if (w < weight) {
                    this.bests.resetQuick();
                    this.bests.add(idx);
                    w = weight;
                    continue;
                }
                if (w != weight) continue;
                this.bests.add(idx);
                continue;
            }
            V tmp = vars[to];
            vars[to] = vars[idx];
            vars[idx] = tmp;
            --idx;
            --to;
        }
        this.last.set(to);
        if (this.bests.size() > 0) {
            int currentVar = this.bests.get(this.random.nextInt(this.bests.size()));
            best = vars[currentVar];
        }
        return best;
    }

    protected abstract double weight(V var1);

    @Override
    public final void onContradiction(ContradictionException cex) {
        ++this.conflicts;
        if (cex.c instanceof Propagator) {
            int di;
            int i;
            Propagator prop = (Propagator)cex.c;
            if (prop.getNbVars() < 2) {
                return;
            }
            Element elt = this.failCount.get(prop);
            if (elt == null) {
                elt = new Element(0, 0, 1);
                this.failCount.put(prop, elt);
            } else {
                this.unplug((Variable)prop.getVar(elt.ws[0]));
                this.unplug((Variable)prop.getVar(elt.ws[1]));
            }
            int s = prop.getModel().getEnvironment().getWorldIndex();
            int j = 0;
            int dj = prop.getVar(j).instantiationWorldIndex();
            int k = 1;
            int dk = prop.getVar(k).instantiationWorldIndex();
            if (dj < dk) {
                i = j;
                j = k;
                k = i;
                di = dj;
                dj = dk;
                dk = di;
            }
            for (i = 2; i < prop.getNbVars() && (dj <= s || dk <= s); ++i) {
                di = prop.getVar(i).instantiationWorldIndex();
                if (di > dj) {
                    k = j;
                    dk = dj;
                    j = i;
                    dj = di;
                    continue;
                }
                if (di <= dk) continue;
                k = i;
                dk = di;
            }
            elt.ws[0] = j;
            elt.ws[1] = k;
            this.plug((Variable)prop.getVar(j));
            this.plug((Variable)prop.getVar(k));
            elt.ws[2] = elt.ws[2] + this.remapInc();
            double[] ws = this.refinedWeights.compute(prop, this.remapWeights);
            this.increase(prop, elt, ws);
        }
    }

    abstract void increase(Propagator<?> var1, Element var2, double[] var3);

    int remapInc() {
        return 0;
    }

    protected boolean flushWeights(TObjectDoubleMap<?> q) {
        List temp = this.weights.keySet().stream().sorted(Comparator.comparingDouble(q::get)).limit(20L).collect(Collectors.toList());
        long cnt = temp.stream().filter(this.tops::contains).count();
        this.loop = (double)cnt >= 18.0 ? ++this.loop : 0;
        this.tops.clear();
        if (this.loop == this.flushThs) {
            this.loop = 0;
            return true;
        }
        this.tops.addAll(temp);
        return false;
    }

    final void plug(Variable var) {
        if (!this.observed.containsKey(var)) {
            this.observed.put(var, 1);
            var.addMonitor(this);
        } else {
            this.observed.computeIfPresent(var, (v, c) -> c + 1);
        }
    }

    private void unplug(Variable var) {
        assert (this.observed.containsKey(var));
        Integer obs = this.observed.computeIfPresent(var, (v, c) -> c - 1);
        if (obs != null && obs == 0) {
            var.removeMonitor(this);
            this.observed.remove(var);
        }
    }

    private int next(Propagator<?> pro, int w0, int w1) {
        for (int i = 0; i < pro.getNbVars(); ++i) {
            if (i == w0 || i == w1 || pro.getVar(i).isInstantiated()) continue;
            return i;
        }
        return w0;
    }

    @Override
    public final void onUpdate(Variable var, IEventType evt) {
        if (var.isInstantiated()) {
            var.streamPropagators().forEach(p -> {
                Element elt = this.failCount.get(p);
                if (elt != null) {
                    if (p.getVar(elt.ws[0]) == var) {
                        this.updateFutvars((Propagator<?>)p, elt, 0);
                    } else if (p.getVar(elt.ws[1]) == var) {
                        this.updateFutvars((Propagator<?>)p, elt, 1);
                    }
                }
            });
        }
    }

    private void updateFutvars(Propagator<?> p, Element elt, int i) {
        assert (p.getVar(elt.ws[i]).isInstantiated());
        assert (i == 0 || i == 1);
        int w = this.next(p, elt.ws[i], elt.ws[1 - i]);
        if (w != elt.ws[i]) {
            this.unplug((Variable)p.getVar(elt.ws[i]));
            this.plug((Variable)p.getVar(w));
            elt.ws[i] = w;
        } else {
            int k = 1 - i;
            Object other = p.getVar(elt.ws[k]);
            if (!other.isInstantiated()) {
                double[] delta = new double[]{0.0};
                double[] ws = this.refinedWeights.get(p);
                if (elt.ws[k] < ws.length) {
                    delta[0] = ws[elt.ws[k]];
                }
                this.weights.adjustValue((Variable)other, -delta[0]);
                this.environment.save(() -> {
                    double ww = this.weights.get(other) + delta[0];
                    ww = Math.max(ww, 0.0);
                    this.weights.put((Variable)other, ww);
                });
            }
        }
    }

    static class Element {
        int[] ws;

        public Element(int count, int w0, int w1) {
            this.ws = new int[]{w0, w1, count};
        }
    }
}

