## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(phenolocrop)

## -----------------------------------------------------------------------------
riceCIg_eg

## -----------------------------------------------------------------------------
riceCIg_eg |>
  doubleLogis("x", "CIg")

## -----------------------------------------------------------------------------
x_vec <- 1:max(riceCIg_eg$x)
y <- riceCIg_eg |>
  doubleLogis("x", "CIg") |>
  phenololine(x = x_vec, method = "doubleLogis")
plot(x_vec, y, type = "l", ylab = "rice CIg", 
     xlab = "Dayes after sowing", ylim = range(riceCIg_eg$CIg))
points(riceCIg_eg$x, riceCIg_eg$CIg)

