/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef H5Epubgen_H
#define H5Epubgen_H

#ifdef __cplusplus
extern "C" {
#endif

#define H5E_ARGS             (H5OPEN H5E_ARGS_g)
#define H5E_ATTR             (H5OPEN H5E_ATTR_g)
#define H5E_BTREE            (H5OPEN H5E_BTREE_g)
#define H5E_CACHE            (H5OPEN H5E_CACHE_g)
#define H5E_CONTEXT          (H5OPEN H5E_CONTEXT_g)
#define H5E_DATASET          (H5OPEN H5E_DATASET_g)
#define H5E_DATASPACE        (H5OPEN H5E_DATASPACE_g)
#define H5E_DATATYPE         (H5OPEN H5E_DATATYPE_g)
#define H5E_EARRAY           (H5OPEN H5E_EARRAY_g)
#define H5E_EFL              (H5OPEN H5E_EFL_g)
#define H5E_ERROR            (H5OPEN H5E_ERROR_g)
#define H5E_EVENTSET         (H5OPEN H5E_EVENTSET_g)
#define H5E_FARRAY           (H5OPEN H5E_FARRAY_g)
#define H5E_FILE             (H5OPEN H5E_FILE_g)
#define H5E_FSPACE           (H5OPEN H5E_FSPACE_g)
#define H5E_FUNC             (H5OPEN H5E_FUNC_g)
#define H5E_HEAP             (H5OPEN H5E_HEAP_g)
#define H5E_ID               (H5OPEN H5E_ID_g)
#define H5E_INTERNAL         (H5OPEN H5E_INTERNAL_g)
#define H5E_IO               (H5OPEN H5E_IO_g)
#define H5E_LIB              (H5OPEN H5E_LIB_g)
#define H5E_LINK             (H5OPEN H5E_LINK_g)
#define H5E_MAP              (H5OPEN H5E_MAP_g)
#define H5E_NONE_MAJOR       (H5OPEN H5E_NONE_MAJOR_g)
#define H5E_OHDR             (H5OPEN H5E_OHDR_g)
#define H5E_PAGEBUF          (H5OPEN H5E_PAGEBUF_g)
#define H5E_PLINE            (H5OPEN H5E_PLINE_g)
#define H5E_PLIST            (H5OPEN H5E_PLIST_g)
#define H5E_PLUGIN           (H5OPEN H5E_PLUGIN_g)
#define H5E_REFERENCE        (H5OPEN H5E_REFERENCE_g)
#define H5E_RESOURCE         (H5OPEN H5E_RESOURCE_g)
#define H5E_RS               (H5OPEN H5E_RS_g)
#define H5E_RTREE            (H5OPEN H5E_RTREE_g)
#define H5E_SLIST            (H5OPEN H5E_SLIST_g)
#define H5E_SOHM             (H5OPEN H5E_SOHM_g)
#define H5E_STORAGE          (H5OPEN H5E_STORAGE_g)
#define H5E_SYM              (H5OPEN H5E_SYM_g)
#define H5E_THREADSAFE       (H5OPEN H5E_THREADSAFE_g)
#define H5E_TST              (H5OPEN H5E_TST_g)
#define H5E_VFL              (H5OPEN H5E_VFL_g)
#define H5E_VOL              (H5OPEN H5E_VOL_g)
H5_DLLVAR hid_t H5E_ARGS_g;          
H5_DLLVAR hid_t H5E_ATTR_g;          
H5_DLLVAR hid_t H5E_BTREE_g;         
H5_DLLVAR hid_t H5E_CACHE_g;         
H5_DLLVAR hid_t H5E_CONTEXT_g;       
H5_DLLVAR hid_t H5E_DATASET_g;       
H5_DLLVAR hid_t H5E_DATASPACE_g;     
H5_DLLVAR hid_t H5E_DATATYPE_g;      
H5_DLLVAR hid_t H5E_EARRAY_g;        
H5_DLLVAR hid_t H5E_EFL_g;           
H5_DLLVAR hid_t H5E_ERROR_g;         
H5_DLLVAR hid_t H5E_EVENTSET_g;      
H5_DLLVAR hid_t H5E_FARRAY_g;        
H5_DLLVAR hid_t H5E_FILE_g;          
H5_DLLVAR hid_t H5E_FSPACE_g;        
H5_DLLVAR hid_t H5E_FUNC_g;          
H5_DLLVAR hid_t H5E_HEAP_g;          
H5_DLLVAR hid_t H5E_ID_g;            
H5_DLLVAR hid_t H5E_INTERNAL_g;      
H5_DLLVAR hid_t H5E_IO_g;            
H5_DLLVAR hid_t H5E_LIB_g;           
H5_DLLVAR hid_t H5E_LINK_g;          
H5_DLLVAR hid_t H5E_MAP_g;           
H5_DLLVAR hid_t H5E_NONE_MAJOR_g;    
H5_DLLVAR hid_t H5E_OHDR_g;          
H5_DLLVAR hid_t H5E_PAGEBUF_g;       
H5_DLLVAR hid_t H5E_PLINE_g;         
H5_DLLVAR hid_t H5E_PLIST_g;         
H5_DLLVAR hid_t H5E_PLUGIN_g;        
H5_DLLVAR hid_t H5E_REFERENCE_g;     
H5_DLLVAR hid_t H5E_RESOURCE_g;      
H5_DLLVAR hid_t H5E_RS_g;            
H5_DLLVAR hid_t H5E_RTREE_g;         
H5_DLLVAR hid_t H5E_SLIST_g;         
H5_DLLVAR hid_t H5E_SOHM_g;          
H5_DLLVAR hid_t H5E_STORAGE_g;       
H5_DLLVAR hid_t H5E_SYM_g;           
H5_DLLVAR hid_t H5E_THREADSAFE_g;    
H5_DLLVAR hid_t H5E_TST_g;           
H5_DLLVAR hid_t H5E_VFL_g;           
H5_DLLVAR hid_t H5E_VOL_g;           

#define H5E_BADRANGE         (H5OPEN H5E_BADRANGE_g)
#define H5E_BADTYPE          (H5OPEN H5E_BADTYPE_g)
#define H5E_BADVALUE         (H5OPEN H5E_BADVALUE_g)
#define H5E_UNINITIALIZED    (H5OPEN H5E_UNINITIALIZED_g)
#define H5E_UNSUPPORTED      (H5OPEN H5E_UNSUPPORTED_g)
H5_DLLVAR hid_t H5E_BADRANGE_g;      
H5_DLLVAR hid_t H5E_BADTYPE_g;       
H5_DLLVAR hid_t H5E_BADVALUE_g;      
H5_DLLVAR hid_t H5E_UNINITIALIZED_g; 
H5_DLLVAR hid_t H5E_UNSUPPORTED_g;   

#define H5E_CANTCANCEL       (H5OPEN H5E_CANTCANCEL_g)
#define H5E_CANTWAIT         (H5OPEN H5E_CANTWAIT_g)
H5_DLLVAR hid_t H5E_CANTCANCEL_g;    
H5_DLLVAR hid_t H5E_CANTWAIT_g;      

#define H5E_CANTDECODE       (H5OPEN H5E_CANTDECODE_g)
#define H5E_CANTENCODE       (H5OPEN H5E_CANTENCODE_g)
#define H5E_CANTFIND         (H5OPEN H5E_CANTFIND_g)
#define H5E_CANTINSERT       (H5OPEN H5E_CANTINSERT_g)
#define H5E_CANTLIST         (H5OPEN H5E_CANTLIST_g)
#define H5E_CANTMODIFY       (H5OPEN H5E_CANTMODIFY_g)
#define H5E_CANTREDISTRIBUTE (H5OPEN H5E_CANTREDISTRIBUTE_g)
#define H5E_CANTREMOVE       (H5OPEN H5E_CANTREMOVE_g)
#define H5E_CANTSPLIT        (H5OPEN H5E_CANTSPLIT_g)
#define H5E_CANTSWAP         (H5OPEN H5E_CANTSWAP_g)
#define H5E_EXISTS           (H5OPEN H5E_EXISTS_g)
#define H5E_NOTFOUND         (H5OPEN H5E_NOTFOUND_g)
H5_DLLVAR hid_t H5E_CANTDECODE_g;    
H5_DLLVAR hid_t H5E_CANTENCODE_g;    
H5_DLLVAR hid_t H5E_CANTFIND_g;      
H5_DLLVAR hid_t H5E_CANTINSERT_g;    
H5_DLLVAR hid_t H5E_CANTLIST_g;      
H5_DLLVAR hid_t H5E_CANTMODIFY_g;    
H5_DLLVAR hid_t H5E_CANTREDISTRIBUTE_g; 
H5_DLLVAR hid_t H5E_CANTREMOVE_g;    
H5_DLLVAR hid_t H5E_CANTSPLIT_g;     
H5_DLLVAR hid_t H5E_CANTSWAP_g;      
H5_DLLVAR hid_t H5E_EXISTS_g;        
H5_DLLVAR hid_t H5E_NOTFOUND_g;      

#define H5E_CANTCLEAN        (H5OPEN H5E_CANTCLEAN_g)
#define H5E_CANTCORK         (H5OPEN H5E_CANTCORK_g)
#define H5E_CANTDEPEND       (H5OPEN H5E_CANTDEPEND_g)
#define H5E_CANTDIRTY        (H5OPEN H5E_CANTDIRTY_g)
#define H5E_CANTEXPUNGE      (H5OPEN H5E_CANTEXPUNGE_g)
#define H5E_CANTFLUSH        (H5OPEN H5E_CANTFLUSH_g)
#define H5E_CANTINS          (H5OPEN H5E_CANTINS_g)
#define H5E_CANTLOAD         (H5OPEN H5E_CANTLOAD_g)
#define H5E_CANTMARKCLEAN    (H5OPEN H5E_CANTMARKCLEAN_g)
#define H5E_CANTMARKDIRTY    (H5OPEN H5E_CANTMARKDIRTY_g)
#define H5E_CANTMARKSERIALIZED (H5OPEN H5E_CANTMARKSERIALIZED_g)
#define H5E_CANTMARKUNSERIALIZED (H5OPEN H5E_CANTMARKUNSERIALIZED_g)
#define H5E_CANTNOTIFY       (H5OPEN H5E_CANTNOTIFY_g)
#define H5E_CANTPIN          (H5OPEN H5E_CANTPIN_g)
#define H5E_CANTPROTECT      (H5OPEN H5E_CANTPROTECT_g)
#define H5E_CANTRESIZE       (H5OPEN H5E_CANTRESIZE_g)
#define H5E_CANTSERIALIZE    (H5OPEN H5E_CANTSERIALIZE_g)
#define H5E_CANTTAG          (H5OPEN H5E_CANTTAG_g)
#define H5E_CANTUNCORK       (H5OPEN H5E_CANTUNCORK_g)
#define H5E_CANTUNDEPEND     (H5OPEN H5E_CANTUNDEPEND_g)
#define H5E_CANTUNPIN        (H5OPEN H5E_CANTUNPIN_g)
#define H5E_CANTUNPROTECT    (H5OPEN H5E_CANTUNPROTECT_g)
#define H5E_CANTUNSERIALIZE  (H5OPEN H5E_CANTUNSERIALIZE_g)
#define H5E_LOGGING          (H5OPEN H5E_LOGGING_g)
#define H5E_NOTCACHED        (H5OPEN H5E_NOTCACHED_g)
#define H5E_PROTECT          (H5OPEN H5E_PROTECT_g)
#define H5E_SYSTEM           (H5OPEN H5E_SYSTEM_g)
H5_DLLVAR hid_t H5E_CANTCLEAN_g;     
H5_DLLVAR hid_t H5E_CANTCORK_g;      
H5_DLLVAR hid_t H5E_CANTDEPEND_g;    
H5_DLLVAR hid_t H5E_CANTDIRTY_g;     
H5_DLLVAR hid_t H5E_CANTEXPUNGE_g;   
H5_DLLVAR hid_t H5E_CANTFLUSH_g;     
H5_DLLVAR hid_t H5E_CANTINS_g;       
H5_DLLVAR hid_t H5E_CANTLOAD_g;      
H5_DLLVAR hid_t H5E_CANTMARKCLEAN_g; 
H5_DLLVAR hid_t H5E_CANTMARKDIRTY_g; 
H5_DLLVAR hid_t H5E_CANTMARKSERIALIZED_g; 
H5_DLLVAR hid_t H5E_CANTMARKUNSERIALIZED_g; 
H5_DLLVAR hid_t H5E_CANTNOTIFY_g;    
H5_DLLVAR hid_t H5E_CANTPIN_g;       
H5_DLLVAR hid_t H5E_CANTPROTECT_g;   
H5_DLLVAR hid_t H5E_CANTRESIZE_g;    
H5_DLLVAR hid_t H5E_CANTSERIALIZE_g; 
H5_DLLVAR hid_t H5E_CANTTAG_g;       
H5_DLLVAR hid_t H5E_CANTUNCORK_g;    
H5_DLLVAR hid_t H5E_CANTUNDEPEND_g;  
H5_DLLVAR hid_t H5E_CANTUNPIN_g;     
H5_DLLVAR hid_t H5E_CANTUNPROTECT_g; 
H5_DLLVAR hid_t H5E_CANTUNSERIALIZE_g; 
H5_DLLVAR hid_t H5E_LOGGING_g;       
H5_DLLVAR hid_t H5E_NOTCACHED_g;     
H5_DLLVAR hid_t H5E_PROTECT_g;       
H5_DLLVAR hid_t H5E_SYSTEM_g;        

#define H5E_BADSELECT        (H5OPEN H5E_BADSELECT_g)
#define H5E_CANTAPPEND       (H5OPEN H5E_CANTAPPEND_g)
#define H5E_CANTCLIP         (H5OPEN H5E_CANTCLIP_g)
#define H5E_CANTCOMPARE      (H5OPEN H5E_CANTCOMPARE_g)
#define H5E_CANTCOUNT        (H5OPEN H5E_CANTCOUNT_g)
#define H5E_CANTNEXT         (H5OPEN H5E_CANTNEXT_g)
#define H5E_CANTSELECT       (H5OPEN H5E_CANTSELECT_g)
#define H5E_INCONSISTENTSTATE (H5OPEN H5E_INCONSISTENTSTATE_g)
H5_DLLVAR hid_t H5E_BADSELECT_g;     
H5_DLLVAR hid_t H5E_CANTAPPEND_g;    
H5_DLLVAR hid_t H5E_CANTCLIP_g;      
H5_DLLVAR hid_t H5E_CANTCOMPARE_g;   
H5_DLLVAR hid_t H5E_CANTCOUNT_g;     
H5_DLLVAR hid_t H5E_CANTNEXT_g;      
H5_DLLVAR hid_t H5E_CANTSELECT_g;    
H5_DLLVAR hid_t H5E_INCONSISTENTSTATE_g; 

#define H5E_CLOSEERROR       (H5OPEN H5E_CLOSEERROR_g)
#define H5E_FCNTL            (H5OPEN H5E_FCNTL_g)
#define H5E_OVERFLOW         (H5OPEN H5E_OVERFLOW_g)
#define H5E_READERROR        (H5OPEN H5E_READERROR_g)
#define H5E_SEEKERROR        (H5OPEN H5E_SEEKERROR_g)
#define H5E_WRITEERROR       (H5OPEN H5E_WRITEERROR_g)
H5_DLLVAR hid_t H5E_CLOSEERROR_g;    
H5_DLLVAR hid_t H5E_FCNTL_g;         
H5_DLLVAR hid_t H5E_OVERFLOW_g;      
H5_DLLVAR hid_t H5E_READERROR_g;     
H5_DLLVAR hid_t H5E_SEEKERROR_g;     
H5_DLLVAR hid_t H5E_WRITEERROR_g;    

#define H5E_BADFILE          (H5OPEN H5E_BADFILE_g)
#define H5E_CANTCLOSEFILE    (H5OPEN H5E_CANTCLOSEFILE_g)
#define H5E_CANTCREATE       (H5OPEN H5E_CANTCREATE_g)
#define H5E_CANTDELETEFILE   (H5OPEN H5E_CANTDELETEFILE_g)
#define H5E_CANTLOCKFILE     (H5OPEN H5E_CANTLOCKFILE_g)
#define H5E_CANTOPENFILE     (H5OPEN H5E_CANTOPENFILE_g)
#define H5E_CANTUNLOCKFILE   (H5OPEN H5E_CANTUNLOCKFILE_g)
#define H5E_FILEEXISTS       (H5OPEN H5E_FILEEXISTS_g)
#define H5E_FILEOPEN         (H5OPEN H5E_FILEOPEN_g)
#define H5E_MOUNT            (H5OPEN H5E_MOUNT_g)
#define H5E_NOTHDF5          (H5OPEN H5E_NOTHDF5_g)
#define H5E_TRUNCATED        (H5OPEN H5E_TRUNCATED_g)
#define H5E_UNMOUNT          (H5OPEN H5E_UNMOUNT_g)
H5_DLLVAR hid_t H5E_BADFILE_g;       
H5_DLLVAR hid_t H5E_CANTCLOSEFILE_g; 
H5_DLLVAR hid_t H5E_CANTCREATE_g;    
H5_DLLVAR hid_t H5E_CANTDELETEFILE_g; 
H5_DLLVAR hid_t H5E_CANTLOCKFILE_g;  
H5_DLLVAR hid_t H5E_CANTOPENFILE_g;  
H5_DLLVAR hid_t H5E_CANTUNLOCKFILE_g; 
H5_DLLVAR hid_t H5E_FILEEXISTS_g;    
H5_DLLVAR hid_t H5E_FILEOPEN_g;      
H5_DLLVAR hid_t H5E_MOUNT_g;         
H5_DLLVAR hid_t H5E_NOTHDF5_g;       
H5_DLLVAR hid_t H5E_TRUNCATED_g;     
H5_DLLVAR hid_t H5E_UNMOUNT_g;       

#define H5E_CANTMERGE        (H5OPEN H5E_CANTMERGE_g)
#define H5E_CANTREVIVE       (H5OPEN H5E_CANTREVIVE_g)
#define H5E_CANTSHRINK       (H5OPEN H5E_CANTSHRINK_g)
H5_DLLVAR hid_t H5E_CANTMERGE_g;     
H5_DLLVAR hid_t H5E_CANTREVIVE_g;    
H5_DLLVAR hid_t H5E_CANTSHRINK_g;    

#define H5E_ALREADYINIT      (H5OPEN H5E_ALREADYINIT_g)
#define H5E_CANTINIT         (H5OPEN H5E_CANTINIT_g)
#define H5E_CANTRELEASE      (H5OPEN H5E_CANTRELEASE_g)
H5_DLLVAR hid_t H5E_ALREADYINIT_g;   
H5_DLLVAR hid_t H5E_CANTINIT_g;      
H5_DLLVAR hid_t H5E_CANTRELEASE_g;   

#define H5E_CANTCLOSEOBJ     (H5OPEN H5E_CANTCLOSEOBJ_g)
#define H5E_CANTOPENOBJ      (H5OPEN H5E_CANTOPENOBJ_g)
#define H5E_COMPLEN          (H5OPEN H5E_COMPLEN_g)
#define H5E_PATH             (H5OPEN H5E_PATH_g)
H5_DLLVAR hid_t H5E_CANTCLOSEOBJ_g;  
H5_DLLVAR hid_t H5E_CANTOPENOBJ_g;   
H5_DLLVAR hid_t H5E_COMPLEN_g;       
H5_DLLVAR hid_t H5E_PATH_g;          

#define H5E_CANTATTACH       (H5OPEN H5E_CANTATTACH_g)
#define H5E_CANTCOMPUTE      (H5OPEN H5E_CANTCOMPUTE_g)
#define H5E_CANTEXTEND       (H5OPEN H5E_CANTEXTEND_g)
#define H5E_CANTOPERATE      (H5OPEN H5E_CANTOPERATE_g)
#define H5E_CANTRESTORE      (H5OPEN H5E_CANTRESTORE_g)
#define H5E_CANTUPDATE       (H5OPEN H5E_CANTUPDATE_g)
H5_DLLVAR hid_t H5E_CANTATTACH_g;    
H5_DLLVAR hid_t H5E_CANTCOMPUTE_g;   
H5_DLLVAR hid_t H5E_CANTEXTEND_g;    
H5_DLLVAR hid_t H5E_CANTOPERATE_g;   
H5_DLLVAR hid_t H5E_CANTRESTORE_g;   
H5_DLLVAR hid_t H5E_CANTUPDATE_g;    

#define H5E_BADGROUP         (H5OPEN H5E_BADGROUP_g)
#define H5E_BADID            (H5OPEN H5E_BADID_g)
#define H5E_CANTDEC          (H5OPEN H5E_CANTDEC_g)
#define H5E_CANTINC          (H5OPEN H5E_CANTINC_g)
#define H5E_CANTREGISTER     (H5OPEN H5E_CANTREGISTER_g)
#define H5E_NOIDS            (H5OPEN H5E_NOIDS_g)
H5_DLLVAR hid_t H5E_BADGROUP_g;      
H5_DLLVAR hid_t H5E_BADID_g;         
H5_DLLVAR hid_t H5E_CANTDEC_g;       
H5_DLLVAR hid_t H5E_CANTINC_g;       
H5_DLLVAR hid_t H5E_CANTREGISTER_g;  
H5_DLLVAR hid_t H5E_NOIDS_g;         

#define H5E_CANTMOVE         (H5OPEN H5E_CANTMOVE_g)
#define H5E_CANTSORT         (H5OPEN H5E_CANTSORT_g)
#define H5E_NLINKS           (H5OPEN H5E_NLINKS_g)
#define H5E_NOTREGISTERED    (H5OPEN H5E_NOTREGISTERED_g)
#define H5E_TRAVERSE         (H5OPEN H5E_TRAVERSE_g)
H5_DLLVAR hid_t H5E_CANTMOVE_g;      
H5_DLLVAR hid_t H5E_CANTSORT_g;      
H5_DLLVAR hid_t H5E_NLINKS_g;        
H5_DLLVAR hid_t H5E_NOTREGISTERED_g; 
H5_DLLVAR hid_t H5E_TRAVERSE_g;      

#define H5E_CANTPUT          (H5OPEN H5E_CANTPUT_g)
H5_DLLVAR hid_t H5E_CANTPUT_g;       

#define H5E_CANTGATHER       (H5OPEN H5E_CANTGATHER_g)
#define H5E_CANTRECV         (H5OPEN H5E_CANTRECV_g)
#define H5E_MPI              (H5OPEN H5E_MPI_g)
#define H5E_MPIERRSTR        (H5OPEN H5E_MPIERRSTR_g)
#define H5E_NO_INDEPENDENT   (H5OPEN H5E_NO_INDEPENDENT_g)
H5_DLLVAR hid_t H5E_CANTGATHER_g;    
H5_DLLVAR hid_t H5E_CANTRECV_g;      
H5_DLLVAR hid_t H5E_MPI_g;           
H5_DLLVAR hid_t H5E_MPIERRSTR_g;     
H5_DLLVAR hid_t H5E_NO_INDEPENDENT_g; 

#define H5E_NONE_MINOR       (H5OPEN H5E_NONE_MINOR_g)
H5_DLLVAR hid_t H5E_NONE_MINOR_g;    

#define H5E_ALIGNMENT        (H5OPEN H5E_ALIGNMENT_g)
#define H5E_BADITER          (H5OPEN H5E_BADITER_g)
#define H5E_BADMESG          (H5OPEN H5E_BADMESG_g)
#define H5E_CANTDELETE       (H5OPEN H5E_CANTDELETE_g)
#define H5E_CANTPACK         (H5OPEN H5E_CANTPACK_g)
#define H5E_CANTRENAME       (H5OPEN H5E_CANTRENAME_g)
#define H5E_CANTRESET        (H5OPEN H5E_CANTRESET_g)
#define H5E_LINKCOUNT        (H5OPEN H5E_LINKCOUNT_g)
#define H5E_VERSION          (H5OPEN H5E_VERSION_g)
H5_DLLVAR hid_t H5E_ALIGNMENT_g;     
H5_DLLVAR hid_t H5E_BADITER_g;       
H5_DLLVAR hid_t H5E_BADMESG_g;       
H5_DLLVAR hid_t H5E_CANTDELETE_g;    
H5_DLLVAR hid_t H5E_CANTPACK_g;      
H5_DLLVAR hid_t H5E_CANTRENAME_g;    
H5_DLLVAR hid_t H5E_CANTRESET_g;     
H5_DLLVAR hid_t H5E_LINKCOUNT_g;     
H5_DLLVAR hid_t H5E_VERSION_g;       

#define H5E_CALLBACK         (H5OPEN H5E_CALLBACK_g)
#define H5E_CANAPPLY         (H5OPEN H5E_CANAPPLY_g)
#define H5E_CANTFILTER       (H5OPEN H5E_CANTFILTER_g)
#define H5E_NOENCODER        (H5OPEN H5E_NOENCODER_g)
#define H5E_NOFILTER         (H5OPEN H5E_NOFILTER_g)
#define H5E_SETLOCAL         (H5OPEN H5E_SETLOCAL_g)
H5_DLLVAR hid_t H5E_CALLBACK_g;      
H5_DLLVAR hid_t H5E_CANAPPLY_g;      
H5_DLLVAR hid_t H5E_CANTFILTER_g;    
H5_DLLVAR hid_t H5E_NOENCODER_g;     
H5_DLLVAR hid_t H5E_NOFILTER_g;      
H5_DLLVAR hid_t H5E_SETLOCAL_g;      

#define H5E_CANTGET          (H5OPEN H5E_CANTGET_g)
#define H5E_CANTSET          (H5OPEN H5E_CANTSET_g)
#define H5E_DUPCLASS         (H5OPEN H5E_DUPCLASS_g)
#define H5E_SETDISALLOWED    (H5OPEN H5E_SETDISALLOWED_g)
H5_DLLVAR hid_t H5E_CANTGET_g;       
H5_DLLVAR hid_t H5E_CANTSET_g;       
H5_DLLVAR hid_t H5E_DUPCLASS_g;      
H5_DLLVAR hid_t H5E_SETDISALLOWED_g; 

#define H5E_OPENERROR        (H5OPEN H5E_OPENERROR_g)
H5_DLLVAR hid_t H5E_OPENERROR_g;     

#define H5E_ALREADYEXISTS    (H5OPEN H5E_ALREADYEXISTS_g)
#define H5E_CANTALLOC        (H5OPEN H5E_CANTALLOC_g)
#define H5E_CANTCOPY         (H5OPEN H5E_CANTCOPY_g)
#define H5E_CANTFREE         (H5OPEN H5E_CANTFREE_g)
#define H5E_CANTGC           (H5OPEN H5E_CANTGC_g)
#define H5E_CANTGETSIZE      (H5OPEN H5E_CANTGETSIZE_g)
#define H5E_CANTLOCK         (H5OPEN H5E_CANTLOCK_g)
#define H5E_CANTUNLOCK       (H5OPEN H5E_CANTUNLOCK_g)
#define H5E_NOSPACE          (H5OPEN H5E_NOSPACE_g)
#define H5E_OBJOPEN          (H5OPEN H5E_OBJOPEN_g)
H5_DLLVAR hid_t H5E_ALREADYEXISTS_g; 
H5_DLLVAR hid_t H5E_CANTALLOC_g;     
H5_DLLVAR hid_t H5E_CANTCOPY_g;      
H5_DLLVAR hid_t H5E_CANTFREE_g;      
H5_DLLVAR hid_t H5E_CANTGC_g;        
H5_DLLVAR hid_t H5E_CANTGETSIZE_g;   
H5_DLLVAR hid_t H5E_CANTLOCK_g;      
H5_DLLVAR hid_t H5E_CANTUNLOCK_g;    
H5_DLLVAR hid_t H5E_NOSPACE_g;       
H5_DLLVAR hid_t H5E_OBJOPEN_g;       

#define H5E_SYSERRSTR        (H5OPEN H5E_SYSERRSTR_g)
H5_DLLVAR hid_t H5E_SYSERRSTR_g;     

#define H5E_BADSIZE          (H5OPEN H5E_BADSIZE_g)
#define H5E_CANTCONVERT      (H5OPEN H5E_CANTCONVERT_g)
H5_DLLVAR hid_t H5E_BADSIZE_g;       
H5_DLLVAR hid_t H5E_CANTCONVERT_g;   

#ifdef __cplusplus
}
#endif

#endif 
