/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.simplecli;

import java.util.ArrayList;
import weka.core.OptionHandler;
import weka.gui.SimpleCLIPanel;
import weka.gui.simplecli.AbstractCommand;

public class Java
extends AbstractCommand {
    @Override
    public String getName() {
        return "java";
    }

    @Override
    public String getHelp() {
        return "Lists the capabilities of the specified class.\nIf the class is a " + OptionHandler.class.getName() + " then\ntrailing options after the classname will be\nset as well.\n";
    }

    @Override
    public String getParameterHelp() {
        return "<classname> <args>";
    }

    @Override
    protected void doExecute(String[] params) throws Exception {
        try {
            if (params.length == 0) {
                throw new Exception("No class name given");
            }
            String className = params[0];
            params[0] = "";
            if (this.m_Owner.isBusy()) {
                throw new Exception("An object is already running, use \"kill\" to stop it.");
            }
            Class<?> theClass = Class.forName(className);
            ArrayList<String> argv = new ArrayList<String>();
            for (int i = 1; i < params.length; ++i) {
                argv.add(params[i]);
            }
            this.m_Owner.startThread(new SimpleCLIPanel.ClassRunner(this.m_Owner, theClass, argv.toArray(new String[argv.size()])));
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

