/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.GeneticFuzzyApriori;

import java.util.ArrayList;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.GeneticFuzzyApriori.FuzzyAttribute;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.GeneticFuzzyApriori.FuzzyRegion;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.GeneticFuzzyApriori.myDataset;

public class FuzzyDataset {
    private myDataset dataset;
    private ArrayList<FuzzyAttribute> fuzzyAttributes;
    private double[][][] fuzzyTransactions;
    private int[] numFuzzyRegions;

    public FuzzyDataset(myDataset dataset, ArrayList<FuzzyAttribute> fuzzyAttributes) {
        this.dataset = dataset;
        this.fuzzyAttributes = fuzzyAttributes;
        this.createFuzzyTransactions();
        this.setNumFuzzyRegions();
    }

    private void createFuzzyTransactions() {
        this.fuzzyTransactions = new double[this.dataset.getnTrans()][this.fuzzyAttributes.size()][];
        double[][] true_transactions = this.dataset.getTrueTransactions();
        for (int trans = 0; trans < this.fuzzyTransactions.length; ++trans) {
            for (int attr = 0; attr < this.fuzzyAttributes.size(); ++attr) {
                int id_attr = this.fuzzyAttributes.get(attr).getIdAttr();
                this.transformIntoFuzzySet(trans, attr, true_transactions[trans][id_attr]);
            }
        }
    }

    public int getAttrib(int attr) {
        return this.fuzzyAttributes.get(attr).getIdAttr();
    }

    private void transformIntoFuzzySet(int trans, int attr, double true_value) {
        FuzzyRegion[] fuzzy_regions = this.fuzzyAttributes.get(attr).getFuzzyRegions();
        this.fuzzyTransactions[trans][attr] = new double[fuzzy_regions.length];
        for (int region = 0; region < fuzzy_regions.length; ++region) {
            this.fuzzyTransactions[trans][attr][region] = fuzzy_regions[region].getFuzzyValue(true_value);
        }
    }

    private void setNumFuzzyRegions() {
        this.numFuzzyRegions = new int[this.fuzzyAttributes.size()];
        for (int i = 0; i < this.numFuzzyRegions.length; ++i) {
            this.numFuzzyRegions[i] = this.fuzzyAttributes.get(i).getNumberOfFuzzyRegions();
        }
    }

    public double[][][] getFuzzyTransactions() {
        return this.fuzzyTransactions;
    }

    public int getNumberOfFuzzyAttributes() {
        return this.fuzzyAttributes.size();
    }

    public int[] getNumberOfFuzzyRegions() {
        return this.numFuzzyRegions;
    }
}

