/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Thrift;

import java.util.ArrayList;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Thrift.BaseD;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Thrift.BaseR;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Thrift.Individuo;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Thrift.myDataset;
import org.core.Fichero;
import org.core.Randomize;

public class GA {
    myDataset train;
    myDataset test;
    BaseD baseDatos;
    static BaseR baseReglas;
    int populationSize;
    int nEvaluations;
    int n_genes;
    double crossProb;
    double mutProb;
    ArrayList<Individuo> New;
    ArrayList<Individuo> Old;
    static int Trials;
    static int Trials_mejor;
    int Best_guy;
    int n_var_estado;
    String output;
    int Mu_next;
    double Best_perf;

    public GA(myDataset train, myDataset test, BaseD baseDatos, BaseR baseReglas, int populationSize, int nEvaluations, int n_genes, double crossProb, double mutProb, String output) {
        this.train = train;
        this.test = test;
        this.baseDatos = baseDatos;
        GA.baseReglas = baseReglas;
        this.populationSize = populationSize;
        this.nEvaluations = nEvaluations;
        this.n_genes = n_genes;
        this.crossProb = crossProb;
        this.mutProb = mutProb;
        this.output = output;
        this.n_var_estado = train.getnInputs();
        Fichero.escribeFichero(output, "");
    }

    public static boolean BETTER(double X, double Y) {
        return X < Y;
    }

    public Individuo lanzar() {
        int n_r;
        Individuo solucion = new Individuo();
        Trials_mejor = 0;
        Trials = 0;
        this.Best_perf = Double.MAX_VALUE;
        this.init();
        this.Evaluacion();
        int Gen = 0;
        do {
            n_r = baseReglas.decodifica(this.New.get(this.Best_guy).getGene());
            double ecn_tra = 2.0 / this.train.variance(this.train.getnInputs()) * this.New.get((int)this.Best_guy).Perf;
            double ecn_tst = 2.0 / this.test.variance(this.test.getnInputs()) * GA.Error(this.test, n_r);
            System.out.println("Gen: " + Gen + ", #Ev: " + Trials + "; ECMntra-tst = " + ecn_tra + "-" + ecn_tst + " #R: " + n_r + "; EMS: " + Trials_mejor);
            this.Old.clear();
            for (int i = 0; i < this.populationSize; ++i) {
                this.Old.add(this.New.get(i).copia());
            }
            this.New.clear();
            this.Select();
            this.Cruce();
            this.Mutacion();
            this.Elitist();
            this.Evaluacion();
            ++Gen;
        } while (Trials <= this.nEvaluations);
        solucion.copia(this.New.get(this.Best_guy));
        n_r = baseReglas.decodifica(this.New.get(this.Best_guy).getGene());
        double ecm_tst = GA.Error(this.test, n_r);
        System.out.println("Gen: " + Gen + ", #Ev: " + Trials + "; ECMtra-tst = " + this.New.get((int)this.Best_guy).Perf + "-" + ecm_tst + " #R: " + n_r + "; EMS: " + Trials_mejor);
        return solucion;
    }

    private void init() {
        this.New = new ArrayList(this.populationSize);
        this.Old = new ArrayList(this.populationSize);
        this.Mu_next = this.mutProb < 1.0 ? (int)Math.ceil(Math.log(Randomize.Rand()) / Math.log(1.0 - this.mutProb)) : 1;
        for (int i = 0; i < this.populationSize; ++i) {
            Individuo ind = new Individuo(this.n_genes);
            for (int j = 0; j < this.n_genes; ++j) {
                ind.setGene(j, Randomize.RandintClosed(0, this.baseDatos.getnLabels(this.n_var_estado)));
            }
            this.New.add(ind);
        }
    }

    private void Evaluacion() {
        double Best_current_perf = Double.MAX_VALUE;
        boolean eval = false;
        for (int i = 0; i < this.populationSize; ++i) {
            double performance;
            if (this.New.get(i).noEvaluado()) {
                performance = this.New.get((int)i).Perf = this.evalua(this.New.get(i).getGene());
                this.New.get(i).evaluado();
                eval = true;
            } else {
                performance = this.New.get((int)i).Perf;
                eval = false;
            }
            if (performance < this.Best_perf) {
                this.Best_perf = performance;
                Trials_mejor = Trials;
            }
            if (eval) {
                String cadena = new String("Trails: " + Trials + ", Perf: " + this.Best_perf + "\n");
                Fichero.AnadirtoFichero(this.output, cadena);
            }
            if (i == 0) {
                Best_current_perf = performance;
                this.Best_guy = 0;
                continue;
            }
            if (!GA.BETTER(performance, Best_current_perf)) continue;
            Best_current_perf = performance;
            this.Best_guy = i;
        }
    }

    public double evalua(int[] cromosoma) {
        ++Trials;
        int n_reglas = baseReglas.decodifica(cromosoma);
        double ecm = GA.Error(this.train, n_reglas);
        return ecm;
    }

    public static double Error(myDataset datos, int n_reglas) {
        double suma = 0.0;
        for (int j = 0; j < datos.getnData(); ++j) {
            double fuerza = baseReglas.FLC(datos.getExample(j), n_reglas);
            suma += 0.5 * Math.pow(datos.getOutputAsReal(j) - fuerza, 2.0);
        }
        return suma / (double)datos.getnData();
    }

    private void Select() {
        int j;
        int i;
        int[] sample = new int[this.populationSize];
        double rank_min = 0.75;
        for (i = 0; i < this.populationSize; ++i) {
            this.Old.get(i).setRanking(0);
        }
        for (i = 0; i < this.populationSize - 1; ++i) {
            int best = -1;
            double perf = 0.0;
            for (j = 0; j < this.populationSize; ++j) {
                if (this.Old.get(j).getRanking() != 0) continue;
                if (best != -1) {
                    if (!GA.BETTER(this.Old.get((int)j).Perf, perf)) continue;
                }
                perf = this.Old.get((int)j).Perf;
                best = j;
            }
            this.Old.get(best).setRanking(this.populationSize - 1 - i);
        }
        double rank_max = 2.0 - rank_min;
        double factor = (rank_max - rank_min) / (double)(this.populationSize - 1);
        int k = 0;
        double ptr = Randomize.Rand();
        double sum = 0;
        for (i = 0; i < this.populationSize; ++i) {
            double expected = rank_min + (double)this.Old.get(i).getRanking() * factor;
            sum += expected;
            while (sum >= ptr) {
                sample[k++] = i;
                ptr += 1.0;
            }
        }
        if (k != this.populationSize) {
            while (k < this.populationSize) {
                sample[k] = Randomize.RandintClosed(0, this.populationSize - 1);
                ++k;
            }
        }
        for (i = 0; i < this.populationSize; ++i) {
            j = Randomize.RandintClosed(i, this.populationSize - 1);
            int temp = sample[j];
            sample[j] = sample[i];
            sample[i] = temp;
        }
        for (i = 0; i < this.populationSize; ++i) {
            k = sample[i];
            Individuo ind = new Individuo(this.n_genes);
            for (j = 0; j < this.n_genes; ++j) {
                ind.setGene(j, this.Old.get(k).getGene(j));
            }
            ind.Perf = this.Old.get((int)k).Perf;
            ind.evaluado();
            this.New.add(ind);
        }
    }

    private void Cruce() {
        for (int mom = 0; mom < (int)this.crossProb; mom += 2) {
            int dad = mom + 1;
            int xpoint1 = Randomize.RandintClosed(0, this.n_genes - 1);
            int xpoint2 = xpoint1 != this.n_genes - 1 ? Randomize.RandintClosed(xpoint1 + 1, this.n_genes - 1) : this.n_genes - 1;
            for (int i = xpoint1; i <= xpoint2; ++i) {
                int temp = this.New.get((int)mom).Gene[i];
                this.New.get((int)mom).Gene[i] = this.New.get((int)dad).Gene[i];
                this.New.get((int)dad).Gene[i] = temp;
            }
            this.New.get(mom).setNoEvaluado();
            this.New.get(dad).setNoEvaluado();
        }
    }

    private void Mutacion() {
        int posiciones = this.n_genes * this.populationSize;
        if (this.mutProb > 0.0) {
            while (this.Mu_next < posiciones) {
                double m;
                int i = this.Mu_next / this.n_genes;
                int j = this.Mu_next % this.n_genes;
                if (this.New.get(i).getGene(j) == 0) {
                    int n = j;
                    this.New.get((int)i).Gene[n] = this.New.get((int)i).Gene[n] + 1;
                } else if (this.New.get((int)i).Gene[j] == this.baseDatos.getnLabels(this.n_var_estado) - 1) {
                    int n = j;
                    this.New.get((int)i).Gene[n] = this.New.get((int)i).Gene[n] - 1;
                } else if (this.New.get((int)i).Gene[j] == this.baseDatos.getnLabels(this.n_var_estado)) {
                    this.New.get((int)i).Gene[j] = Randomize.RandintClosed(0, this.baseDatos.getnLabels(this.n_var_estado) - 1);
                } else {
                    m = Randomize.Rand();
                    if (m < 0.5) {
                        int n = j;
                        this.New.get((int)i).Gene[n] = this.New.get((int)i).Gene[n] + 1;
                    } else {
                        int n = j;
                        this.New.get((int)i).Gene[n] = this.New.get((int)i).Gene[n] - 1;
                    }
                }
                this.New.get(i).setNoEvaluado();
                if (this.mutProb < 1.0) {
                    m = Randomize.Rand();
                    this.Mu_next += (int)Math.ceil(Math.log(m) / Math.log(1.0 - this.mutProb));
                    continue;
                }
                ++this.Mu_next;
            }
        }
        this.Mu_next -= posiciones;
    }

    private void Elitist() {
        int k;
        boolean found = false;
        for (int i = 0; i < this.populationSize && !found; ++i) {
            found = true;
            for (k = 0; k < this.n_genes && found; ++k) {
                found = this.New.get((int)i).Gene[k] == this.Old.get((int)this.Best_guy).Gene[k];
            }
        }
        if (!found) {
            for (k = 0; k < this.n_genes; ++k) {
                this.New.get((int)(this.populationSize - 1)).Gene[k] = this.Old.get((int)this.Best_guy).Gene[k];
            }
            this.New.get((int)(this.populationSize - 1)).Perf = this.Old.get((int)this.Best_guy).Perf;
            this.New.get(this.populationSize - 1).evaluado();
        }
    }

    public static int dameTrials() {
        return Trials_mejor;
    }
}

