/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.realarray;

import java.util.StringTokenizer;
import javolution.xml.XmlElement;
import javolution.xml.XmlFormat;
import net.sf.jclec.IFitness;
import net.sf.jclec.IIndividual;
import net.sf.jclec.base.AbstractIndividual;
import org.apache.commons.lang.builder.EqualsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RealArrayIndividual
extends AbstractIndividual<double[]> {
    protected static final XmlFormat<RealArrayIndividual> XML = new XmlFormat<RealArrayIndividual>(RealArrayIndividual.class){

        @Override
        public void format(RealArrayIndividual source, XmlElement xml) {
            RealArrayIndividual.access$0().format(source, xml);
            int genotypeLenght = ((double[])source.genotype).length;
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < genotypeLenght) {
                sb.append(((double[])source.genotype)[i]);
                if (i != genotypeLenght - 1) {
                    sb.append(" ");
                }
                ++i;
            }
            xml.add(sb.toString(), "genotype", STRING_XML);
        }

        @Override
        public RealArrayIndividual parse(XmlElement xml) {
            RealArrayIndividual result = (RealArrayIndividual)RealArrayIndividual.access$0().parse(xml);
            String genotypeString = (String)xml.get("genotype", STRING_XML);
            StringTokenizer st = new StringTokenizer(genotypeString);
            result.genotype = new double[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                ((double[])((RealArrayIndividual)result).genotype)[i] = Double.parseDouble(st.nextToken());
                ++i;
            }
            return result;
        }

        @Override
        public String defaultName() {
            return "real-array-individual";
        }
    };
    private static final long serialVersionUID = 7013687809733709173L;

    public RealArrayIndividual() {
    }

    public RealArrayIndividual(double[] genotype) {
        super(genotype);
    }

    public RealArrayIndividual(double[] genotype, IFitness fitness) {
        super(genotype, fitness);
    }

    @Override
    public IIndividual copy() {
        int gl = ((double[])this.genotype).length;
        double[] gother = new double[((double[])this.genotype).length];
        System.arraycopy(this.genotype, 0, gother, 0, gl);
        if (this.fitness != null) {
            return new RealArrayIndividual(gother, this.fitness.copy());
        }
        return new RealArrayIndividual(gother);
    }

    @Override
    public double distance(IIndividual other) {
        double[] gother = (double[])((RealArrayIndividual)other).genotype;
        double distance = 0.0;
        int gl = ((double[])this.genotype).length;
        int i = 0;
        while (i < gl) {
            double aux = ((double[])this.genotype)[i] - gother[i];
            distance += aux * aux;
            ++i;
        }
        return Math.sqrt(distance);
    }

    public boolean equals(Object other) {
        if (other instanceof RealArrayIndividual) {
            RealArrayIndividual iaother = (RealArrayIndividual)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append((double[])this.genotype, (double[])iaother.genotype);
            return eb.isEquals();
        }
        return false;
    }

    static /* synthetic */ XmlFormat access$0() {
        return AbstractIndividual.XML;
    }
}

