/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.impl.DBIDInt;
import com.hp.hpl.jena.db.impl.DBPropLSet;
import com.hp.hpl.jena.db.impl.IDBID;
import com.hp.hpl.jena.db.impl.IPSet;
import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.db.impl.SpecializedGraphBase;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.List;

public abstract class SpecializedGraph_TripleStore
extends SpecializedGraphBase {
    public IPSet m_pset;
    public DBPropLSet m_dbPropLSet;
    public IDBID my_GID = null;

    SpecializedGraph_TripleStore(DBPropLSet lProp, IPSet pSet, Integer dbGraphID) {
        this.m_pset = pSet;
        this.m_dbPropLSet = lProp;
        this.my_GID = new DBIDInt(dbGraphID);
    }

    public SpecializedGraph_TripleStore(IPSet pSet, Integer dbGraphID) {
        this.m_pset = pSet;
        this.my_GID = new DBIDInt(dbGraphID);
    }

    public void add(Graph g, SpecializedGraph.CompletionFlag complete) {
        ExtendedIterator it = GraphUtil.findAll(g);
        while (it.hasNext()) {
            this.add((Triple)it.next(), complete);
        }
        complete.setDone();
    }

    public void add(Triple t, SpecializedGraph.CompletionFlag complete) {
        this.m_pset.storeTriple(t, this.my_GID);
        complete.setDone();
    }

    public void add(List triples, SpecializedGraph.CompletionFlag complete) {
        this.m_pset.storeTripleList(triples, this.my_GID);
        complete.setDone();
    }

    public void delete(Triple t, SpecializedGraph.CompletionFlag complete) {
        this.m_pset.deleteTriple(t, this.my_GID);
        complete.setDone();
    }

    public void delete(List triples, SpecializedGraph.CompletionFlag complete) {
        this.m_pset.deleteTripleList(triples, this.my_GID);
        complete.setDone();
    }

    public int tripleCount() {
        return this.m_pset.tripleCount(this.my_GID);
    }

    public boolean contains(Triple t, SpecializedGraph.CompletionFlag complete) {
        complete.setDone();
        return this.m_pset.statementTableContains(this.my_GID, t);
    }

    public ExtendedIterator find(TripleMatch t, SpecializedGraph.CompletionFlag complete) {
        complete.setDone();
        return this.m_pset.find(t, this.my_GID);
    }

    public void close() {
        this.m_pset.close();
    }

    public void clear() {
        this.m_pset.removeStatementsFromDB(this.my_GID);
    }

    public int getGraphId() {
        return ((DBIDInt)this.my_GID).getIntID();
    }

    public IPSet getPSet() {
        return this.m_pset;
    }

    public DBPropLSet getDBPropLSet() {
        return this.m_dbPropLSet;
    }
}

