/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.jdr.sa;

import ec.satoolkit.GenericSaResults;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.ProcQuality;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.data.Periodogram;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.stats.DoornikHansenTest;
import ec.tstoolkit.stats.LjungBoxTest;
import ec.tstoolkit.stats.NiidTests;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jd2.algorithm.IProcResults;
import jd2.information.InformationMapping;

public class ResidualsDiagnostics
implements IProcResults {
    private static final double N0 = 0.1;
    private static final double N1 = 0.01;
    private static final double TD0 = 0.1;
    private static final double TD1 = 0.01;
    private static final double TD2 = 0.001;
    private static final double S0 = 0.1;
    private static final double S1 = 0.01;
    private static final double S2 = 0.001;
    public static final String NORMALITY = "normality";
    public static final String INDEPENDENCE = "independence";
    public static final String TD_PEAK = "tdpeaks";
    public static final String S_PEAK = "seaspeaks";
    public static final String NAME = "Regarima residuals";
    public static List<String> ALL = Collections.unmodifiableList(Arrays.asList("normality", "independence", "tdpeaks", "seaspeaks"));
    private final List<String> warnings_ = new ArrayList<String>();
    private NiidTests stats_;
    private Periodogram periodogram_;
    private int freq_;
    static final InformationMapping<ResidualsDiagnostics> MAPPING = new InformationMapping<ResidualsDiagnostics>(ResidualsDiagnostics.class);

    static ResidualsDiagnostics of(CompositeResults crslts) {
        try {
            PreprocessingModel regarima = GenericSaResults.getPreprocessingModel((CompositeResults)crslts);
            if (regarima instanceof PreprocessingModel) {
                return new ResidualsDiagnostics(regarima);
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public ResidualsDiagnostics(PreprocessingModel rslts) {
        this.testRegarima(rslts);
    }

    private boolean testRegarima(PreprocessingModel regarima) {
        try {
            TsData res = regarima.getFullResiduals();
            this.freq_ = res.getFrequency().intValue();
            this.stats_ = new NiidTests((IReadDataBlock)res, this.freq_, regarima.description.getArimaComponent().getFreeParametersCount(), true);
            this.periodogram_ = new Periodogram((IReadDataBlock)res);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public String getName() {
        return NAME;
    }

    public List<String> getTests() {
        return ALL;
    }

    public ProcQuality getDiagnostic(String test) {
        double pval = 0.0;
        switch (test) {
            case "normality": {
                if (this.stats_ == null) {
                    return ProcQuality.Undefined;
                }
                DoornikHansenTest dht = this.stats_.getNormalityTest();
                if (dht == null) {
                    return ProcQuality.Undefined;
                }
                pval = dht.getPValue();
                if (pval > 0.1) {
                    return ProcQuality.Good;
                }
                if (pval < 0.01) {
                    return ProcQuality.Bad;
                }
                return ProcQuality.Uncertain;
            }
            case "independence": {
                if (this.stats_ == null) {
                    return ProcQuality.Undefined;
                }
                LjungBoxTest lbt = this.stats_.getLjungBox();
                if (lbt == null) {
                    return ProcQuality.Undefined;
                }
                pval = lbt.getPValue();
                if (pval > 0.1) {
                    return ProcQuality.Good;
                }
                if (pval < 0.01) {
                    return ProcQuality.Bad;
                }
                return ProcQuality.Uncertain;
            }
            case "tdpeaks": {
                if (this.periodogram_ == null) {
                    return ProcQuality.Undefined;
                }
                double[] tdfreqs = Periodogram.getTradingDaysFrequencies((int)this.freq_);
                double[] p = this.periodogram_.getS();
                double xmax = 0.0;
                double dstep = this.periodogram_.getIntervalInRadians();
                for (int i = 0; i < tdfreqs.length; ++i) {
                    int i0 = (int)(tdfreqs[i] / dstep);
                    double xcur = p[i0];
                    if (xcur > xmax) {
                        xmax = xcur;
                    }
                    if (!((xcur = p[i0 + 1]) > xmax)) continue;
                    xmax = xcur;
                }
                pval = 1.0 - Math.pow(1.0 - Math.exp(-xmax * 0.5), tdfreqs.length);
                if (pval < 0.001) {
                    return ProcQuality.Severe;
                }
                if (pval < 0.01) {
                    return ProcQuality.Bad;
                }
                if (pval > 0.1) {
                    return ProcQuality.Good;
                }
                return ProcQuality.Uncertain;
            }
            case "seaspeaks": {
                if (this.periodogram_ == null) {
                    return ProcQuality.Undefined;
                }
                double[] seasfreqs = new double[(this.freq_ - 1) / 2];
                for (int i = 0; i < seasfreqs.length; ++i) {
                    seasfreqs[i] = (double)((i + 1) * 2) * Math.PI / (double)this.freq_;
                }
                double[] p = this.periodogram_.getS();
                double xmax = 0.0;
                double dstep = this.periodogram_.getIntervalInRadians();
                for (int i = 0; i < seasfreqs.length; ++i) {
                    int i0 = (int)(seasfreqs[i] / dstep);
                    double xcur = p[i0];
                    if (xcur > xmax) {
                        xmax = xcur;
                    }
                    if (!((xcur = p[i0 + 1]) > xmax)) continue;
                    xmax = xcur;
                }
                pval = 1.0 - Math.pow(1.0 - Math.exp(-xmax * 0.5), seasfreqs.length);
                if (pval < 0.001) {
                    return ProcQuality.Severe;
                }
                if (pval < 0.01) {
                    return ProcQuality.Bad;
                }
                if (pval > 0.1) {
                    return ProcQuality.Good;
                }
                return ProcQuality.Uncertain;
            }
        }
        return ProcQuality.Undefined;
    }

    public double getValue(String test) {
        try {
            double pval = 0.0;
            switch (test) {
                case "normality": {
                    if (this.stats_ == null) break;
                    DoornikHansenTest dht = this.stats_.getNormalityTest();
                    pval = dht.getPValue();
                    break;
                }
                case "independence": {
                    if (this.stats_ == null) break;
                    LjungBoxTest lbt = this.stats_.getLjungBox();
                    pval = lbt.getPValue();
                    break;
                }
                case "tdpeaks": {
                    if (this.periodogram_ == null) break;
                    double[] tdfreqs = Periodogram.getTradingDaysFrequencies((int)this.freq_);
                    double[] p = this.periodogram_.getS();
                    double xmax = 0.0;
                    double dstep = this.periodogram_.getIntervalInRadians();
                    for (int i = 0; i < tdfreqs.length; ++i) {
                        int i0 = (int)(tdfreqs[i] / dstep);
                        double xcur = p[i0];
                        if (xcur > xmax) {
                            xmax = xcur;
                        }
                        if (!((xcur = p[i0 + 1]) > xmax)) continue;
                        xmax = xcur;
                    }
                    pval = 1.0 - Math.pow(1.0 - Math.exp(-xmax * 0.5), tdfreqs.length);
                    break;
                }
                case "seaspeaks": {
                    if (this.periodogram_ == null) break;
                    double[] seasfreqs = new double[(this.freq_ - 1) / 2];
                    for (int i = 0; i < seasfreqs.length; ++i) {
                        seasfreqs[i] = (double)((i + 1) * 2) * Math.PI / (double)this.freq_;
                    }
                    double[] p = this.periodogram_.getS();
                    double xmax = 0.0;
                    double dstep = this.periodogram_.getIntervalInRadians();
                    for (int i = 0; i < seasfreqs.length; ++i) {
                        int i0 = (int)(seasfreqs[i] / dstep);
                        double xcur = p[i0];
                        if (xcur > xmax) {
                            xmax = xcur;
                        }
                        if (!((xcur = p[i0 + 1]) > xmax)) continue;
                        xmax = xcur;
                    }
                    pval = 1.0 - Math.pow(1.0 - Math.exp(-xmax * 0.5), seasfreqs.length);
                    break;
                }
            }
            return pval;
        }
        catch (Exception err) {
            return Double.NaN;
        }
    }

    public List<String> getWarnings() {
        return this.warnings_;
    }

    public double getNIIDBound(ProcQuality quality) {
        switch (quality) {
            case Bad: {
                return 0.01;
            }
            case Uncertain: {
                return 0.1;
            }
        }
        return Double.NaN;
    }

    public double getTDPeriodogram(ProcQuality quality) {
        switch (quality) {
            case Severe: {
                return 0.001;
            }
            case Bad: {
                return 0.01;
            }
            case Uncertain: {
                return 0.1;
            }
        }
        return Double.NaN;
    }

    public double getSPeriodogram(ProcQuality quality) {
        switch (quality) {
            case Severe: {
                return 0.001;
            }
            case Bad: {
                return 0.01;
            }
            case Uncertain: {
                return 0.1;
            }
        }
        return Double.NaN;
    }

    public static InformationMapping<ResidualsDiagnostics> getMapping() {
        return MAPPING;
    }

    @Override
    public boolean contains(String id) {
        return MAPPING.contains(id);
    }

    @Override
    public Map<String, Class> getDictionary() {
        LinkedHashMap<String, Class> dic = new LinkedHashMap<String, Class>();
        MAPPING.fillDictionary(null, dic, true);
        return dic;
    }

    @Override
    public <T> T getData(String id, Class<T> tclass) {
        return MAPPING.getData(this, id, tclass);
    }

    static {
        MAPPING.set("normality.value", Double.class, source -> source.getValue(NORMALITY));
        MAPPING.set(NORMALITY, String.class, source -> source.getDiagnostic(NORMALITY).name());
        MAPPING.set("independence.value", Double.class, source -> source.getValue(INDEPENDENCE));
        MAPPING.set(INDEPENDENCE, String.class, source -> source.getDiagnostic(INDEPENDENCE).name());
        MAPPING.set("tdpeaks.value", Double.class, source -> source.getValue(TD_PEAK));
        MAPPING.set(TD_PEAK, String.class, source -> source.getDiagnostic(TD_PEAK).name());
        MAPPING.set("seaspeaks.value", Double.class, source -> source.getValue(S_PEAK));
        MAPPING.set(S_PEAK, String.class, source -> source.getDiagnostic(S_PEAK).name());
    }
}

