/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.eco.DiffuseLikelihood;
import ec.tstoolkit.eco.Likelihood;
import ec.tstoolkit.ssf.DiffuseFilteringResults;
import ec.tstoolkit.ssf.DiffusePredictionErrorDecomposition;
import ec.tstoolkit.ssf.ResidualsCumulator;

public final class LikelihoodEvaluation {
    public static void evaluate(DiffuseFilteringResults rslts, DiffuseLikelihood ll) {
        int n = rslts.getObsCount();
        int d = rslts.getDiffuseCount();
        double ssqerr = rslts.getSsqErr();
        double ldet = rslts.getLogDeterminant();
        double lddet = rslts.getDiffuseLogDeterminant();
        ll.set(ssqerr, ldet, lddet, n + d, d);
        ll.setRes(rslts.getFilteredData().data(true, true));
    }

    public static void evaluate(DiffusePredictionErrorDecomposition rslts, DiffuseLikelihood ll) {
        int n = rslts.getObsCount();
        int d = rslts.getDiffuseCount();
        double ssqerr = rslts.getSsqErr();
        double ldet = rslts.getLogDeterminant();
        double lddet = rslts.getDiffuseLogDeterminant();
        ll.set(ssqerr, ldet, lddet, n + d, d);
        ll.setRes(rslts.residuals(true));
    }

    public static void evaluate(ResidualsCumulator rslts, DiffuseLikelihood ll) {
        int n = rslts.getObsCount();
        double ssqerr = rslts.getSsqErr();
        double ldet = rslts.getLogDeterminant();
        ll.set(ssqerr, ldet, 0.0, n, 0);
    }

    public static void evaluate(ResidualsCumulator rslts, Likelihood ll) {
        int n = rslts.getObsCount();
        double ssqerr = rslts.getSsqErr();
        double ldet = rslts.getLogDeterminant();
        ll.set(ssqerr, ldet, n);
    }

    private LikelihoodEvaluation() {
    }
}

