/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.arima.estimation.RegArimaEstimation;
import ec.tstoolkit.arima.estimation.RegArimaModel;
import ec.tstoolkit.data.ReadDataBlock;
import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.modelling.arima.IModelBuilder;
import ec.tstoolkit.modelling.arima.IModelController;
import ec.tstoolkit.modelling.arima.IModelEstimator;
import ec.tstoolkit.modelling.arima.IOutliersDetectionModule;
import ec.tstoolkit.modelling.arima.IPreprocessingModule;
import ec.tstoolkit.modelling.arima.IPreprocessor;
import ec.tstoolkit.modelling.arima.ISeriesScaling;
import ec.tstoolkit.modelling.arima.ModelDescription;
import ec.tstoolkit.modelling.arima.ModelEstimation;
import ec.tstoolkit.modelling.arima.ModelStatistics;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.modelling.arima.ProcessingResult;
import ec.tstoolkit.modelling.arima.tramo.AbstractTramoModule;
import ec.tstoolkit.modelling.arima.tramo.DefaultModelBuilder;
import ec.tstoolkit.modelling.arima.tramo.FinalEstimator;
import ec.tstoolkit.modelling.arima.tramo.ModelEstimator;
import ec.tstoolkit.modelling.arima.tramo.SeasonalityController;
import ec.tstoolkit.modelling.arima.tramo.SeasonalityDetector;
import ec.tstoolkit.modelling.arima.tramo.TramoException;
import ec.tstoolkit.modelling.arima.tramo.TramoModelEstimator;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;
import ec.tstoolkit.stats.LjungBoxTest;
import ec.tstoolkit.timeseries.TsPeriodSelector;
import ec.tstoolkit.timeseries.simplets.ITsDataInterpolator;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import java.util.ArrayList;
import java.util.List;

public class TramoProcessor
extends AbstractTramoModule
implements IPreprocessor {
    public TsPeriodSelector estimationSpan;
    public SeasonalityDetector seas;
    public IModelBuilder builder;
    public ISeriesScaling scaling;
    public ITsDataInterpolator missing;
    public IPreprocessingModule loglevelTest;
    public IPreprocessingModule regressionTest;
    public IOutliersDetectionModule outliers;
    public IPreprocessingModule differencing;
    public IPreprocessingModule autoModelling;
    public IPreprocessingModule regressionTest2;
    public IPreprocessingModule regressionTest3;
    public IModelController seasonalityController = new SeasonalityController();
    public FinalEstimator finalizer;
    public List<IModelController> controllers = new ArrayList<IModelController>();
    public IModelController benchmarking;
    private final IModelBuilder defaultBuilder = new DefaultModelBuilder();
    private boolean mu_;
    private boolean pass3_;
    private boolean dfm_;
    private double pcr_ = 0.95;
    private double cpcr_;
    private boolean fal_ = false;
    private double tsig_ = 1.0;
    private int pass_ = 0;
    private int round_ = 0;
    private PreprocessingModel reference_;
    private ModelStatistics refstats_;
    private boolean needOutliers_;
    private boolean needAutoModelling_;
    private static final String MODEL_TEST = "Model test";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreprocessingModel calc(ModellingContext context) {
        try {
            if (this.builder != null) {
                this.builder.initialize(context);
            } else {
                this.defaultBuilder.initialize(context);
            }
            if (!this.initContext(context)) {
                PreprocessingModel preprocessingModel = null;
                return preprocessingModel;
            }
            if (context.description.isFullySpecified() && this.outliers == null) {
                IParametricMapping<SarimaModel> mapping = context.description.defaultMapping();
                ModelDescription model = context.description;
                RegArimaModel<SarimaModel> regarima = model.buildRegArima();
                TramoModelEstimator monitor = new TramoModelEstimator(mapping);
                monitor.getMinimizer().setMaxIter(1);
                monitor.optimize(regarima);
                ModelEstimation estimation = new ModelEstimation(regarima, model.getLikelihoodCorrection());
                estimation.computeLikelihood(mapping.getDim());
                estimation.updateParametersCovariance(monitor.getParametersCovariance());
                context.estimation = estimation;
                PreprocessingModel preprocessingModel = context.current(true);
                return preprocessingModel;
            }
            this.checkSeasonality(context);
            if (this.loglevelTest != null) {
                this.loglevelTest.process(context);
            }
            if (this.regressionTest != null) {
                this.regressionTest.process(context);
            }
            this.initProcessing();
            int iter = 0;
            while (++iter < 10 && !this.iterate(context)) {
            }
            if (!this.update(context)) {
                PreprocessingModel preprocessingModel = null;
                return preprocessingModel;
            }
            PreprocessingModel preprocessingModel = context.current(true);
            return preprocessingModel;
        }
        catch (Exception err) {
            PreprocessingModel preprocessingModel = null;
            return preprocessingModel;
        }
        finally {
            this.clear();
        }
    }

    private void initProcessing() {
        this.needOutliers_ = this.outliers != null;
        this.needAutoModelling_ = false;
        this.round_ = 0;
    }

    private boolean iterate(ModellingContext context) {
        if (!context.description.isRegressionPrespecified() || context.outliers || context.automodelling) {
            this.update(context);
            boolean changed = false;
            SarimaSpecification curspec = context.description.getSpecification();
            boolean curmu = context.description.isMean();
            if (this.needDifferencing(context)) {
                this.execDifferencing(context);
            }
            if (this.needAutoModelling(context)) {
                this.execAutoModelling(context);
                boolean bl = changed = !context.description.getSpecification().equals((Object)curspec) || context.description.isEstimatedMean() != curmu;
                if (this.round_ == 1) {
                    boolean bl2 = this.needOutliers_ = this.outliers != null && changed;
                }
            }
            if (this.needOutliers(context)) {
                boolean autoOut = this.execOutliers(context);
                boolean bl = changed = changed || autoOut;
            }
            if (!this.estimateModel(context)) {
                this.needOutliers_ = this.outliers != null;
                this.needAutoModelling_ = this.differencing != null;
                ++this.round_;
                ++this.pass_;
                return false;
            }
            if (this.round_ == 0) {
                this.needOutliers_ = this.outliers != null;
                this.needAutoModelling_ = this.differencing != null;
                ++this.round_;
                ++this.pass_;
                this.reference_ = context.current(true);
                this.refstats_ = new ModelStatistics(this.reference_);
                this.addModelInfo(this.refstats_, context, true);
                return this.fal_ && 1.0 - this.refstats_.ljungBoxPvalue < this.getPcr();
            }
            if (this.pass_ <= 3 && !this.pass3_ && this.autoModelling != null && !this.pass2(!changed, context)) {
                return false;
            }
            if (this.regressionTest3.process(context) != ProcessingResult.Unchanged) {
                this.pass_ = 4;
                this.needAutoModelling_ = false;
                this.needOutliers_ = false;
                return false;
            }
            ModelEstimator estimator = new ModelEstimator();
            estimator.setOutliersDetectionModule(this.outliers);
            estimator.setPrecision(this.finalizer.getEpsilon());
            if (context.automodelling) {
                this.seasonalityController.setEstimator(estimator);
                if (this.seasonalityController.process(context) == ProcessingResult.Changed && !this.pass3_) {
                    this.pass3_ = true;
                    this.needAutoModelling_ = true;
                    this.needOutliers_ = this.outliers != null;
                    this.pass_ = 1;
                    return false;
                }
            }
            this.control(context, estimator);
            return true;
        }
        if (this.finalizer.estimate(context)) {
            return true;
        }
        context.information.addError("Tramo final estimation failed");
        throw new TramoException("Unable to estimate the model");
    }

    void setFal(boolean b) {
        this.fal_ = b;
    }

    boolean isFal() {
        return this.fal_;
    }

    private void control(ModellingContext context, ModelEstimator estimator) {
        boolean changed = false;
        for (IModelController controller : this.controllers) {
            try {
                controller.setEstimator(estimator);
                ProcessingResult rslt = controller.process(context);
                if (rslt != ProcessingResult.Changed) continue;
                changed = true;
            }
            catch (Exception exception) {}
        }
    }

    private boolean needDifferencing(ModellingContext context) {
        if (!this.needAutoModelling_) {
            return false;
        }
        if (this.round_ == 2 && context.description.getOutliers().isEmpty()) {
            return false;
        }
        SarimaSpecification curspec = context.description.getSpecification();
        return this.round_ != 2 || curspec.getBD() != 2 || curspec.getD() != 1;
    }

    private boolean execDifferencing(ModellingContext context) {
        boolean changed;
        if (context.estimation == null) {
            ModelEstimation estimation = new ModelEstimation(context.description.buildRegArima(), context.description.getLikelihoodCorrection());
            estimation.compute(this.getMonitor(), context.description.getArimaComponent().getFreeParametersCount());
        }
        SarimaSpecification prevspec = context.description.getSpecification();
        if (this.round_ == 1) {
            context.description.setSpecification(new SarimaSpecification(context.description.getFrequency()));
        }
        ProcessingResult drslt = this.differencing.process(context);
        SarimaSpecification curspec = context.description.getSpecification();
        boolean bl = changed = drslt == ProcessingResult.Changed;
        if (this.pass_ == 1) {
            boolean bl2 = changed = prevspec.getD() != curspec.getD() || prevspec.getBD() != curspec.getBD();
            if (changed) {
                context.description.setOutliers(null);
                context.estimation = null;
            }
        }
        return changed;
    }

    private boolean needAutoModelling(ModellingContext context) {
        if (!this.needAutoModelling_) {
            return false;
        }
        return this.round_ != 2 || !context.description.getOutliers().isEmpty();
    }

    private boolean execAutoModelling(ModellingContext context) {
        SarimaSpecification prevspec = context.description.getSpecification();
        ProcessingResult autorslt = this.autoModelling.process(context);
        SarimaSpecification curspec = context.description.getSpecification();
        if (curspec.getParametersCount() == 0) {
            if (this.pass_ >= 3) {
                context.description.setSpecification(prevspec);
                return false;
            }
            curspec.setQ(1);
            context.description.setSpecification(curspec);
            return true;
        }
        return !prevspec.equals((Object)curspec);
    }

    private boolean needOutliers(ModellingContext context) {
        return this.needOutliers_;
    }

    private boolean execOutliers(ModellingContext context) {
        context.description.setOutliers(null);
        context.estimation = null;
        ProcessingResult autoout = this.outliers.process(context);
        return autoout == ProcessingResult.Changed;
    }

    @Override
    public PreprocessingModel process(TsData originalTs, ModellingContext context) {
        this.clear();
        if (context == null) {
            context = new ModellingContext();
        }
        context.description = new ModelDescription(originalTs, this.estimationSpan == null ? null : originalTs.getDomain().select(this.estimationSpan));
        PreprocessingModel rslt = this.calc(context);
        if (rslt != null) {
            rslt.info_ = context.information;
            rslt.addProcessingInformation(context.processingLog);
        }
        return rslt;
    }

    private void restore(ModellingContext context) {
        context.description = this.reference_.description.clone();
        context.estimation = this.reference_.estimation;
        context.information.clear();
        context.information.copy(this.reference_.info_);
    }

    static int autlar(int n, SarimaSpecification spec) {
        int d = spec.getD() + spec.getFrequency() * spec.getBD();
        int q = spec.getQ() + spec.getFrequency() * spec.getBQ();
        int p = spec.getP() + spec.getFrequency() * spec.getBP();
        int nd = n - d;
        int nar = (int)Math.log(nd * nd);
        int m = Math.max(p, 2 * q);
        if (m > nar) {
            nar = m;
        }
        if (nar >= nd) {
            nar = nd - nd / 4;
        }
        if (nar > 50) {
            nar = 50;
        }
        int ncol = spec.getP() + (1 + spec.getP()) * spec.getBP() + spec.getQ() + (1 + spec.getQ()) * spec.getBQ();
        return nd - nar - Math.max(p, q) - ncol;
    }

    static boolean meantest(int n, double t) {
        double vct = 2.5;
        if (n <= 80) {
            vct = 1.96;
        } else if (n <= 155) {
            vct = 1.98;
        } else if (n <= 230) {
            vct = 2.1;
        } else if (n <= 320) {
            vct = 2.3;
        }
        return Math.abs(t) > vct;
    }

    public static int calcLBLength(int freq) {
        int n = freq == 12 ? 24 : (freq == 1 ? 8 : 4 * freq);
        return n;
    }

    static double PLjungBox(int freq, double[] res, int hp) {
        int n = TramoProcessor.calcLBLength(freq);
        LjungBoxTest lb = new LjungBoxTest();
        lb.setHyperParametersCount(hp);
        lb.setK(n);
        lb.test(new ReadDataBlock(res));
        return 1.0 - lb.getPValue();
    }

    public static double PLjungBox(RegArimaEstimation<SarimaModel> gls) {
        SarimaSpecification spec = ((SarimaModel)gls.model.getArima()).getSpecification();
        return TramoProcessor.PLjungBox(spec.getFrequency(), gls.likelihood.getResiduals(), spec.getParametersCount());
    }

    protected boolean pass2(boolean same, ModellingContext context) {
        double fct = 1.0;
        double fct2 = 1.0;
        boolean useprev = false;
        SarimaModel curmodel = context.estimation.getRegArima().getArima();
        SarimaSpecification curspec = curmodel.getSpecification();
        PreprocessingModel cur = context.current(true);
        ModelStatistics stats = new ModelStatistics(cur);
        double plbox = 1.0 - stats.ljungBoxPvalue;
        double rvr = stats.se;
        if (this.reference_ != null) {
            double plbox0 = 1.0 - this.refstats_.ljungBoxPvalue;
            double rvr0 = this.refstats_.se;
            this.addModelInfo(stats, context, false);
            if (this.reference_.description.getOutliers().size() <= context.description.getOutliers().size() && (plbox < 0.95 && plbox0 < 0.75 && rvr0 < rvr || this.pass_ == 1 && plbox >= 0.95 && plbox0 < 0.95 || plbox < 0.95 && plbox0 < 0.75 && plbox0 < plbox && rvr0 < fct * rvr || plbox >= 0.95 && plbox0 < 0.95 && rvr0 < fct2 * rvr || curspec.getD() == 0 && curspec.getBD() == 1 && curspec.getP() == 1 && curmodel.phi(1) <= -0.82 && curspec.getQ() <= 1 && curspec.getBP() == 0 && curspec.getBQ() == 1 || curspec.getD() == 1 && curspec.getBD() == 0 && curspec.getP() == 0 && curspec.getQ() == 1 && curspec.getBP() == 1 && curmodel.getParameter(0) <= -0.65 && curspec.getBQ() <= 1)) {
                useprev = true;
            }
            if (!useprev) {
                this.reference_ = cur;
                this.refstats_ = stats;
            } else {
                this.restore(context);
                plbox = plbox0;
            }
        } else {
            this.reference_ = cur;
            this.refstats_ = stats;
        }
        if (this.pass_ == 1) {
            this.cpcr_ += 0.025;
        } else if (this.pass_ >= 2) {
            this.cpcr_ += 0.015;
        }
        if (plbox <= this.cpcr_) {
            return true;
        }
        if (this.pass_ == 1 && this.outliers != null) {
            this.outliers.reduceSelectivity();
        }
        ++this.round_;
        ++this.pass_;
        if (this.pass_ <= 2) {
            this.needAutoModelling_ = !same;
            this.needOutliers_ = this.outliers != null;
        } else {
            this.lastSolution(context);
            this.needAutoModelling_ = false;
        }
        return false;
    }

    private void lastSolution(ModellingContext context) {
        SarimaSpecification nspec = context.description.getSpecification();
        switch (nspec.getFrequency()) {
            case 2: {
                nspec.setP(1);
                break;
            }
            case 3: {
                nspec.setP(2);
                break;
            }
            default: {
                nspec.setP(3);
            }
        }
        if (nspec.getBD() > 0) {
            nspec.setBP(0);
        }
        nspec.setQ(1);
        if (context.hasseas) {
            nspec.setBQ(1);
        }
        context.description.setSpecification(nspec);
        context.description.setOutliers(null);
        context.estimation = null;
        this.round_ = 1;
        this.needOutliers_ = this.outliers != null;
        this.needAutoModelling_ = false;
    }

    private void clear() {
        this.pass_ = 0;
        this.pass3_ = false;
        this.round_ = 0;
        this.cpcr_ = this.pcr_;
        this.reference_ = null;
        this.refstats_ = null;
        if (this.outliers != null) {
            this.outliers.setSelectivity(0);
        }
        this.dfm_ = false;
        this.seasonalityController.setReferenceModel(null);
        for (IModelController controller : this.controllers) {
            controller.setReferenceModel(null);
        }
    }

    private boolean initContext(ModellingContext context) {
        context.automodelling = this.autoModelling != null;
        boolean bl = context.outliers = this.outliers != null;
        if (this.scaling != null && !this.scaling.process(context)) {
            return false;
        }
        return this.missing == null || context.description.updateMissing(this.missing);
    }

    private void checkSeasonality(ModellingContext context) {
        if (this.seas != null) {
            this.seas.process(context);
        } else {
            context.hasseas = TramoProcessor.checkSeasonality(context.description.transformedOriginal());
        }
        int ifreq = context.description.getFrequency();
        if (context.automodelling && !context.hasseas && ifreq > 1) {
            SarimaSpecification nspec = new SarimaSpecification(ifreq);
            nspec.setD(1);
            nspec.setQ(1);
            context.description.setSpecification(nspec);
            context.estimation = null;
        }
    }

    private boolean estimateModel(ModellingContext context) {
        this.finalizer.setPass(this.pass_);
        int niter = 0;
        do {
            if (!this.finalizer.estimate(context)) {
                if (this.pass_ == 1 && context.automodelling && context.outliers) {
                    this.outliers.reduceSelectivity();
                }
                return false;
            }
            if (!this.pass3_ && this.pass_ == 0) continue;
            return true;
        } while (niter++ < 5 && this.regressionTest2.process(context) == ProcessingResult.Changed);
        return true;
    }

    private boolean update(ModellingContext context) {
        try {
            if (context.estimation != null) {
                return true;
            }
            IParametricMapping<SarimaModel> mapping = context.description.defaultMapping();
            ModelDescription model = context.description;
            context.estimation = new ModelEstimation(model.buildRegArima(), model.getLikelihoodCorrection());
            int ndim = mapping.getDim();
            TramoModelEstimator monitor = new TramoModelEstimator(mapping);
            if (context.description.isPartiallySpecified()) {
                context.estimation.improve(monitor, ndim);
            } else {
                context.estimation.compute(monitor, ndim);
            }
            context.estimation.updateParametersCovariance(monitor.getParametersCovariance());
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }

    public boolean isDfm() {
        return this.dfm_;
    }

    public void setDfm(boolean dfm_) {
        this.dfm_ = dfm_;
    }

    public double getPcr() {
        return this.pcr_;
    }

    public void setPcr(double pcr_) {
        this.pcr_ = pcr_;
    }

    public double getTsig() {
        return this.tsig_;
    }

    public void setTsig_(double tsig_) {
        this.tsig_ = tsig_;
    }

    public static boolean checkSeasonality(TsData s) {
        if (s.getFrequency() == TsFrequency.Yearly) {
            return false;
        }
        TsData delta = s.delta(1);
        int k = 3;
        int ifreq = s.getFrequency().intValue();
        if (k * ifreq >= delta.getLength()) {
            k = 2;
        }
        LjungBoxTest lb = new LjungBoxTest();
        lb.setLag(ifreq);
        lb.setK(k);
        lb.test(delta);
        lb.setSignificanceThreshold(0.1);
        return !lb.isValid() || lb.isSignificant();
    }

    public IModelEstimator getEstimator() {
        ModelEstimator e = new ModelEstimator();
        e.setOutliersDetectionModule(this.outliers);
        e.setPrecision(this.finalizer.getEpsilon());
        return e;
    }

    private void addModelInfo(ModelStatistics stats, ModellingContext context, boolean initial) {
    }
}

