/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.util;

import umontreal.iro.lecuyer.util.MultivariateFunction;

public class RatioFunction
implements MultivariateFunction {
    private double zeroOverZero = Double.NaN;

    public RatioFunction() {
    }

    public RatioFunction(double d) {
        this.zeroOverZero = d;
    }

    public double getZeroOverZeroValue() {
        return this.zeroOverZero;
    }

    public void setZeroOverZeroValue(double d) {
        this.zeroOverZero = d;
    }

    public int getDimension() {
        return 2;
    }

    public double evaluate(double ... dArray) {
        if (dArray.length != 2) {
            throw new IllegalArgumentException("Invalid length of x");
        }
        if (dArray[0] == 0.0 && dArray[1] == 0.0) {
            return this.zeroOverZero;
        }
        return dArray[0] / dArray[1];
    }

    public double evaluateGradient(int n, double ... dArray) {
        if (dArray.length != 2) {
            throw new IllegalArgumentException("Invalid length of x");
        }
        switch (n) {
            case 0: {
                return 1.0 / dArray[1];
            }
            case 1: {
                return -dArray[0] / (dArray[1] * dArray[1]);
            }
        }
        throw new IndexOutOfBoundsException("Invalid value of i: " + n);
    }
}

