/*
 * Decompiled with CFR 0.152.
 */
package org.af.jhlir.tools;

import ca.beq.util.win32.registry.RegistryKey;
import ca.beq.util.win32.registry.RootKey;
import ca.beq.util.win32.registry.Win32Exception;

public class RegistryManager {
    private static String getValue(RootKey rootKey, String path, String key) {
        RegistryKey r = new RegistryKey(rootKey, path);
        if (!r.exists()) {
            return null;
        }
        try {
            return r.getValue(key).getStringValue();
        }
        catch (Win32Exception e) {
            return null;
        }
    }

    private static String getRegistryPathforR(String version) {
        return "Software\\R-core\\R\\" + version;
    }

    private static String findRVersion(RootKey rootKey) {
        return RegistryManager.getValue(rootKey, "Software\\R-core\\R", "Current Version");
    }

    private static String findInstallPath(RootKey rootKey, String version) {
        return RegistryManager.getValue(rootKey, RegistryManager.getRegistryPathforR(version), "InstallPath");
    }

    public static String getInstallPath() {
        String version = null;
        String instPath = null;
        version = RegistryManager.findRVersion(RootKey.HKEY_CURRENT_USER);
        if (version != null && (instPath = RegistryManager.findInstallPath(RootKey.HKEY_CURRENT_USER, version)) != null) {
            return instPath;
        }
        version = RegistryManager.findRVersion(RootKey.HKEY_LOCAL_MACHINE);
        if (version != null && (instPath = RegistryManager.findInstallPath(RootKey.HKEY_LOCAL_MACHINE, version)) != null) {
            return instPath;
        }
        return null;
    }
}

