/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.substmodel;

import java.io.Serializable;
import jebl.evolution.substmodel.RateMatrix;
import jebl.util.Utils;

public class MatrixExponential
implements Cloneable,
Serializable {
    private final double[] Eval;
    private final double[][] Evec;
    private final double[][] Ievc;
    private final double[][] iexp;
    private final int[] ordr;
    private final double[] evali;
    private final double[][] amat;
    private final int dimension_;
    private final double[][] transProb;
    private double cr;
    private double ci;

    public MatrixExponential(int dimension) {
        this.dimension_ = dimension;
        if (dimension <= 0) {
            throw new IllegalArgumentException("Invalid dimension:" + dimension);
        }
        this.transProb = new double[dimension][dimension];
        this.Eval = new double[dimension];
        this.Evec = new double[dimension][dimension];
        this.Ievc = new double[dimension][dimension];
        this.iexp = new double[dimension][dimension];
        this.amat = new double[dimension][dimension];
        this.ordr = new int[dimension];
        this.evali = new double[dimension];
    }

    public MatrixExponential(RateMatrix r) {
        int dimension;
        this.dimension_ = dimension = r.getDimension();
        this.transProb = new double[dimension][dimension];
        this.Eval = new double[dimension];
        this.Evec = new double[dimension][dimension];
        this.Ievc = new double[dimension][dimension];
        this.iexp = new double[dimension][dimension];
        this.amat = new double[dimension][dimension];
        this.ordr = new int[dimension];
        this.evali = new double[dimension];
        this.setMatrix(r);
    }

    public final double getTransitionProbability(int from, int to) {
        return this.transProb[from][to];
    }

    public int getDimension() {
        return this.dimension_;
    }

    public void updateByRelativeRates(double[][] relativeRates) {
        for (int i = 0; i < this.dimension_; ++i) {
            System.arraycopy(relativeRates[i], 0, this.amat[i], 0, this.dimension_);
        }
        this.elmhes(this.amat, this.ordr, this.dimension_);
        this.eltran(this.amat, this.Evec, this.ordr, this.dimension_);
        this.hqr2(this.dimension_, 1, this.dimension_, this.amat, this.Evec, this.Eval, this.evali);
        this.luinverse(this.Evec, this.Ievc, this.dimension_);
    }

    public void setMatrix(RateMatrix r) {
        this.updateByRelativeRates(r.getRelativeRates());
    }

    public final void getTransitionProbabilities(double[][] probabilityStore) {
        if (probabilityStore == null) {
            throw new RuntimeException("Assertion Error: probabilityStore == null");
        }
        Utils.copy(this.transProb, probabilityStore);
    }

    public final void setDistance(double arc) {
        int j;
        double temp;
        int k;
        for (k = 0; k < this.dimension_; ++k) {
            temp = Math.exp(arc * this.Eval[k]);
            for (j = 0; j < this.dimension_; ++j) {
                this.iexp[k][j] = this.Ievc[k][j] * temp;
            }
        }
        for (int i = 0; i < this.dimension_; ++i) {
            for (j = 0; j < this.dimension_; ++j) {
                temp = 0.0;
                for (k = 0; k < this.dimension_; ++k) {
                    temp += this.Evec[i][k] * this.iexp[k][j];
                }
                this.transProb[i][j] = Math.abs(temp);
            }
        }
    }

    public final void setDistanceTranspose(double arc) {
        int j;
        double temp;
        int k;
        for (k = 0; k < this.dimension_; ++k) {
            temp = Math.exp(arc * this.Eval[k]);
            for (j = 0; j < this.dimension_; ++j) {
                this.iexp[k][j] = this.Ievc[k][j] * temp;
            }
        }
        for (int i = 0; i < this.dimension_; ++i) {
            for (j = 0; j < this.dimension_; ++j) {
                temp = 0.0;
                for (k = 0; k < this.dimension_; ++k) {
                    temp += this.Evec[i][k] * this.iexp[k][j];
                }
                this.transProb[j][i] = Math.abs(temp);
            }
        }
    }

    private void elmhes(double[][] a, int[] ordr, int n) {
        int i;
        for (i = 0; i < n; ++i) {
            ordr[i] = 0;
        }
        for (int m = 2; m < n; ++m) {
            double y;
            int j;
            double x = 0.0;
            i = m;
            for (j = m; j <= n; ++j) {
                if (!(Math.abs(a[j - 1][m - 2]) > Math.abs(x))) continue;
                x = a[j - 1][m - 2];
                i = j;
            }
            ordr[m - 1] = i;
            if (i != m) {
                for (j = m - 2; j < n; ++j) {
                    y = a[i - 1][j];
                    a[i - 1][j] = a[m - 1][j];
                    a[m - 1][j] = y;
                }
                for (j = 0; j < n; ++j) {
                    y = a[j][i - 1];
                    a[j][i - 1] = a[j][m - 1];
                    a[j][m - 1] = y;
                }
            }
            if (x == 0.0) continue;
            for (i = m; i < n; ++i) {
                y = a[i][m - 2];
                if (y == 0.0) continue;
                a[i][m - 2] = y /= x;
                for (j = m - 1; j < n; ++j) {
                    double[] dArray = a[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] - y * a[m - 1][j];
                }
                for (j = 0; j < n; ++j) {
                    double[] dArray = a[j];
                    int n3 = m - 1;
                    dArray[n3] = dArray[n3] + y * a[j][i];
                }
            }
        }
    }

    private void mcdiv(double ar, double ai, double br, double bi) {
        double s = Math.abs(br) + Math.abs(bi);
        double ars = ar / s;
        double ais = ai / s;
        double brs = br / s;
        double bis = bi / s;
        s = brs * brs + bis * bis;
        this.cr = (ars * brs + ais * bis) / s;
        this.ci = (ais * brs - ars * bis) / s;
    }

    void hqr2(int n, int low, int hgh, double[][] h, double[][] zz, double[] wr, double[] wi) throws ArithmeticException {
        int m;
        double w;
        double y;
        double tst1;
        double tst2;
        int na;
        int j;
        int i;
        int l = 0;
        double p = 0.0;
        double q = 0.0;
        double r = 0.0;
        double s = 0.0;
        double x = 0.0;
        double z = 0.0;
        double norm = 0.0;
        int k = 1;
        for (i = 0; i < n; ++i) {
            for (j = k - 1; j < n; ++j) {
                norm += Math.abs(h[i][j]);
            }
            k = i + 1;
            if (i + 1 >= low && i + 1 <= hgh) continue;
            wr[i] = h[i][i];
            wi[i] = 0.0;
        }
        int en = hgh;
        double t = 0.0;
        int itn = n * 30;
        while (en >= low) {
            int its = 0;
            na = en - 1;
            while (en >= 1) {
                boolean fullLoop = true;
                for (l = en; l > low; --l) {
                    s = Math.abs(h[l - 2][l - 2]) + Math.abs(h[l - 1][l - 1]);
                    if (s == 0.0) {
                        s = norm;
                    }
                    if ((tst2 = (tst1 = s) + Math.abs(h[l - 1][l - 2])) != tst1) continue;
                    fullLoop = false;
                    break;
                }
                if (fullLoop) {
                    l = low;
                }
                x = h[en - 1][en - 1];
                if (l == en || l == na) break;
                if (itn == 0) {
                    System.out.println("Eigenvalues not converged");
                    throw new ArithmeticException();
                }
                y = h[na - 1][na - 1];
                w = h[en - 1][na - 1] * h[na - 1][en - 1];
                if (its == 10 || its == 20) {
                    t += x;
                    i = low - 1;
                    while (i < en) {
                        double[] dArray = h[i];
                        int n2 = i++;
                        dArray[n2] = dArray[n2] - x;
                    }
                    s = Math.abs(h[en - 1][na - 1]) + Math.abs(h[na - 1][en - 3]);
                    y = x = 0.75 * s;
                    w = -0.4375 * s * s;
                }
                ++its;
                --itn;
                for (m = en - 2; m >= l; --m) {
                    z = h[m - 1][m - 1];
                    r = x - z;
                    s = y - z;
                    p = (r * s - w) / h[m][m - 1] + h[m - 1][m];
                    q = h[m][m] - z - r - s;
                    r = h[m + 1][m];
                    s = Math.abs(p) + Math.abs(q) + Math.abs(r);
                    if (m == l || (tst2 = (tst1 = Math.abs(p /= s) * (Math.abs(h[m - 2][m - 2]) + Math.abs(z) + Math.abs(h[m][m]))) + Math.abs(h[m - 1][m - 2]) * (Math.abs(q /= s) + Math.abs(r /= s))) == tst1) break;
                }
                for (i = m + 2; i <= en; ++i) {
                    h[i - 1][i - 3] = 0.0;
                    if (i == m + 2) continue;
                    h[i - 1][i - 4] = 0.0;
                }
                for (k = m; k <= na; ++k) {
                    boolean notLast;
                    boolean bl = notLast = k != na;
                    if (k != m) {
                        p = h[k - 1][k - 2];
                        q = h[k][k - 2];
                        r = 0.0;
                        if (notLast) {
                            r = h[k + 1][k - 2];
                        }
                        if ((x = Math.abs(p) + Math.abs(q) + Math.abs(r)) != 0.0) {
                            p /= x;
                            q /= x;
                            r /= x;
                        }
                    }
                    if (x == 0.0) continue;
                    s = p < 0.0 ? -Math.sqrt(p * p + q * q + r * r) : Math.sqrt(p * p + q * q + r * r);
                    if (k != m) {
                        h[k - 1][k - 2] = -s * x;
                    } else if (l != m) {
                        h[k - 1][k - 2] = -h[k - 1][k - 2];
                    }
                    x = (p += s) / s;
                    y = q / s;
                    z = r / s;
                    q /= p;
                    r /= p;
                    if (!notLast) {
                        j = k - 1;
                        while (j < n) {
                            p = h[k - 1][j] + q * h[k][j];
                            double[] dArray = h[k - 1];
                            int n3 = j;
                            dArray[n3] = dArray[n3] - p * x;
                            double[] dArray2 = h[k];
                            int n4 = j++;
                            dArray2[n4] = dArray2[n4] - p * y;
                        }
                        j = en < k + 3 ? en : k + 3;
                        for (i = 0; i < j; ++i) {
                            p = x * h[i][k - 1] + y * h[i][k];
                            double[] dArray = h[i];
                            int n5 = k - 1;
                            dArray[n5] = dArray[n5] - p;
                            double[] dArray3 = h[i];
                            int n6 = k;
                            dArray3[n6] = dArray3[n6] - p * q;
                        }
                        for (i = low - 1; i < hgh; ++i) {
                            p = x * zz[i][k - 1] + y * zz[i][k];
                            double[] dArray = zz[i];
                            int n7 = k - 1;
                            dArray[n7] = dArray[n7] - p;
                            double[] dArray4 = zz[i];
                            int n8 = k;
                            dArray4[n8] = dArray4[n8] - p * q;
                        }
                        continue;
                    }
                    j = k - 1;
                    while (j < n) {
                        p = h[k - 1][j] + q * h[k][j] + r * h[k + 1][j];
                        double[] dArray = h[k - 1];
                        int n9 = j;
                        dArray[n9] = dArray[n9] - p * x;
                        double[] dArray5 = h[k];
                        int n10 = j;
                        dArray5[n10] = dArray5[n10] - p * y;
                        double[] dArray6 = h[k + 1];
                        int n11 = j++;
                        dArray6[n11] = dArray6[n11] - p * z;
                    }
                    j = en < k + 3 ? en : k + 3;
                    for (i = 0; i < j; ++i) {
                        p = x * h[i][k - 1] + y * h[i][k] + z * h[i][k + 1];
                        double[] dArray = h[i];
                        int n12 = k - 1;
                        dArray[n12] = dArray[n12] - p;
                        double[] dArray7 = h[i];
                        int n13 = k;
                        dArray7[n13] = dArray7[n13] - p * q;
                        double[] dArray8 = h[i];
                        int n14 = k + 1;
                        dArray8[n14] = dArray8[n14] - p * r;
                    }
                    for (i = low - 1; i < hgh; ++i) {
                        p = x * zz[i][k - 1] + y * zz[i][k] + z * zz[i][k + 1];
                        double[] dArray = zz[i];
                        int n15 = k - 1;
                        dArray[n15] = dArray[n15] - p;
                        double[] dArray9 = zz[i];
                        int n16 = k;
                        dArray9[n16] = dArray9[n16] - p * q;
                        double[] dArray10 = zz[i];
                        int n17 = k + 1;
                        dArray10[n17] = dArray10[n17] - p * r;
                    }
                }
            }
            if (l == en) {
                h[en - 1][en - 1] = x + t;
                wr[en - 1] = h[en - 1][en - 1];
                wi[en - 1] = 0.0;
                en = na;
                continue;
            }
            y = h[na - 1][na - 1];
            w = h[en - 1][na - 1] * h[na - 1][en - 1];
            p = (y - x) / 2.0;
            q = p * p + w;
            z = Math.sqrt(Math.abs(q));
            h[en - 1][en - 1] = x + t;
            x = h[en - 1][en - 1];
            h[na - 1][na - 1] = y + t;
            if (q >= 0.0) {
                z = p < 0.0 ? p - Math.abs(z) : p + Math.abs(z);
                wr[na - 1] = x + z;
                wr[en - 1] = wr[na - 1];
                if (z != 0.0) {
                    wr[en - 1] = x - w / z;
                }
                wi[na - 1] = 0.0;
                wi[en - 1] = 0.0;
                x = h[en - 1][na - 1];
                s = Math.abs(x) + Math.abs(z);
                p = x / s;
                q = z / s;
                r = Math.sqrt(p * p + q * q);
                p /= r;
                q /= r;
                for (j = na - 1; j < n; ++j) {
                    z = h[na - 1][j];
                    h[na - 1][j] = q * z + p * h[en - 1][j];
                    h[en - 1][j] = q * h[en - 1][j] - p * z;
                }
                for (i = 0; i < en; ++i) {
                    z = h[i][na - 1];
                    h[i][na - 1] = q * z + p * h[i][en - 1];
                    h[i][en - 1] = q * h[i][en - 1] - p * z;
                }
                for (i = low - 1; i < hgh; ++i) {
                    z = zz[i][na - 1];
                    zz[i][na - 1] = q * z + p * zz[i][en - 1];
                    zz[i][en - 1] = q * zz[i][en - 1] - p * z;
                }
            } else {
                wr[na - 1] = x + p;
                wr[en - 1] = x + p;
                wi[na - 1] = z;
                wi[en - 1] = -z;
            }
            en -= 2;
        }
        if (norm != 0.0) {
            for (en = n; en >= 1; --en) {
                p = wr[en - 1];
                q = wi[en - 1];
                na = en - 1;
                if (q == 0.0) {
                    m = en;
                    h[en - 1][en - 1] = 1.0;
                    if (na == 0) continue;
                    for (i = en - 2; i >= 0; --i) {
                        w = h[i][i] - p;
                        r = 0.0;
                        for (j = m - 1; j < en; ++j) {
                            r += h[i][j] * h[j][en - 1];
                        }
                        if (wi[i] < 0.0) {
                            z = w;
                            s = r;
                            continue;
                        }
                        m = i + 1;
                        if (wi[i] == 0.0) {
                            t = w;
                            if (t == 0.0) {
                                t = tst1 = norm;
                                while ((tst2 = norm + (t = 0.01 * t)) > tst1) {
                                }
                            }
                            h[i][en - 1] = -(r / t);
                        } else {
                            x = h[i][i + 1];
                            y = h[i + 1][i];
                            q = (wr[i] - p) * (wr[i] - p) + wi[i] * wi[i];
                            h[i][en - 1] = t = (x * s - z * r) / q;
                            h[i + 1][en - 1] = Math.abs(x) > Math.abs(z) ? (-r - w * t) / x : (-s - y * t) / z;
                        }
                        t = Math.abs(h[i][en - 1]);
                        if (t == 0.0 || !((tst2 = (tst1 = t) + 1.0 / tst1) <= tst1)) continue;
                        for (j = i; j < en; ++j) {
                            double[] dArray = h[j];
                            int n18 = en - 1;
                            dArray[n18] = dArray[n18] / t;
                        }
                    }
                    continue;
                }
                if (!(q > 0.0)) continue;
                m = na;
                if (Math.abs(h[en - 1][na - 1]) > Math.abs(h[na - 1][en - 1])) {
                    h[na - 1][na - 1] = q / h[en - 1][na - 1];
                    h[na - 1][en - 1] = (p - h[en - 1][en - 1]) / h[en - 1][na - 1];
                } else {
                    this.mcdiv(0.0, -h[na - 1][en - 1], h[na - 1][na - 1] - p, q);
                    h[na - 1][na - 1] = this.cr;
                    h[na - 1][en - 1] = this.ci;
                }
                h[en - 1][na - 1] = 0.0;
                h[en - 1][en - 1] = 1.0;
                if (en == 2) continue;
                for (i = en - 3; i >= 0; --i) {
                    w = h[i][i] - p;
                    double ra = 0.0;
                    double sa = 0.0;
                    for (j = m - 1; j < en; ++j) {
                        ra += h[i][j] * h[j][na - 1];
                        sa += h[i][j] * h[j][en - 1];
                    }
                    if (wi[i] < 0.0) {
                        z = w;
                        r = ra;
                        s = sa;
                        continue;
                    }
                    m = i + 1;
                    if (wi[i] == 0.0) {
                        this.mcdiv(-ra, -sa, w, q);
                        h[i][na - 1] = this.cr;
                        h[i][en - 1] = this.ci;
                    } else {
                        x = h[i][i + 1];
                        y = h[i + 1][i];
                        double vr = (wr[i] - p) * (wr[i] - p);
                        vr = vr + wi[i] * wi[i] - q * q;
                        double vi = (wr[i] - p) * 2.0 * q;
                        if (vr == 0.0 && vi == 0.0) {
                            vr = tst1 = norm * (Math.abs(w) + Math.abs(q) + Math.abs(x) + Math.abs(y) + Math.abs(z));
                            while ((tst2 = tst1 + (vr = 0.01 * vr)) > tst1) {
                            }
                        }
                        this.mcdiv(x * r - z * ra + q * sa, x * s - z * sa - q * ra, vr, vi);
                        h[i][na - 1] = this.cr;
                        h[i][en - 1] = this.ci;
                        if (Math.abs(x) > Math.abs(z) + Math.abs(q)) {
                            h[i + 1][na - 1] = (q * h[i][en - 1] - w * h[i][na - 1] - ra) / x;
                            h[i + 1][en - 1] = (-sa - w * h[i][en - 1] - q * h[i][na - 1]) / x;
                        } else {
                            this.mcdiv(-r - y * h[i][na - 1], -s - y * h[i][en - 1], z, q);
                            h[i + 1][na - 1] = this.cr;
                            h[i + 1][en - 1] = this.ci;
                        }
                    }
                    double d = t = Math.abs(h[i][na - 1]) > Math.abs(h[i][en - 1]) ? Math.abs(h[i][na - 1]) : Math.abs(h[i][en - 1]);
                    if (t == 0.0 || !((tst2 = (tst1 = t) + 1.0 / tst1) <= tst1)) continue;
                    for (j = i; j < en; ++j) {
                        double[] dArray = h[j];
                        int n19 = na - 1;
                        dArray[n19] = dArray[n19] / t;
                        double[] dArray11 = h[j];
                        int n20 = en - 1;
                        dArray11[n20] = dArray11[n20] / t;
                    }
                }
            }
            for (i = 0; i < n; ++i) {
                if (i + 1 >= low && i + 1 <= hgh) continue;
                for (j = i; j < n; ++j) {
                    zz[i][j] = h[i][j];
                }
            }
            for (j = n - 1; j >= low - 1; --j) {
                m = j + 1 < hgh ? j + 1 : hgh;
                for (i = low - 1; i < hgh; ++i) {
                    z = 0.0;
                    for (k = low - 1; k < m; ++k) {
                        z += zz[i][k] * h[k][j];
                    }
                    zz[i][j] = z;
                }
            }
        }
    }

    private void eltran(double[][] a, double[][] zz, int[] ordr, int n) {
        int j;
        int i;
        for (i = 0; i < n; ++i) {
            for (j = i + 1; j < n; ++j) {
                zz[i][j] = 0.0;
                zz[j][i] = 0.0;
            }
            zz[i][i] = 1.0;
        }
        if (n <= 2) {
            return;
        }
        for (int m = n - 1; m >= 2; --m) {
            for (i = m; i < n; ++i) {
                zz[i][m - 1] = a[i][m - 2];
            }
            i = ordr[m - 1];
            if (i == m) continue;
            for (j = m - 1; j < n; ++j) {
                zz[m - 1][j] = zz[i - 1][j];
                zz[i - 1][j] = 0.0;
            }
            zz[i - 1][m - 1] = 1.0;
        }
    }

    void luinverse(double[][] inmat, double[][] imtrx, int size) throws IllegalArgumentException {
        double sum;
        double maxb;
        int j;
        int i;
        int maxi = 0;
        int[] index = new int[size];
        double[][] omtrx = new double[size][size];
        for (i = 0; i < size; ++i) {
            for (j = 0; j < size; ++j) {
                omtrx[i][j] = inmat[i][j];
            }
        }
        double[] wk = new double[size];
        double aw = 1.0;
        for (i = 0; i < size; ++i) {
            maxb = 0.0;
            for (j = 0; j < size; ++j) {
                if (!(Math.abs(omtrx[i][j]) > maxb)) continue;
                maxb = Math.abs(omtrx[i][j]);
            }
            if (maxb == 0.0) {
                System.out.println("Singular matrix encountered");
                throw new IllegalArgumentException("Singular matrix");
            }
            wk[i] = 1.0 / maxb;
        }
        for (j = 0; j < size; ++j) {
            double tmp;
            int k;
            for (i = 0; i < j; ++i) {
                sum = omtrx[i][j];
                for (k = 0; k < i; ++k) {
                    sum -= omtrx[i][k] * omtrx[k][j];
                }
                omtrx[i][j] = sum;
            }
            maxb = 0.0;
            for (i = j; i < size; ++i) {
                sum = omtrx[i][j];
                for (k = 0; k < j; ++k) {
                    sum -= omtrx[i][k] * omtrx[k][j];
                }
                omtrx[i][j] = sum;
                tmp = wk[i] * Math.abs(sum);
                if (!(tmp >= maxb)) continue;
                maxb = tmp;
                maxi = i;
            }
            if (j != maxi) {
                for (k = 0; k < size; ++k) {
                    tmp = omtrx[maxi][k];
                    omtrx[maxi][k] = omtrx[j][k];
                    omtrx[j][k] = tmp;
                }
                aw = -aw;
                wk[maxi] = wk[j];
            }
            index[j] = maxi;
            if (omtrx[j][j] == 0.0) {
                omtrx[j][j] = 2.220446049250313E-16;
            }
            if (j == size - 1) continue;
            tmp = 1.0 / omtrx[j][j];
            for (i = j + 1; i < size; ++i) {
                double[] dArray = omtrx[i];
                int n = j;
                dArray[n] = dArray[n] * tmp;
            }
        }
        for (int jx = 0; jx < size; ++jx) {
            int ix;
            for (ix = 0; ix < size; ++ix) {
                wk[ix] = 0.0;
            }
            wk[jx] = 1.0;
            int l = -1;
            for (i = 0; i < size; ++i) {
                int idx = index[i];
                sum = wk[idx];
                wk[idx] = wk[i];
                if (l != -1) {
                    for (j = l; j < i; ++j) {
                        sum -= omtrx[i][j] * wk[j];
                    }
                } else if (sum != 0.0) {
                    l = i;
                }
                wk[i] = sum;
            }
            for (i = size - 1; i >= 0; --i) {
                sum = wk[i];
                for (j = i + 1; j < size; ++j) {
                    sum -= omtrx[i][j] * wk[j];
                }
                wk[i] = sum / omtrx[i][i];
            }
            for (ix = 0; ix < size; ++ix) {
                imtrx[ix][jx] = wk[ix];
            }
        }
    }
}

