/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.sitemodel;

import dr.inference.model.AbstractModel;
import dr.inference.model.Bounds;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.distributions.GammaDistribution;
import dr.oldevomodel.sitemodel.SiteModel;
import dr.oldevomodel.substmodel.FrequencyModel;
import dr.oldevomodel.substmodel.SubstitutionModel;

public class GammaSiteBMA
extends AbstractModel
implements SiteModel {
    private SubstitutionModel substitutionModel = null;
    private Parameter muParameter = null;
    private Variable<Integer> modelChoose = null;
    private Variable<Double> logShape = null;
    private Variable<Double> logitInvar = null;
    private int categoryCount = -1;
    private double[] categoryRates;
    private double[] categoryProportions;
    private boolean ratesKnown;
    public static final int SHAPE_INDEX = 0;
    public static final int INVAR_INDEX = 1;
    public static final int PRESENT = 1;
    public static final int ABSENT = 0;

    public GammaSiteBMA(SubstitutionModel substitutionModel, Parameter parameter, Variable<Double> variable, Variable<Double> variable2, int n, Variable<Integer> variable3) {
        super("GammaSiteBMA");
        this.substitutionModel = substitutionModel;
        this.addModel(substitutionModel);
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.muParameter = parameter;
        this.addVariable(variable2);
        variable2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
        this.logShape = variable2;
        this.addVariable(variable);
        variable.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
        this.logitInvar = variable;
        this.addVariable(variable3);
        variable3.addBounds(new Bounds.Int(variable3, 0, 1));
        this.modelChoose = variable3;
        this.categoryCount = n + 1;
        this.categoryRates = new double[this.categoryCount];
        this.categoryProportions = new double[this.categoryCount];
        this.ratesKnown = false;
    }

    @Override
    public boolean integrateAcrossCategories() {
        return true;
    }

    @Override
    public int getCategoryCount() {
        return this.categoryCount;
    }

    @Override
    public int getCategoryOfSite(int n) {
        throw new IllegalArgumentException("Integrating across categories");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getRateForCategory(int n) {
        GammaSiteBMA gammaSiteBMA = this;
        synchronized (gammaSiteBMA) {
            if (!this.ratesKnown) {
                this.calculateCategoryRates();
            }
        }
        double d = this.muParameter != null ? this.muParameter.getParameterValue(0) : 1.0;
        return this.categoryRates[n] * d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[] getCategoryRates() {
        GammaSiteBMA gammaSiteBMA = this;
        synchronized (gammaSiteBMA) {
            if (!this.ratesKnown) {
                this.calculateCategoryRates();
            }
        }
        double d = this.muParameter != null ? this.muParameter.getParameterValue(0) : 1.0;
        double[] dArray = new double[this.categoryRates.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.categoryRates[i] * d;
        }
        return dArray;
    }

    public void getTransitionProbabilities(double d, double[] dArray) {
        this.substitutionModel.getTransitionProbabilities(d, dArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getProportionForCategory(int n) {
        GammaSiteBMA gammaSiteBMA = this;
        synchronized (gammaSiteBMA) {
            if (!this.ratesKnown) {
                this.calculateCategoryRates();
            }
        }
        return this.categoryProportions[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[] getCategoryProportions() {
        GammaSiteBMA gammaSiteBMA = this;
        synchronized (gammaSiteBMA) {
            if (!this.ratesKnown) {
                this.calculateCategoryRates();
            }
        }
        return this.categoryProportions;
    }

    private void calculateCategoryRates() {
        double d = 1.0;
        int n = 0;
        this.categoryRates[0] = 0.0;
        this.categoryProportions[0] = (double)this.modelChoose.getValue(1).intValue() * (1.0 / (1.0 + Math.exp(-this.logitInvar.getValue(0).doubleValue())));
        d = 1.0 - this.categoryProportions[0];
        n = 1;
        if (this.modelChoose.getValue(0) == 1) {
            int n2;
            double d2 = Math.exp(this.logShape.getValue(0));
            double d3 = 0.0;
            int n3 = this.categoryCount - n;
            for (n2 = 0; n2 < n3; ++n2) {
                this.categoryRates[n2 + n] = GammaDistribution.quantile((2.0 * (double)n2 + 1.0) / (2.0 * (double)n3), d2, 1.0 / d2);
                d3 += this.categoryRates[n2 + n];
                this.categoryProportions[n2 + n] = d / (double)n3;
            }
            d3 = d * d3 / (double)n3;
            for (n2 = 0; n2 < n3; ++n2) {
                int n4 = n2 + n;
                this.categoryRates[n4] = this.categoryRates[n4] / d3;
            }
        } else {
            int n5 = this.categoryCount - n;
            for (int i = 0; i < n5; ++i) {
                this.categoryRates[i + n] = 1.0 / d;
                this.categoryProportions[i + n] = d / (double)n5;
            }
        }
        this.ratesKnown = true;
    }

    @Override
    public FrequencyModel getFrequencyModel() {
        return this.substitutionModel.getFrequencyModel();
    }

    @Override
    public SubstitutionModel getSubstitutionModel() {
        return this.substitutionModel;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.listenerHelper.fireModelChanged(this, object, n);
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.logShape) {
            this.ratesKnown = false;
        } else if (variable == this.logitInvar) {
            this.ratesKnown = false;
        } else if (variable == this.modelChoose) {
            this.ratesKnown = false;
        }
        this.listenerHelper.fireModelChanged(this, variable, n);
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
        this.ratesKnown = false;
    }

    @Override
    protected void acceptState() {
    }
}

