/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.integration.RombergIntegrator;
import org.apache.commons.math.analysis.integration.UnivariateRealIntegrator;

public class GeneralizedLogisticFunction {
    private static final UnivariateRealIntegrator integrator = new RombergIntegrator();

    public static double evaluate(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        return GeneralizedLogisticFunction.evaluate(d, d2, d3, d4, d5, d6, d7, d8, 1.0, 1.0);
    }

    public static double evaluate(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        double d11;
        if (d <= d2) {
            d11 = d4;
        } else if (d >= d3) {
            d11 = d5;
        } else {
            double d12 = (d3 - d) / (d - d2);
            double d13 = (d3 - d7) / (d7 - d2);
            double d14 = Math.exp(-d6 * (d12 - d13));
            double d15 = d10 + d8 * Math.pow(d12 / d13, d6);
            if (d9 != 1.0) {
                d15 = Math.pow(d15, 1.0 / d9);
            }
            d11 = d4 + (d5 - d4) / d15;
        }
        return d11;
    }

    public static double integrate(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        return GeneralizedLogisticFunction.integrate(d, d2, d3, d4, d5, d6, d7, d8, d9, 1.0, 1.0);
    }

    public static double integrate(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d11, double d12) {
        UnivariateRealFunction univariateRealFunction = d10 -> GeneralizedLogisticFunction.evaluate(d10, d3, d4, d5, d6, d7, d8, d9, d11, d12);
        double d13 = 0.0;
        try {
            d13 = integrator.integrate(univariateRealFunction, d, d2);
        }
        catch (ConvergenceException | FunctionEvaluationException mathException) {
            mathException.printStackTrace();
        }
        return d13;
    }
}

