/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.math.distributions.WishartDistribution;
import dr.math.matrixAlgebra.Matrix;

public class MVOUCovarianceOperator
extends AbstractAdaptableOperator {
    private double mixingFactor;
    private MatrixParameter varMatrix;
    private int dim;
    private MatrixParameter precisionParam;
    private WishartDistribution priorDistribution;
    private int priorDf;
    private double[][] I;
    private Matrix Iinv;

    public MVOUCovarianceOperator(double d, MatrixParameter matrixParameter, int n, double d2, AdaptationMode adaptationMode) {
        super(adaptationMode);
        this.mixingFactor = d;
        this.varMatrix = matrixParameter;
        this.priorDf = n;
        this.setWeight(d2);
        this.dim = matrixParameter.getColumnDimension();
        this.I = new double[this.dim][this.dim];
        for (int i = 0; i < this.dim; ++i) {
            this.I[i][i] = 1.0;
        }
        this.Iinv = new Matrix(this.I).inverse();
    }

    @Override
    public double doOperation() {
        int n;
        double[][] dArray = WishartDistribution.nextWishart(this.priorDf, this.I);
        double[][] dArray2 = this.varMatrix.getParameterAsMatrix();
        for (int i = 0; i < this.dim; ++i) {
            Parameter parameter = this.varMatrix.getParameter(i);
            for (n = 0; n < this.dim; ++n) {
                parameter.setParameterValue(n, this.mixingFactor * dArray2[n][i] + (1.0 - this.mixingFactor) * dArray[n][i]);
            }
        }
        Matrix matrix = new Matrix(dArray);
        for (int i = 0; i < this.dim; ++i) {
            n = 0;
            while (n < this.dim) {
                double[] dArray3 = dArray2[i];
                int n2 = n;
                dArray3[n2] = dArray3[n2] - this.mixingFactor * this.varMatrix.getParameterValue(i, n);
                double[] dArray4 = dArray2[i];
                int n3 = n++;
                dArray4[n3] = dArray4[n3] / (1.0 - this.mixingFactor);
            }
        }
        Matrix matrix2 = new Matrix(dArray2);
        double d = WishartDistribution.logPdf(matrix2, this.Iinv, this.priorDf, this.dim, 0.0);
        if (d == Double.NEGATIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        double d2 = WishartDistribution.logPdf(matrix, this.Iinv, this.priorDf, this.dim, 0.0);
        return d - d2;
    }

    @Override
    public final String getOperatorName() {
        return "mvouOperator(" + this.varMatrix.getId() + ")";
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(this.mixingFactor / (1.0 - this.mixingFactor));
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        this.mixingFactor = Math.exp(d) / (1.0 + Math.exp(d));
    }

    @Override
    public double getRawParameter() {
        return this.mixingFactor;
    }

    @Override
    public String getAdaptableParameterName() {
        return "mixingFactor";
    }
}

