/*
 * Decompiled with CFR 0.152.
 */
package dr.geo;

import dr.geo.MultivariateBrownianBridge;
import dr.geo.Reject;
import dr.geo.SpaceTime;
import dr.geo.SpaceTimeRejector;
import dr.math.MathUtils;
import dr.math.distributions.MultivariateNormalDistribution;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class VisualizeBrownianBridge2D
extends JComponent {
    MultivariateNormalDistribution mnd;
    SpaceTime[] start;
    SpaceTime[] end;
    SpaceTimeRejector rejector;
    List<Shape> shapes;
    Paint shapeColor = Color.GRAY;
    Point2D topLeft;
    Point2D bottomRight;
    double scaleX;
    double scaleY;

    public VisualizeBrownianBridge2D() {
        this.start = new SpaceTime[]{new SpaceTime(0.0, new double[]{0.0, 0.0})};
        this.end = new SpaceTime[]{new SpaceTime(1.0, new double[]{1.0, 1.0})};
        this.topLeft = new Point2D.Double(-0.2, -0.2);
        this.bottomRight = new Point2D.Double(1.2, 1.2);
        this.shapes = new ArrayList<Shape>();
        this.shapes.add(new Ellipse2D.Double(0.25, 0.25, 0.4, 0.4));
        this.shapes.add(new Ellipse2D.Double(0.5, 0.7, 0.2, 0.2));
        this.shapes.add(new Ellipse2D.Double(0.8, 0.2, 0.15, 0.15));
        this.rejector = new SpaceTimeRejector(){
            ArrayList<Reject> rejects = new ArrayList();

            @Override
            public boolean reject(double d, double[] dArray) {
                double d2 = dArray[0];
                double d3 = dArray[1];
                for (Shape shape : VisualizeBrownianBridge2D.this.shapes) {
                    if (!shape.contains(d2, d3)) continue;
                    this.rejects.add(new Reject(0, d, dArray));
                    return true;
                }
                return false;
            }

            @Override
            public void reset() {
                this.rejects.clear();
            }

            @Override
            public List<Reject> getRejects() {
                return this.rejects;
            }
        };
        this.mnd = new MultivariateNormalDistribution(new double[]{0.0}, new double[][]{{10.0, 0.0}, {0.0, 10.0}});
    }

    public void setShapeColor(Color color) {
        this.shapeColor = color;
    }

    void computeScales() {
        this.scaleX = (double)this.getWidth() / (this.bottomRight.getX() - this.topLeft.getX());
        this.scaleY = (double)this.getHeight() / (this.bottomRight.getY() - this.topLeft.getY());
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Serializable serializable;
        System.out.println("entering paintComponent()");
        this.computeScales();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setStroke(new BasicStroke(1.5f));
        System.out.println("Painting shapes");
        for (Shape shape : this.shapes) {
            System.out.print(".");
            System.out.flush();
            serializable = new GeneralPath(shape);
            serializable.transform(this.getFullTransform());
            graphics2D.setPaint(this.shapeColor);
            graphics2D.fill((Shape)((Object)serializable));
        }
        AffineTransform affineTransform = this.getFullTransform();
        for (int i = 0; i < this.getTrials(); ++i) {
            serializable = new Color((float)MathUtils.nextDouble(), (float)MathUtils.nextDouble(), (float)MathUtils.nextDouble());
            for (int j = 0; j < this.start.length; ++j) {
                List<SpaceTime> list = null;
                graphics2D.setPaint((Paint)((Object)serializable));
                int n = -1;
                while (list == null) {
                    ++n;
                    list = MultivariateBrownianBridge.divideConquerBrownianBridge(this.mnd, this.start[j], this.end[j], this.getMaxDepth(), this.getMaxTries(), this.rejector);
                }
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo((float)((SpaceTime)list.get(0)).getX(0), (float)((SpaceTime)list.get(0)).getX(1));
                for (int k = 1; k < list.size(); ++k) {
                    generalPath.lineTo((float)list.get(k).getX(0), (float)list.get(k).getX(1));
                }
                generalPath.transform(this.getFullTransform());
                graphics2D.draw(generalPath);
                graphics2D.setPaint(Color.black);
                SpaceTime.paintDot(this.start[j], 3.0, affineTransform, graphics2D);
                SpaceTime.paintDot(this.end[j], 3.0, affineTransform, graphics2D);
            }
        }
        System.out.println("leaving paintComponent()");
    }

    AffineTransform getScale() {
        return AffineTransform.getScaleInstance(this.scaleX, this.scaleY);
    }

    AffineTransform getTranslate() {
        return AffineTransform.getTranslateInstance(-this.topLeft.getX(), -this.topLeft.getY());
    }

    AffineTransform getFullTransform() {
        AffineTransform affineTransform = this.getScale();
        affineTransform.concatenate(this.getTranslate());
        return affineTransform;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Boulders");
        jFrame.getContentPane().add("Center", new VisualizeBrownianBridge2D());
        jFrame.setSize(600, 600);
        jFrame.setVisible(true);
    }

    public int getMaxDepth() {
        return 10;
    }

    public int getTrials() {
        return 10;
    }

    public int getMaxTries() {
        return 10;
    }
}

