help_page <- fluidRow(
  column(
    width = 12, title = "Help",
    tabBox(
      width = 12,
      tabPanel("Data",
        div(style = "margin-top: -10px"),
        tags$h4("Loading data"),
        "Choose a dataframe (in .csv format) from your workstation to load into tRigon.",
        "Please always wait until the file selection diplays that the upload was complete and then press the ", em("Load"), " button.",
        "For pathomics data the file should include features as well as clinical or experiment information. You can also load any other non-pathomics dataset into tRigon to perform your exploratory analyses.",
        "You can also load any dataframe which you created during processing and saved with tRigon.",
        "You can also download a markdown .html file containing your experiment report with session info, inputs and outputs by clicking on ", em("Save Report."), br(), br(),
        tags$h4("Processing data"),
        "Select the feature tables (in .csv format) provided by FLASH for the experiment that you want to analyse with tRigon.",
        "Select a metadata or clinical datafile with information about the animal experiments / human samples.",
        "The metadata file needs to be in .xlsx format and has to follow the tRigon guidelines (more below).",
        "If you want to analyse human data, select ", em("Processing human data"), " in the ", em("Settings"), " tab - mouse data is enabled as default.", br(),
        "Mouse data guidelines: please make sure that the metadata file includes an ID (as exactly given in the feature files until the _ separator before the slide position in the filename) and position (the slide position) column. The", em("ID"), "and", em("position"), "columns have to be present and named exactly as written out here.", br(),
        "Human data guidelines: please make sure that the metadata file includes a pseudonym (the sample identifier) and group (clinical data, diseases, etc.) column(s). The", em("pseudonym"), "column has to be included and named in lowercase.", br(),
        "All human pathomics feature files must include the pseudonym in the filename either in the beginning as ", em("pseudonym_"), " or as ", em("_pseudonym_"), " in the middle of the file to be processed. All mouse pathomics feature files must include the ID as the full filename excluding", em("_1_features.csv"),
        "Please always wait for the file upload to be completed before you press the ", em("Process"), " button.",
        "You can download the processed dataframe for future analysis as a .csv-file by clicking the ", em("Save Data"), " button.",
        "You can also download a markdown .html file containing your experiment report with session info, inputs and outputs by clicking on ", em("Save Report."),
        width = "100%"
      ),
      tabPanel("Statistics",
        div(style = "margin-top: -10px"),
        tags$h4("Calculating descriptive statistics"),
        "You can calculate descriptive statistics for all columns as well as provided features.",
        "Simply choose a feature from the dropdown menu and specify the group column.",
        "The group column should represent the labels for all relevant groups that you want to analyse. Each analysed data point has to be provided with its respective label",
        "The group column can be dependent on the mouse experiment, disease or stratified clinical data - please note that the group should be a stratified variable.",
        "tRigon can also stratify numeric variables for you if you want to analyse a numeric input, but please note that numeric inputs are only possible for up to 30 stratified groups.",
        "After selecting a feature and typing in the group column press the ", em("Calculate"), " button.",
        "Descriptive statistics include feature mean, median, variance (var), standard deviation (sd), 1st and 3rd quantile (q1/3), interquartile range (iqr) as well as the n of analysed data points.",
        "You can save the calculated descriptive statistics as an .xslx file by clicking the ", em("Save Data"), " button.",
        "You can also download a markdown .html file containing your experiment report with session info, inputs and outputs by clicking on ", em("Save Report."), br(), br(),
        tags$h4("Performing statistical tests"),
        "tRigon can calculate a variety of statistical tests such as Kruskal-Wallis tests or pairwise Wilcoxon tests.",
        "Due to nature of the pathomics data (large no. of instances, outlier) normality cannot be assumed and only non-parametric tests are performed.",
        "Kruskal-Wallis tests calculate if there is a statistically significant effect between groups based upon the comparison variable.",
        "Pairwise-Wilcoxon tests (with Bonferroni adjustment for multiple testing) and bootstrapped confidence intervalls of difference in feature median between groups can be implemented to analyse feature differences between groups.", br(),
        "The output for each test is displayed in the style of the R console, but can also be viewed as a dataframe.",
        "To download the dataframe of the p-values or feature median difference + CI simply click the ", em("Save Data"), " button.",
        "You can also download a markdown .html file containing your experiment report with session info, inputs and outputs by clicking on ", em("Save Report"), " (please be aware that both tabs need to be rendered before you download a report so that it does not contain empty or old data).",
        width = "100%"
      ),
      tabPanel("Plots",
        div(style = "margin-top: -10px"),
        tags$h4("Drawing plots"),
        "tRigon can create a variety of different plots for all numeric features.",
        "Chose a feature of interest from the dropdown menu and specify the group column.",
        "Then you can select what type of graph you like. Options include violin plots, boxplots, combined violin-box-plots and ridgeline plots.",
        "For displaying distributions it can be helpful to enable a logarithmic scale as the features sometimes include a large variety of measures or outliers.",
        "To enable the log-scale on the y-axis, simply turn the switch to ON. Please note that this is not advised for shape features (as they only range between zero to one) or other well distributed columns.",
        "Please also note that zeros get excluded in logarithmic scales so the sample size might vary slighty.", br(),
        "After specifying all relevant inputs click the ", em("Plot"), " button. You can save the rendered plot as a .png file by clicking ", em("Save Plot."),
        "You can also download a markdown .html file containing your experiment report with session info, inputs and outputs by clicking on ", em("Save Report."),
        width = "100%"
      ),
      tabPanel("Clustering",
        div(style = "margin-top: -10px"),
        tags$h4("Clustering data"),
        "tRigon is also able to perform k-means clustering.",
        "Due to the nature of the feature data with large differences in the number of instances please be careful when comparing different histological structures of features. For k-means clustering only complete cases can be analysed. tRigon will display a warning when the feature input vectors have different lengths.",
        "By turning the slide to ON you can view to which group/subgroup each instance belongs. The group variable can only have as many levels as the max. amount of clusters.", br(),
        "tRigon provides the console output as well as the plot, which can be saved with ", em("Save Plot."),
        "You can also download a markdown .html file containing your experiment report with session info, inputs and outputs by clicking on ", em("Save Report"), " (please be aware that both tabs need to be rendered before you download a report so that it does not contain empty or old data).",
        width = "100%"
      ),
      tabPanel("Feature Importance",
        div(style = "margin-top: -10px"),
        tags$h4("Calculating feature importance"),
        "With tRigon you can also analyse which features are important to determine differences between a dependent variable in your dataset.",
        "Based on the format of the dependent variable you can chose between regression and classification. Regression is best for numeric variables while classification is best for categorical variables (e.g., groups).",
        "You can choose between random forests and recursive feature elimination as common machine learning models for determining feature importance.",
        "For recursive feature elimination you can also specify the number of folds for cross-validation and the number of repeats.", br(),
        "The respective model output is provided in console format, but can be also plotted. The plot output can also be saved.",
        "For regression feature importance is based on increase in mean standard error and increase in node purity while for classification it is based on mean decrease accuracy and gini.",
        "You can also download a markdown .html file containing your experiment report with session info, inputs and outputs by clicking on ", em("Save Report"), " (please be aware that both tabs need to be rendered before you download a report so that it does not contain empty or old data).",
        width = "100%"
      ),
      tabPanel("Correlation",
        div(style = "margin-top: -10px"),
        tags$h4("Correlating features"),
        "tRigon can also be used to test correlations between different features. Please note that only correlations between numeric variables are possible (Pearson).",
        "tRigon can either calculate simple correlations (between two features) or a correlation matrix for at least 3 features. Simply choose the respective tab and select features of interest from the multiple-choice dropdown menu.",
        "To test for feature correlations in specific subgroups (e.g., only a specific disease), turn the slider to ON and specify the subgroup as it is provided in the dataframe.", br(),
        "For simple correlations the output will be provided as a scatter plot including a linear regression line and a dataframe together with analysed datapoints and the calculated Pearson's R as well as p-value.",
        "For multiple correlations the output will be provided as a correlation matrix plot and dataframe.",
        "The correlation matrix plot and data can both be saved by clicking the respective buttons.",
        "You can also download a markdown .html file containing your experiment report with session info, inputs and outputs by clicking on ", em("Save Report"), " (please be aware that both tabs need to be rendered before you download a report so that it does not contain empty or old data).",
        width = "100%"
      )
    )
  )
)
