/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation.preview;

import java.util.ArrayList;
import java.util.List;
import moa.core.DoubleVector;
import moa.core.Measurement;
import moa.core.StringUtils;
import moa.evaluation.LearningEvaluation;
import moa.evaluation.preview.Preview;

public class LearningCurve
extends Preview {
    private static final long serialVersionUID = 1L;
    protected List<String> measurementNames = new ArrayList<String>();
    protected List<double[]> measurementValues = new ArrayList<double[]>();
    Class<?> taskClass = null;

    public LearningCurve(String orderingMeasurementName) {
        this.measurementNames.add(orderingMeasurementName);
    }

    public LearningCurve(String orderingMeasurementName, Class<?> taskClass) {
        this.measurementNames.add(orderingMeasurementName);
        this.taskClass = taskClass;
    }

    public String getOrderingMeasurementName() {
        return this.measurementNames.get(0);
    }

    public void setData(List<String> measurementNames, List<double[]> measurementValues) {
        this.measurementNames.clear();
        this.measurementValues.clear();
        this.measurementNames.addAll(measurementNames);
        this.measurementValues.addAll(measurementValues);
    }

    public void insertEntry(LearningEvaluation learningEvaluation) {
        int index;
        Measurement[] measurements = learningEvaluation.getMeasurements();
        Measurement orderMeasurement = Measurement.getMeasurementNamed(this.getOrderingMeasurementName(), measurements);
        if (orderMeasurement == null) {
            throw new IllegalArgumentException();
        }
        DoubleVector entryVals = new DoubleVector();
        for (Measurement measurement : measurements) {
            entryVals.setValue(this.addMeasurementName(measurement.getName()), measurement.getValue());
        }
        double orderVal = orderMeasurement.getValue();
        for (index = 0; index < this.measurementValues.size() && orderVal > this.measurementValues.get(index)[0]; ++index) {
        }
        this.measurementValues.add(index, entryVals.getArrayRef());
    }

    @Override
    public int numEntries() {
        return this.measurementValues.size();
    }

    protected int addMeasurementName(String name) {
        int index = this.measurementNames.indexOf(name);
        if (index < 0) {
            index = this.measurementNames.size();
            this.measurementNames.add(name);
        }
        return index;
    }

    public String headerToString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String name : this.measurementNames) {
            if (!first) {
                sb.append(',');
            } else {
                first = false;
            }
            sb.append(name);
        }
        return sb.toString();
    }

    @Override
    public String entryToString(int entryIndex) {
        StringBuilder sb = new StringBuilder();
        double[] vals = this.measurementValues.get(entryIndex);
        for (int i = 0; i < this.measurementNames.size(); ++i) {
            if (i > 0) {
                sb.append(',');
            }
            if (i >= vals.length || Double.isNaN(vals[i])) {
                sb.append('?');
                continue;
            }
            sb.append(Double.toString(vals[i]));
        }
        return sb.toString();
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
        sb.append(this.headerToString());
        for (int i = 0; i < this.numEntries(); ++i) {
            StringUtils.appendNewlineIndented(sb, indent, this.entryToString(i));
        }
    }

    public double getMeasurement(int entryIndex, int measurementIndex) {
        return this.measurementValues.get(entryIndex)[measurementIndex];
    }

    @Override
    public String getMeasurementName(int measurementIndex) {
        return this.measurementNames.get(measurementIndex);
    }

    @Override
    public int getMeasurementNameCount() {
        return this.measurementNames.size();
    }

    public int getEntryMeasurementCount(int entryIdx) {
        return this.measurementValues.get(entryIdx).length;
    }

    @Override
    public Class<?> getTaskClass() {
        return this.taskClass;
    }

    @Override
    public double[] getEntryData(int entryIndex) {
        int numMeasurements = this.getMeasurementNameCount();
        int numEntryMeasurements = this.getEntryMeasurementCount(entryIndex);
        double[] data = new double[numMeasurements];
        for (int measurementIdx = 0; measurementIdx < numMeasurements; ++measurementIdx) {
            data[measurementIdx] = measurementIdx < numEntryMeasurements ? this.getMeasurement(entryIndex, measurementIdx) : Double.NaN;
        }
        return data;
    }
}

