## ----include = FALSE----------------------------------------------------------
library(mosaic)
library(mosaicData)
library(mosaicCalc)
library(ggformula)

## -----------------------------------------------------------------------------
slice_plot(x*sin(x) ~ x, bounds(x = 0:10))

## -----------------------------------------------------------------------------
antiD(x*sin(x) ~ x)

## ----results="hide"-----------------------------------------------------------
exp(-k*x) * sin(omega*t) ~ .

## -----------------------------------------------------------------------------
g <- makeFun(exp(-k*x) * sin(omega*t) ~ .)

## -----------------------------------------------------------------------------
g

## -----------------------------------------------------------------------------
g <- makeFun(exp(-k*x) * sin(omega*t) ~ ., k=1/2, omega=3)

## -----------------------------------------------------------------------------
g

## ----fig.align="center"-------------------------------------------------------
slice_plot(g(x, t=pi/2) ~ x, bounds(x=-2:4))

## -----------------------------------------------------------------------------
D(a / x ~ x)
antiD(exp(-k*x) * sin(omega*t) ~ t)

## -----------------------------------------------------------------------------
antiD(pnorm(x) ~ x)

## ----results="hide"-----------------------------------------------------------
help(package="mosaicCalc")

## ----results="hide"-----------------------------------------------------------
?argM

## ----warning=FALSE, message=FALSE, fig.align="center"-------------------------
SIR <- makeODE(dS ~ -a*S*I, dI ~ a*S*I - b*I, 
               a=0.0026, b=.5, S=400, I=1)
soln <- integrateODE(SIR, bounds(t=0:20))
traj_plot(S(t) ~ I(t), soln, color="blue") %>% 
  vectorfield_plot(SIR, bounds(I=0:75, S=60:400), transform=I, 
                   npts=20, alpha = 0.6)

