/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.algorithm;

import java.util.ArrayList;
import net.sourceforge.jclec.AlgorithmEvent;
import net.sourceforge.jclec.IAlgorithm;
import net.sourceforge.jclec.IAlgorithmListener;
import net.sourceforge.jclec.IConfigure;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;

public abstract class AbstractAlgorithm
implements IAlgorithm,
IConfigure {
    protected static final int NEW = 0;
    protected static final int READY = 1;
    protected static final int RUNNING = 2;
    protected static final int FINISHED = 3;
    protected static final int TERMINATED = 4;
    protected int state = 0;
    protected ArrayList<IAlgorithmListener> listeners = new ArrayList();

    @Override
    public final void addListener(IAlgorithmListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public final boolean removeListener(IAlgorithmListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public void pause() {
        this.state = 1;
    }

    @Override
    public void terminate() {
        this.state = 4;
    }

    @Override
    public void execute() {
        do {
            switch (this.state) {
                case 0: {
                    this.state = 2;
                    this.doInit();
                    this.fireAlgorithmStarted();
                    break;
                }
                case 1: {
                    this.state = 2;
                    break;
                }
                case 2: {
                    this.doIterate();
                    this.fireIterationCompleted();
                }
            }
        } while (this.state == 2);
        if (this.state == 3) {
            this.fireAlgorithmFinished();
            this.state = 0;
            return;
        }
        if (this.state == 4) {
            this.fireAlgorithmTerminated();
            this.state = 0;
            return;
        }
    }

    @Override
    public void configure(Configuration configuration) {
        int numberOfListeners = configuration.getList("listener[@type]").size();
        int i = 0;
        while (i < numberOfListeners) {
            String header = "listener(" + i + ")";
            try {
                String listenerClassname = configuration.getString(String.valueOf(header) + "[@type]");
                Class<?> listenerClass = Class.forName(listenerClassname);
                IAlgorithmListener listener = (IAlgorithmListener)listenerClass.newInstance();
                if (listener instanceof IConfigure) {
                    ((IConfigure)((Object)listener)).configure(configuration.subset(header));
                }
                this.addListener(listener);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationRuntimeException("Illegal listener classname", e);
            }
            catch (InstantiationException e) {
                throw new ConfigurationRuntimeException("Illegal listener classname", e);
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationRuntimeException("Illegal listener classname", e);
            }
            ++i;
        }
    }

    protected abstract void doInit();

    protected abstract void doIterate();

    protected final void fireAlgorithmStarted() {
        AlgorithmEvent event = new AlgorithmEvent(this);
        for (IAlgorithmListener listener : this.listeners) {
            listener.algorithmStarted(event);
        }
    }

    protected final void fireIterationCompleted() {
        AlgorithmEvent event = new AlgorithmEvent(this);
        for (IAlgorithmListener listener : this.listeners) {
            listener.iterationCompleted(event);
        }
    }

    protected final void fireAlgorithmFinished() {
        AlgorithmEvent event = new AlgorithmEvent(this);
        for (IAlgorithmListener listener : this.listeners) {
            listener.algorithmFinished(event);
        }
    }

    protected final void fireAlgorithmTerminated() {
        AlgorithmEvent event = new AlgorithmEvent(this);
        for (IAlgorithmListener listener : this.listeners) {
            listener.algorithmTerminated(event);
        }
    }
}

