/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.CART;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.StreamTokenizer;
import keel.Algorithms.Decision_Trees.CART.CART;
import keel.Algorithms.Decision_Trees.CART.dataset.DataSetManager;
import keel.Algorithms.Decision_Trees.CART.impurities.IImpurityFunction;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.DoubleTransposedDataSet;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.KeelDataSet;

public abstract class RunCART {
    protected CART cartAlgorithm;
    protected static String modelFileName = "";
    protected static String trainFileName = "";
    protected DoubleTransposedDataSet trainData;
    protected static String testFileName = "";
    protected DoubleTransposedDataSet testData;
    protected static String trainOutputFileName;
    protected static String testOutputFileName;
    protected static String resultFileName;
    private int nParam = 3;
    private long startTime = System.currentTimeMillis();
    private int maxDepth;
    protected static IImpurityFunction impurityFunction;

    public RunCART(String file, boolean regression) {
        try {
            StreamTokenizer tokenizer = new StreamTokenizer(new BufferedReader(new FileReader(file)));
            this.initTokenizer(tokenizer);
            this.setOptions(tokenizer);
            System.out.println("trainFileName: " + trainFileName + " testFileName: " + testFileName);
            KeelDataSet trainKeel = new KeelDataSet(trainFileName, new String[0]);
            this.trainData = new DoubleTransposedDataSet();
            this.trainData.read(DataSetManager.readSchema(trainFileName), trainKeel);
            KeelDataSet testKeel = new KeelDataSet(testFileName, new String[0]);
            this.testData = new DoubleTransposedDataSet();
            this.testData.read(DataSetManager.readSchema(testFileName), testKeel);
            this.cartAlgorithm = new CART(this.trainData);
            this.cartAlgorithm.setImpurityFunction(impurityFunction);
            this.cartAlgorithm.setRegression(regression);
            this.cartAlgorithm.setMaxDepth(this.maxDepth);
            this.cartAlgorithm.build_tree();
            this.cartAlgorithm.prune_tree();
            System.out.println("Algorithm finished (" + (System.currentTimeMillis() - this.startTime) + ")");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initTokenizer(StreamTokenizer tokenizer) {
        tokenizer.resetSyntax();
        tokenizer.whitespaceChars(0, 32);
        tokenizer.wordChars(33, 255);
        tokenizer.whitespaceChars(44, 44);
        tokenizer.quoteChar(34);
        tokenizer.quoteChar(39);
        tokenizer.ordinaryChar(61);
        tokenizer.ordinaryChar(123);
        tokenizer.ordinaryChar(125);
        tokenizer.ordinaryChar(91);
        tokenizer.ordinaryChar(93);
        tokenizer.eolIsSignificant(true);
    }

    protected void setOptions(StreamTokenizer options) throws Exception {
        options.nextToken();
        if (options.sval.equalsIgnoreCase("algorithm")) {
            options.nextToken();
            options.nextToken();
            options.nextToken();
            options.nextToken();
            if (options.sval.equalsIgnoreCase("inputData")) {
                options.nextToken();
                options.nextToken();
                modelFileName = options.sval;
                if (options.nextToken() != 10) {
                    trainFileName = options.sval;
                    options.nextToken();
                    testFileName = options.sval;
                    if (options.nextToken() != 10) {
                        trainFileName = modelFileName;
                        options.nextToken();
                    }
                }
            } else {
                throw new Exception("No file test provided.");
            }
            do {
                if (options.nextToken() != -1) continue;
                throw new Exception("No output file provided.");
            } while (options.sval == null || !options.sval.equalsIgnoreCase("outputData"));
            options.nextToken();
            options.nextToken();
            trainOutputFileName = options.sval;
            options.nextToken();
            testOutputFileName = options.sval;
            options.nextToken();
            resultFileName = options.sval;
            if (!this.getNextToken(options)) {
                throw new Exception("No instances provided.");
            }
            if (options.ttype == -1) {
                return;
            }
            for (int k = 0; k < this.nParam; ++k) {
                if (!options.sval.equalsIgnoreCase("maxDepth")) continue;
                options.nextToken();
                options.nextToken();
                if (Integer.parseInt(options.sval) > 0) {
                    this.maxDepth = Integer.parseInt(options.sval);
                }
                if (this.getNextToken(options)) continue;
                return;
            }
        } else {
            throw new Exception("The file must start with the word algorithm followed of the name of the algorithm.");
        }
    }

    private boolean getNextToken(StreamTokenizer tokenizer) {
        try {
            if (tokenizer.nextToken() == -1) {
                return false;
            }
            tokenizer.pushBack();
            while (tokenizer.nextToken() != 10) {
            }
            while (tokenizer.nextToken() == 10) {
            }
            return tokenizer.sval != null;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return false;
        }
    }
}

