/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Associative_Classification.ClassifierCPAR;

import java.util.ArrayList;
import java.util.Collections;
import keel.Algorithms.Associative_Classification.ClassifierCPAR.DataBase;
import keel.Algorithms.Associative_Classification.ClassifierCPAR.Literal;
import keel.Algorithms.Associative_Classification.ClassifierCPAR.PNArray;
import keel.Algorithms.Associative_Classification.ClassifierCPAR.Rule;
import keel.Algorithms.Associative_Classification.ClassifierCPAR.RuleBase;
import keel.Algorithms.Associative_Classification.ClassifierCPAR.myDataset;

public class PRM {
    double alfa;
    double delta;
    double min_gain;
    int nClasses;
    int nData;
    myDataset train;
    DataBase dataBase;
    RuleBase ruleBase;
    int[] P;
    int[] N;
    PNArray A;
    int[] Pc;
    int[] Nc;
    PNArray Ac;

    public PRM() {
    }

    public PRM(DataBase dataBase, myDataset train, RuleBase ruleBase, double alfa, double delta, double min_gain) {
        this.dataBase = dataBase;
        this.train = train;
        this.ruleBase = ruleBase;
        this.alfa = alfa;
        this.delta = delta;
        this.min_gain = min_gain;
        this.nClasses = this.train.getnClasses();
        this.nData = this.train.getnData();
        this.P = new int[this.nData];
        this.N = new int[this.nData];
        this.A = new PNArray(train, dataBase);
        this.Pc = new int[this.nData];
        this.Nc = new int[this.nData];
        this.Ac = new PNArray(train, dataBase);
    }

    public void generatePR() {
        ArrayList<Rule> listRules = new ArrayList<Rule>();
        for (int i = 0; i < this.nClasses; ++i) {
            this.train.iniWeight();
            this.iniPN(i);
            this.A.ini(i);
            double totalWeight = this.delta * (double)this.train.numberInstances(i);
            listRules.clear();
            boolean stop = false;
            while (this.getTotalWeight() > totalWeight && !stop) {
                int j;
                Rule r;
                if (listRules.size() > 0) {
                    r = (Rule)listRules.get(0);
                    listRules.remove(0);
                    this.calculatePNc(r);
                    this.calculateAc(r);
                } else {
                    r = new Rule(this.train, this.dataBase, i);
                    this.copyPN();
                    this.copyA();
                }
                boolean addLiteral = true;
                while (r.getnAnts() < this.dataBase.numVariablesUsed() && addLiteral) {
                    ArrayList<Literal> listGain = r.getGain(this.min_gain, this.Ac);
                    if (listGain.size() > 0) {
                        Rule ruleAux = r.clone();
                        if (listGain.size() > 1) {
                            Collections.sort(listGain);
                        }
                        Literal lit = listGain.get(0);
                        double bestGain = lit.getGain();
                        r.setLabel(lit.getVariable(), lit.getValue());
                        this.changePNAc(lit);
                        for (j = 1; j < listGain.size(); ++j) {
                            lit = listGain.get(j);
                            if (lit.getGain() >= bestGain * 0.99) {
                                Rule ruleAux1 = ruleAux.clone();
                                ruleAux1.setLabel(lit.getVariable(), lit.getValue());
                                listRules.add(ruleAux1);
                                continue;
                            }
                            j = listGain.size();
                        }
                        listGain.clear();
                        continue;
                    }
                    addLiteral = false;
                }
                if (r.getnAnts() > 0) {
                    r.calculateLaplace(this.train);
                    this.ruleBase.add(r);
                    for (j = 0; j < this.nData; ++j) {
                        if (this.Pc[j] <= 0) continue;
                        this.A.reducePositive(j);
                        this.train.reduceWeight(j, this.alfa);
                        this.A.incrPositive(j);
                    }
                    continue;
                }
                stop = true;
            }
        }
        this.ruleBase.sort();
    }

    public void iniPN(int clas) {
        for (int i = 0; i < this.nData; ++i) {
            if (this.train.getOutputAsInteger(i) == clas) {
                this.P[i] = 1;
                this.N[i] = 0;
                continue;
            }
            this.P[i] = 0;
            this.N[i] = 1;
        }
    }

    public void copyPN() {
        for (int i = 0; i < this.nData; ++i) {
            this.Pc[i] = this.P[i];
            this.Nc[i] = this.N[i];
        }
    }

    public void copyA() {
        this.Ac.copy(this.A);
    }

    public void calculatePNc(Rule r) {
        for (int i = 0; i < this.nData; ++i) {
            if (r.matching(this.train.getExample(i)) > 0.0) {
                if (this.train.getOutputAsInteger(i) == r.getClas()) {
                    this.Pc[i] = 1;
                    this.Nc[i] = 0;
                    continue;
                }
                this.Pc[i] = 0;
                this.Nc[i] = 1;
                continue;
            }
            this.Pc[i] = 0;
            this.Nc[i] = 0;
        }
    }

    public void calculateAc(Rule r) {
        this.Ac.ini(r);
    }

    public void changePNAc(Literal lit) {
        for (int j = 0; j < this.nData; ++j) {
            int[] example = this.train.getExample(j);
            if (this.Pc[j] > 0) {
                if (example[lit.getVariable()] == lit.getValue()) continue;
                this.Pc[j] = 0;
                this.Ac.reducePositive(j);
                continue;
            }
            if (this.Nc[j] <= 0 || example[lit.getVariable()] == lit.getValue()) continue;
            this.Nc[j] = 0;
            this.Ac.reduceNegative(j);
        }
    }

    public double getTotalWeight() {
        double total = 0.0;
        for (int i = 0; i < this.nData; ++i) {
            if (this.P[i] <= 0) continue;
            total += this.train.getWeight(i);
        }
        return total;
    }
}

