/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml.pull;

import javolution.lang.PersistentReference;
import javolution.xml.pull.CharSequenceImpl;

final class Namespaces {
    private static final PersistentReference SIZE = new PersistentReference<Integer>("javolution.xml.pull.Namespaces#SIZE", new Integer(64));
    private int[] _nspCounts = new int[((Integer)SIZE.get()).intValue()];
    private int _mapCount;
    private CharSequenceImpl[] _namespaces = new CharSequenceImpl[((Integer)SIZE.get()).intValue()];
    private int _depth;
    private CharSequenceImpl _default = CharSequenceImpl.EMPTY;
    private static final CharSequenceImpl XML_PREFIX = new CharSequenceImpl("xml");
    private static final CharSequenceImpl XML_URI = new CharSequenceImpl("http://www.w3.org/XML/1998/namespace");
    private static final CharSequenceImpl XMLNS_PREFIX = new CharSequenceImpl("xmlns");
    private static final CharSequenceImpl XMLNS_URI = new CharSequenceImpl("http://www.w3.org/2000/xmlns/");

    public CharSequenceImpl getDefault() {
        return this._default;
    }

    public int getNamespaceCount(int n) {
        if (n > this._depth) {
            return this._nspCounts[this._depth];
        }
        return this._nspCounts[n];
    }

    public CharSequenceImpl getNamespacePrefix(int n) {
        return this._namespaces[n << 1];
    }

    public CharSequenceImpl getNamespaceUri(int n) {
        return this._namespaces[(n << 1) + 1];
    }

    public CharSequenceImpl getNamespaceUri(String string) {
        if (string == null) {
            return this._default;
        }
        int n = this._nspCounts[this._depth] + this._mapCount;
        while (n > 0) {
            CharSequenceImpl charSequenceImpl;
            if ((charSequenceImpl = this._namespaces[--n << 1]) == null || !charSequenceImpl.equals(string)) continue;
            return this._namespaces[(n << 1) + 1];
        }
        if (XML_PREFIX.equals(string)) {
            return XML_URI;
        }
        if (XMLNS_PREFIX.equals(string)) {
            return XMLNS_URI;
        }
        return null;
    }

    CharSequenceImpl getNamespaceUri(CharSequenceImpl charSequenceImpl) {
        int n = this._nspCounts[this._depth] + this._mapCount;
        while (n > 0) {
            CharSequenceImpl charSequenceImpl2;
            if ((charSequenceImpl2 = this._namespaces[--n << 1]) == null || !charSequenceImpl2.equals(charSequenceImpl)) continue;
            return this._namespaces[(n << 1) + 1];
        }
        if (XML_PREFIX.equals(charSequenceImpl)) {
            return XML_URI;
        }
        if (XMLNS_PREFIX.equals(charSequenceImpl)) {
            return XMLNS_URI;
        }
        return null;
    }

    public void map(CharSequenceImpl charSequenceImpl, CharSequenceImpl charSequenceImpl2) {
        int n;
        if ((n = this._nspCounts[this._depth] + this._mapCount++ << 1) + 1 >= this._namespaces.length) {
            this.resize();
        }
        this._namespaces[n] = charSequenceImpl;
        this._namespaces[n + 1] = charSequenceImpl2;
        if (charSequenceImpl == null) {
            this._default = charSequenceImpl2;
        }
    }

    public void flush() {
        if (this._mapCount != 0) {
            this.push();
            this.pop();
        }
    }

    public void push() {
        if (++this._depth >= this._nspCounts.length) {
            this.resize();
        }
        this._nspCounts[this._depth] = this._nspCounts[this._depth - 1] + this._mapCount;
        this._mapCount = 0;
    }

    public void pop() {
        this._mapCount = 0;
        int n = this._nspCounts[this._depth];
        int n2 = this._nspCounts[--this._depth];
        int n3 = n;
        block0: while (n3 > n2) {
            if (this._namespaces[--n3 << 1] != null) continue;
            this._default = CharSequenceImpl.EMPTY;
            int n4 = n3;
            while (n4 > 0) {
                if (this._namespaces[--n4 << 1] != null) continue;
                this._default = this._namespaces[(n4 << 1) + 1];
                continue block0;
            }
        }
    }

    public void reset() {
        this._depth = 0;
        this._nspCounts[0] = 0;
        this._default = CharSequenceImpl.EMPTY;
    }

    private void resize() {
        int n = this._nspCounts.length;
        int[] nArray = new int[n * 2];
        System.arraycopy(this._nspCounts, 0, nArray, 0, n);
        this._nspCounts = nArray;
        CharSequenceImpl[] charSequenceImplArray = new CharSequenceImpl[n * 2];
        System.arraycopy(this._namespaces, 0, charSequenceImplArray, 0, n);
        this._namespaces = charSequenceImplArray;
        SIZE.setMinimum(new Integer(this._namespaces.length));
    }
}

