/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries;

import ec.tstoolkit.design.IntValue;

public enum DayOfWeek implements IntValue
{
    Sunday(0),
    Monday(1),
    Tuesday(2),
    Wednesday(3),
    Thursday(4),
    Friday(5),
    Saturday(6);

    private final int value;

    public static DayOfWeek fromCalendar(int dayofweek) {
        return DayOfWeek.valueOf((dayofweek - 1 + 6) % 7);
    }

    public static int toCalendar(DayOfWeek dayofWeek) {
        switch (dayofWeek.ordinal()) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 6;
            }
            case 6: {
                return 7;
            }
        }
        throw new RuntimeException();
    }

    public static DayOfWeek valueOf(int value) {
        return IntValue.valueOf(DayOfWeek.class, value).orElse(null);
    }

    private DayOfWeek(int value) {
        this.value = value;
    }

    @Override
    public int intValue() {
        return this.value;
    }
}

