/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.modelling.arima.IPreprocessingModule;
import ec.tstoolkit.modelling.arima.ModelEstimation;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.ProcessingResult;
import ec.tstoolkit.modelling.arima.tramo.AbstractTramoModule;
import ec.tstoolkit.modelling.arima.tramo.ArmaModule;
import ec.tstoolkit.modelling.arima.tramo.DifferencingModule;

public class AutomaticModelIdentification
extends AbstractTramoModule
implements IPreprocessingModule {
    private final IPreprocessingModule diff_;
    private final IPreprocessingModule arma_;

    public AutomaticModelIdentification() {
        this.diff_ = new DifferencingModule();
        this.arma_ = new ArmaModule();
    }

    public AutomaticModelIdentification(IPreprocessingModule differencing, IPreprocessingModule arma) {
        this.diff_ = differencing;
        this.arma_ = arma;
    }

    @Override
    public ProcessingResult process(ModellingContext context) {
        if (context.estimation == null) {
            ModelEstimation estimation = new ModelEstimation(context.description.buildRegArima(), context.description.getLikelihoodCorrection());
            estimation.compute(this.getMonitor(), context.description.getArimaComponent().getFreeParametersCount());
        }
        ProcessingResult drslt = this.diff_.process(context);
        ProcessingResult arslt = this.arma_.process(context);
        if (drslt == ProcessingResult.Changed) {
            if (arslt.isProcessed()) {
                return ProcessingResult.Changed;
            }
            return ProcessingResult.Failed;
        }
        return arslt;
    }
}

