/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import java.util.Iterator;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.AbstractPackMatrix;
import no.uib.cipr.matrix.BLASkernel;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Interface;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractTriangPackMatrix
extends AbstractPackMatrix {
    BLASkernel.UpLo uplo;
    BLASkernel.Diag diag;

    AbstractTriangPackMatrix(int n, BLASkernel.UpLo uplo, BLASkernel.Diag diag) {
        super(n);
        this.uplo = uplo;
        this.diag = diag;
    }

    AbstractTriangPackMatrix(Matrix A, BLASkernel.UpLo uplo, BLASkernel.Diag diag) {
        this(A, false, uplo, diag);
    }

    AbstractTriangPackMatrix(Matrix A, boolean deep, BLASkernel.UpLo uplo, BLASkernel.Diag diag) {
        super(A, deep);
        this.uplo = uplo;
        this.diag = diag;
    }

    @Override
    public Vector mult(double alpha, Vector x, Vector y) {
        if (!(y instanceof DenseVector)) {
            return super.mult(alpha, x, y);
        }
        this.checkMultAdd(x, y);
        double[] yd = ((DenseVector)y).getData();
        y.set(alpha, x);
        Interface.blas().tpmv(this.uplo, BLASkernel.Transpose.NoTranspose, this.diag, this.numRows, this.data, yd);
        return y;
    }

    @Override
    public Vector transMult(double alpha, Vector x, Vector y) {
        if (!(y instanceof DenseVector)) {
            return super.transMult(alpha, x, y);
        }
        this.checkTransMultAdd(x, y);
        double[] yd = ((DenseVector)y).getData();
        y.set(alpha, x);
        Interface.blas().tpmv(this.uplo, BLASkernel.Transpose.Transpose, this.diag, this.numRows, this.data, yd);
        return y;
    }

    @Override
    public Matrix solve(Matrix B, Matrix X) {
        return this.solve(B, X, BLASkernel.Transpose.NoTranspose);
    }

    @Override
    public Vector solve(Vector b, Vector x) {
        DenseMatrix B = new DenseMatrix(b, false);
        DenseMatrix X = new DenseMatrix(x, false);
        this.solve(B, X);
        return x;
    }

    @Override
    public Matrix transSolve(Matrix B, Matrix X) {
        return this.solve(B, X, BLASkernel.Transpose.Transpose);
    }

    @Override
    public Vector transSolve(Vector b, Vector x) {
        DenseMatrix B = new DenseMatrix(b, false);
        DenseMatrix X = new DenseMatrix(x, false);
        this.transSolve(B, X);
        return x;
    }

    Matrix solve(Matrix B, Matrix X, BLASkernel.Transpose trans) {
        if (!(X instanceof DenseMatrix)) {
            throw new UnsupportedOperationException("X must be a DenseMatrix");
        }
        this.checkSolve(B, X);
        double[] Xd = ((DenseMatrix)X).getData();
        X.set(B);
        int info = Interface.lapack().tptrs(this.uplo, trans, this.diag, this.numRows, X.numColumns(), this.data, Xd);
        if (info > 0) {
            throw new MatrixSingularException();
        }
        if (info < 0) {
            throw new IllegalArgumentException();
        }
        return X;
    }

    @Override
    public Iterator<MatrixEntry> iterator() {
        return new TriangPackMatrixIterator();
    }

    private class TriangPackMatrixIterator
    extends AbstractMatrix.RefMatrixIterator {
        private TriangPackMatrixIterator() {
        }

        public MatrixEntry next() {
            this.entry.update(this.row, this.column);
            if (AbstractTriangPackMatrix.this.uplo == BLASkernel.UpLo.Lower) {
                if (this.row < AbstractTriangPackMatrix.this.numRows - 1) {
                    ++this.row;
                } else {
                    ++this.column;
                    this.row = this.column;
                }
            } else if (this.row < this.column) {
                ++this.row;
            } else {
                ++this.column;
                this.row = 0;
            }
            return this.entry;
        }
    }
}

