/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.coalescent;

public interface DemographicFunction {
    public double getDemographic(double var1);

    public double getIntensity(double var1);

    public double getInverseIntensity(double var1);

    public boolean hasIntegral();

    public double getIntegral(double var1, double var3);

    public int getArgumentCount();

    public String getArgumentName(int var1);

    public double getArgument(int var1);

    public void setArgument(int var1, double var2);

    public double getLowerBound(int var1);

    public double getUpperBound(int var1);

    public static class Utils {
        private Utils() {
        }

        public static void testConsistency(DemographicFunction demographicFunction, int steps, double maxTime) {
            double delta = maxTime / (double)steps;
            for (int i = 0; i <= steps; ++i) {
                double time = (double)i * delta;
                double intensity = demographicFunction.getIntensity(time);
                double newTime = demographicFunction.getInverseIntensity(intensity);
                if (!(Math.abs(time - newTime) > 1.0E-12)) continue;
                throw new RuntimeException("Demographic model not consistent! error size = " + Math.abs(time - newTime));
            }
        }
    }
}

