/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.MathUtils;
import dr.math.distributions.LKJCorrelationDistribution;
import dr.math.distributions.RandomGenerator;
import java.util.ArrayList;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class LKJCorrelationWithStructuralZerosDistribution
extends LKJCorrelationDistribution
implements RandomGenerator {
    private final int[] blockAssignments;
    public static final String LKJ_WITH_ZEROS = "LKJCorrelationWithZerosDistribution";
    public static boolean DEBUG = false;

    public LKJCorrelationWithStructuralZerosDistribution(int n, double d, ArrayList<int[]> arrayList) {
        super(n, d);
        this.blockAssignments = new int[n];
        for (int i = 0; i < arrayList.size(); ++i) {
            for (int j = 0; j < arrayList.get(i).length; ++j) {
                this.blockAssignments[arrayList.get((int)i)[j]] = i + 1;
            }
        }
        System.err.println("Warning: LKJCorrelationDistribution with structural zeros does not have proper normalization constant");
    }

    public double[] nextRandom() {
        int n;
        int n2;
        DenseMatrix64F denseMatrix64F = new DenseMatrix64F(this.dim, this.dim);
        for (n2 = 0; n2 < this.dim; ++n2) {
            for (n = n2 + 1; n < this.dim; ++n) {
                if (this.blockAssignments[n2] != 0 && this.blockAssignments[n2] == this.blockAssignments[n]) continue;
                int n3 = n - n2;
                double d = this.shape + 0.5 * (double)(this.dim - 1 - n3);
                double d2 = MathUtils.nextBeta(d, d);
                d2 *= 2.0;
                denseMatrix64F.set(n2, n, d2 -= 1.0);
                denseMatrix64F.set(n, n2, d2);
            }
        }
        if (DEBUG) {
            System.out.println(denseMatrix64F);
        }
        for (n2 = 0; n2 < this.dim; ++n2) {
            denseMatrix64F.set(n2, n2, 1.0);
        }
        for (n2 = 2; n2 < this.dim; ++n2) {
            n = n2 - 1;
            DenseMatrix64F denseMatrix64F2 = new DenseMatrix64F(n, n);
            DenseMatrix64F denseMatrix64F3 = new DenseMatrix64F(n, n);
            DenseMatrix64F denseMatrix64F4 = new DenseMatrix64F(n, 1);
            DenseMatrix64F denseMatrix64F5 = new DenseMatrix64F(n, 1);
            DenseMatrix64F denseMatrix64F6 = new DenseMatrix64F(n, 1);
            DenseMatrix64F denseMatrix64F7 = new DenseMatrix64F(n, 1);
            for (int i = 0; i < this.dim - n2; ++i) {
                int n4 = i + n2;
                for (int j = 0; j < n; ++j) {
                    int n5 = j + i + 1;
                    denseMatrix64F4.set(j, 0, denseMatrix64F.get(n5, i));
                    denseMatrix64F5.set(j, 0, denseMatrix64F.get(n5, n4));
                    for (int k = 0; k < n; ++k) {
                        denseMatrix64F3.set(j, k, denseMatrix64F.get(n5, k + i + 1));
                    }
                }
                CommonOps.invert(denseMatrix64F3, denseMatrix64F2);
                CommonOps.mult(denseMatrix64F2, denseMatrix64F4, denseMatrix64F6);
                CommonOps.mult(denseMatrix64F2, denseMatrix64F5, denseMatrix64F7);
                double d = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                for (int j = 0; j < n; ++j) {
                    d += denseMatrix64F6.get(j, 0) * denseMatrix64F4.get(j, 0);
                    d3 += denseMatrix64F7.get(j, 0) * denseMatrix64F4.get(j, 0);
                    d4 += denseMatrix64F7.get(j, 0) * denseMatrix64F5.get(j, 0);
                }
                double d5 = (1.0 - d) * (1.0 - d4);
                double d6 = d3 + denseMatrix64F.get(i, n4) * Math.sqrt(d5);
                denseMatrix64F.set(i, n4, d6);
                denseMatrix64F.set(n4, i, d6);
            }
        }
        double[] dArray = new double[LKJCorrelationWithStructuralZerosDistribution.upperTriangularSize(this.dim)];
        n = 0;
        for (int i = 0; i < this.dim; ++i) {
            for (int j = i + 1; j < this.dim; ++j) {
                dArray[n] = denseMatrix64F.get(i, j);
                ++n;
            }
        }
        if (DEBUG) {
            System.out.println(denseMatrix64F);
        }
        return dArray;
    }

    @Override
    public double logPdf(Object object) {
        return this.logPdf((double[])object);
    }
}

