/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.model.Parameter;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.inference.regression.SelfControlledCaseSeries;
import dr.math.MathUtils;
import dr.math.Poisson;
import dr.math.distributions.NormalDistribution;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.HashSet;

public class MultivariateNormalIndependenceSampler
extends AbstractAdaptableOperator {
    public static final String OPERATOR_NAME = "multivariateNormalIndependenceSampler";
    public static final String SCALE_FACTOR = "scaleFactor";
    public static final String SET_SIZE_MEAN = "setSizeMean";
    private double scaleFactor;
    private final Parameter parameter;
    private final int dim;
    private double setSizeMean;
    private final SelfControlledCaseSeries sccs;
    private static final boolean UPDATE_ALL = false;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("scaleFactor"), AttributeRule.newDoubleRule("weight"), AttributeRule.newBooleanRule("autoOptimize", true), AttributeRule.newDoubleRule("setSizeMean", true), new ElementRule(SelfControlledCaseSeries.class), new ElementRule(Parameter.class)};

        @Override
        public String getParserName() {
            return MultivariateNormalIndependenceSampler.OPERATOR_NAME;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            AdaptationMode adaptationMode = AdaptationMode.parseMode(xMLObject);
            double d = xMLObject.getDoubleAttribute("weight");
            double d2 = xMLObject.getDoubleAttribute(MultivariateNormalIndependenceSampler.SCALE_FACTOR);
            if (d2 <= 0.0) {
                throw new XMLParseException("scaleFactor must be greater than 0.0");
            }
            Parameter parameter = (Parameter)xMLObject.getChild(Parameter.class);
            SelfControlledCaseSeries selfControlledCaseSeries = (SelfControlledCaseSeries)xMLObject.getChild(SelfControlledCaseSeries.class);
            double d3 = xMLObject.getAttribute(MultivariateNormalIndependenceSampler.SET_SIZE_MEAN, -1.0);
            return new MultivariateNormalIndependenceSampler(parameter, selfControlledCaseSeries, d3, d, d2, adaptationMode);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "This element returns an independence sampler from a provided normal distribution model.";
        }

        @Override
        public Class getReturnType() {
            return MultivariateNormalIndependenceSampler.class;
        }
    };

    public MultivariateNormalIndependenceSampler(Parameter parameter, SelfControlledCaseSeries selfControlledCaseSeries, double d, double d2, double d3, AdaptationMode adaptationMode) {
        super(adaptationMode);
        this.scaleFactor = d3;
        this.parameter = parameter;
        this.setWeight(d2);
        this.dim = parameter.getDimension();
        this.setWeight(d2);
        this.sccs = selfControlledCaseSeries;
        this.setSizeMean = d;
    }

    @Override
    public String getAdaptableParameterName() {
        return SCALE_FACTOR;
    }

    @Override
    public String getOperatorName() {
        return "independentNormalDistribution(" + this.parameter.getVariableName() + ")";
    }

    @Override
    public double doOperation() {
        int n;
        double[] dArray = this.sccs.getMode();
        double[] dArray2 = this.parameter.getParameterValues();
        double[] dArray3 = new double[this.dim];
        HashSet<Integer> hashSet = new HashSet<Integer>();
        if (this.setSizeMean != -1.0) {
            n = Poisson.nextPoisson(this.setSizeMean);
            while (hashSet.size() < n) {
                int n2 = MathUtils.nextInt(this.parameter.getDimension());
                if (hashSet.contains(n2)) continue;
                hashSet.add(n2);
            }
        } else {
            for (n = 0; n < this.dim; ++n) {
                hashSet.add(n);
            }
        }
        double d = 0.0;
        for (Integer n3 : hashSet) {
            dArray3[n3.intValue()] = dArray[n3] + this.scaleFactor * MathUtils.nextGaussian();
            this.parameter.setParameterValue(n3, dArray3[n3]);
            d += NormalDistribution.logPdf(dArray2[n3], dArray[n3], this.scaleFactor) - NormalDistribution.logPdf(dArray3[n3], dArray[n3], this.scaleFactor);
        }
        return d;
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(this.scaleFactor);
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        this.scaleFactor = Math.exp(d);
    }

    @Override
    public double getRawParameter() {
        return this.scaleFactor;
    }
}

