/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.preorder;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evolution.tree.TreeTraitProvider;
import dr.evomodel.continuous.MultivariateDiffusionModel;
import dr.evomodel.treedatalikelihood.ProcessOnTreeDelegate;
import dr.evomodel.treedatalikelihood.continuous.ConjugateRootTraitPrior;
import dr.evomodel.treedatalikelihood.continuous.ContinuousDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.continuous.ContinuousRateTransformation;
import dr.evomodel.treedatalikelihood.continuous.ContinuousTraitPartialsProvider;
import dr.evomodel.treedatalikelihood.preorder.ProcessSimulationDelegate;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractRealizedContinuousTraitDelegate
extends ProcessSimulationDelegate.AbstractContinuousTraitDelegate {
    public static final String REALIZED_TIP_TRAIT = "tip";
    final double[] sample;
    final double[] tmpEpsilon;
    final double[] tmpDrift;

    AbstractRealizedContinuousTraitDelegate(String string, Tree tree, MultivariateDiffusionModel multivariateDiffusionModel, ContinuousTraitPartialsProvider continuousTraitPartialsProvider, ConjugateRootTraitPrior conjugateRootTraitPrior, ContinuousRateTransformation continuousRateTransformation, ContinuousDataLikelihoodDelegate continuousDataLikelihoodDelegate) {
        super(string, tree, multivariateDiffusionModel, continuousTraitPartialsProvider, conjugateRootTraitPrior, continuousRateTransformation, continuousDataLikelihoodDelegate);
        this.sample = new double[this.dimNode * tree.getNodeCount()];
        this.tmpEpsilon = new double[this.dimTrait];
        this.tmpDrift = new double[this.dimTrait];
    }

    @Override
    protected void constructTraits(TreeTraitProvider.Helper helper) {
        TreeTrait.DA dA = new TreeTrait.DA(){

            @Override
            public String getTraitName() {
                return AbstractRealizedContinuousTraitDelegate.this.name;
            }

            @Override
            public TreeTrait.Intent getIntent() {
                return TreeTrait.Intent.NODE;
            }

            @Override
            public double[] getTrait(Tree tree, NodeRef nodeRef) {
                if (tree != AbstractRealizedContinuousTraitDelegate.this.tree) {
                    if (tree == AbstractRealizedContinuousTraitDelegate.this.baseTree) {
                        nodeRef = ProcessSimulationDelegate.AbstractDelegate.getBaseNode(tree, nodeRef);
                    } else {
                        throw new RuntimeException("Tree '" + tree.getId() + "' and likelihood '" + AbstractRealizedContinuousTraitDelegate.this.tree.getId() + "' mismatch");
                    }
                }
                return AbstractRealizedContinuousTraitDelegate.this.getTraitForNode(nodeRef);
            }
        };
        helper.addTrait(dA);
        TreeTrait.DA dA2 = new TreeTrait.DA(){

            @Override
            public String getTraitName() {
                return AbstractRealizedContinuousTraitDelegate.getTipTraitName(AbstractRealizedContinuousTraitDelegate.this.name);
            }

            @Override
            public TreeTrait.Intent getIntent() {
                return TreeTrait.Intent.WHOLE_TREE;
            }

            @Override
            public double[] getTrait(Tree tree, NodeRef nodeRef) {
                assert (tree == AbstractRealizedContinuousTraitDelegate.this.tree);
                return AbstractRealizedContinuousTraitDelegate.this.getTraitForAllTips();
            }
        };
        helper.addTrait(dA2);
        TreeTrait.DA dA3 = new TreeTrait.DA(){

            @Override
            public String getTraitName() {
                return AbstractRealizedContinuousTraitDelegate.getTipPrecisionName(AbstractRealizedContinuousTraitDelegate.this.name);
            }

            @Override
            public TreeTrait.Intent getIntent() {
                return TreeTrait.Intent.WHOLE_TREE;
            }

            @Override
            public double[] getTrait(Tree tree, NodeRef nodeRef) {
                assert (tree == AbstractRealizedContinuousTraitDelegate.this.tree);
                return AbstractRealizedContinuousTraitDelegate.this.getPrecisionForAllTips();
            }
        };
        helper.addTrait(dA3);
    }

    public static String getTipTraitName(String string) {
        return "tip." + string;
    }

    private static String getTipPrecisionName(String string) {
        return "precision." + string;
    }

    private double[] getTraitForAllTips() {
        assert (this.simulationProcess != null);
        this.simulationProcess.cacheSimulatedTraits(null);
        int n = this.dimNode * this.tree.getExternalNodeCount();
        double[] dArray = new double[n];
        System.arraycopy(this.sample, 0, dArray, 0, n);
        return dArray;
    }

    private double[] getPrecisionForAllTips() {
        assert (this.simulationProcess != null);
        this.simulationProcess.cacheSimulatedTraits(null);
        int n = this.tree.getExternalNodeCount();
        double[] dArray = new double[n];
        Arrays.fill(dArray, Double.POSITIVE_INFINITY);
        return dArray;
    }

    private double[] getTraitForNode(NodeRef nodeRef) {
        assert (this.simulationProcess != null);
        this.simulationProcess.cacheSimulatedTraits(null);
        if (nodeRef == null) {
            return this.getTraitForAllTips();
        }
        double[] dArray = new double[this.dimNode];
        System.arraycopy(this.sample, nodeRef.getNumber() * this.dimNode, dArray, 0, this.dimNode);
        return dArray;
    }

    @Override
    public int vectorizeNodeOperations(List<ProcessOnTreeDelegate.NodeOperation> list, int[] nArray) {
        int n = 0;
        for (ProcessOnTreeDelegate.NodeOperation nodeOperation : list) {
            nArray[n] = nodeOperation.getNodeNumber();
            nArray[n + 1] = nodeOperation.getLeftChild();
            nArray[n + 2] = this.likelihoodDelegate.getActiveNodeIndex(nodeOperation.getLeftChild());
            nArray[n + 3] = this.likelihoodDelegate.getActiveMatrixIndex(nodeOperation.getLeftChild());
            nArray[n + 4] = nodeOperation.getLeftChild() < this.tree.getExternalNodeCount() ? 1 : 0;
            n += 5;
        }
        return list.size();
    }
}

