/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evolution.tree.TreeTraitProvider;
import dr.evolution.util.Taxon;

public class WanderingTaxonLogger
implements TreeTraitProvider {
    public static final String WANDERER = "wanderingTaxonLogger";
    public static final String RELATIVE = "relative";
    TreeTrait relativeTrait = new TreeTrait.I(){

        @Override
        public String getTraitName() {
            return WanderingTaxonLogger.this.name;
        }

        @Override
        public TreeTrait.Intent getIntent() {
            return TreeTrait.Intent.NODE;
        }

        @Override
        public Integer getTrait(Tree tree, NodeRef nodeRef) {
            int n = 0;
            if (WanderingTaxonLogger.this.relative == Relative.PARENT) {
                if (WanderingTaxonLogger.this.isAnyChildEqualToTaxon(tree, nodeRef, WanderingTaxonLogger.this.taxon, null)) {
                    n = 1;
                }
            } else if (WanderingTaxonLogger.this.relative == Relative.SISTER && !tree.isRoot(nodeRef) && WanderingTaxonLogger.this.isAnyChildEqualToTaxon(tree, tree.getParent(nodeRef), WanderingTaxonLogger.this.taxon, nodeRef)) {
                n = 1;
            }
            return n;
        }
    };
    private String name;
    private Taxon taxon;
    private Relative relative;

    public WanderingTaxonLogger(String string, Taxon taxon, Relative relative) {
        this.name = string == null ? RELATIVE : string;
        this.taxon = taxon;
        this.relative = relative;
    }

    @Override
    public TreeTrait[] getTreeTraits() {
        return new TreeTrait[]{this.relativeTrait};
    }

    @Override
    public TreeTrait getTreeTrait(String string) {
        return this.relativeTrait;
    }

    private boolean isAnyChildEqualToTaxon(Tree tree, NodeRef nodeRef, Taxon taxon, NodeRef nodeRef2) {
        for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
            String string;
            NodeRef nodeRef3 = tree.getChild(nodeRef, i);
            if (nodeRef3 == nodeRef2 || !tree.isExternal(nodeRef3) || !(string = tree.getNodeTaxon(nodeRef3).getId()).equals(taxon.getId())) continue;
            return true;
        }
        return false;
    }

    public static enum Relative {
        PARENT,
        SISTER;

    }
}

