/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.speciation;

import dr.evomodel.speciation.NewBirthDeathSerialSamplingModel;
import dr.inference.model.Statistic;

public class BirthDeathCompoundParameterLogger
extends Statistic.Abstract {
    private final NewBirthDeathSerialSamplingModel bdss;
    private final int dim;
    private final BDPCompoundParameterType type;

    public BirthDeathCompoundParameterLogger(NewBirthDeathSerialSamplingModel newBirthDeathSerialSamplingModel, BDPCompoundParameterType bDPCompoundParameterType) {
        this.bdss = newBirthDeathSerialSamplingModel;
        this.type = bDPCompoundParameterType;
        this.dim = newBirthDeathSerialSamplingModel.getDeathRateParameter().getDimension();
    }

    private double getCompoundParameter(int n) {
        double d = this.bdss.getBirthRateParameter().getParameterValue(n);
        double d2 = this.bdss.getDeathRateParameter().getParameterValue(n);
        double d3 = this.bdss.getSamplingRateParameter().getParameterValue(n);
        double d4 = this.bdss.getTreatmentProbabilityParameter().getParameterValue(n);
        double d5 = this.bdss.getSamplingProbabilityParameter().getParameterValue(n);
        return this.type.getCompoundParameterForType(d, d2, d3, d4, d5);
    }

    @Override
    public int getDimension() {
        return this.dim;
    }

    @Override
    public double getStatisticValue(int n) {
        return this.getCompoundParameter(n);
    }

    public static enum BDPCompoundParameterType {
        EFFECTIVE_REPRODUCTIVE_NUMBER("effectiveReproductiveNumber"){

            @Override
            public double getCompoundParameterForType(double d, double d2, double d3, double d4, double d5) {
                return d / (d3 * d4 + d2);
            }
        };

        private String name;

        private BDPCompoundParameterType(String string2) {
            this.name = string2;
        }

        public String getName() {
            return this.name;
        }

        public abstract double getCompoundParameterForType(double var1, double var3, double var5, double var7, double var9);
    }
}

