/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.basta;

import dr.evolution.tree.Tree;
import dr.evomodel.coalescent.basta.BastaLikelihoodDelegate;
import dr.evomodel.coalescent.basta.ProcessOnCoalescentIntervalDelegate;
import dr.evomodel.substmodel.EigenDecomposition;
import java.util.Arrays;
import java.util.List;

public class GenericBastaLikelihoodDelegate
extends BastaLikelihoodDelegate.AbstractBastaLikelihoodDelegate {
    private final double[] partials;
    private final double[] matrices;
    private final double[] sizes;
    private final double[] coalescent;
    private final double[] e;
    private final double[] f;
    private final double[] g;
    private final double[] h;
    private final double[] temp;
    private final EigenDecomposition[] decompositions;
    private final double[][][] partialsGrad;
    private final double[][][] matricesGrad;
    private final double[][][] coalescentGrad;
    private final double[][][] eGrad;
    private final double[][][] fGrad;
    private final double[][][] gGrad;
    private final double[][][] hGrad;
    private final double[][] partialsGradPopSize;
    private final double[][] coalescentGradPopSize;
    private final double[][] eGradPopSize;
    private final double[][] fGradPopSize;
    private final double[][] gGradPopSize;
    private final double[][] hGradPopSize;

    public GenericBastaLikelihoodDelegate(String string, Tree tree, int n, boolean bl) {
        super(string, tree, n, bl);
        this.partials = new double[this.maxNumCoalescentIntervals * (tree.getNodeCount() + 1) * n];
        this.matrices = new double[this.maxNumCoalescentIntervals * n * n];
        this.coalescent = new double[this.maxNumCoalescentIntervals];
        this.sizes = new double[2 * n];
        this.decompositions = new EigenDecomposition[1];
        this.e = new double[this.maxNumCoalescentIntervals * n];
        this.f = new double[this.maxNumCoalescentIntervals * n];
        this.g = new double[this.maxNumCoalescentIntervals * n];
        this.h = new double[this.maxNumCoalescentIntervals * n];
        this.partialsGrad = new double[n][n][this.maxNumCoalescentIntervals * (tree.getNodeCount() + 1) * n];
        this.matricesGrad = new double[n][n][this.maxNumCoalescentIntervals * n * n];
        this.coalescentGrad = new double[n][n][this.maxNumCoalescentIntervals];
        this.eGrad = new double[n][n][this.maxNumCoalescentIntervals * n];
        this.fGrad = new double[n][n][this.maxNumCoalescentIntervals * n];
        this.gGrad = new double[n][n][this.maxNumCoalescentIntervals * n];
        this.hGrad = new double[n][n][this.maxNumCoalescentIntervals * n];
        this.partialsGradPopSize = new double[n][this.maxNumCoalescentIntervals * (tree.getNodeCount() + 1) * n];
        this.coalescentGradPopSize = new double[n][this.maxNumCoalescentIntervals];
        this.eGradPopSize = new double[n][this.maxNumCoalescentIntervals * n];
        this.fGradPopSize = new double[n][this.maxNumCoalescentIntervals * n];
        this.gGradPopSize = new double[n][this.maxNumCoalescentIntervals * n];
        this.hGradPopSize = new double[n][this.maxNumCoalescentIntervals * n];
        this.temp = new double[n * n];
    }

    @Override
    protected void computeBranchIntervalOperations(List<Integer> list, List<ProcessOnCoalescentIntervalDelegate.BranchIntervalOperation> list2) {
        Arrays.fill(this.coalescent, 0.0);
        for (int i = 0; i < list.size() - 1; ++i) {
            int n = list.get(i);
            int n2 = list.get(i + 1);
            this.computeInnerBranchIntervalOperations(list2, n, n2);
        }
    }

    protected void computeInnerBranchIntervalOperations(List<ProcessOnCoalescentIntervalDelegate.BranchIntervalOperation> list, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            ProcessOnCoalescentIntervalDelegate.BranchIntervalOperation branchIntervalOperation = list.get(i);
            GenericBastaLikelihoodDelegate.peelPartials(this.partials, branchIntervalOperation.outputBuffer, branchIntervalOperation.inputBuffer1, branchIntervalOperation.inputBuffer2, this.matrices, branchIntervalOperation.inputMatrix1, branchIntervalOperation.inputMatrix2, branchIntervalOperation.accBuffer1, branchIntervalOperation.accBuffer2, this.coalescent, branchIntervalOperation.intervalNumber, this.sizes, 0, this.stateCount);
        }
    }

    @Override
    protected void computeTransitionProbabilityOperations(List<ProcessOnCoalescentIntervalDelegate.TransitionMatrixOperation> list) {
        this.computeInnerTransitionProbabilityOperations(list, 0, list.size(), this.temp);
    }

    protected void computeInnerTransitionProbabilityOperations(List<ProcessOnCoalescentIntervalDelegate.TransitionMatrixOperation> list, int n, int n2, double[] dArray) {
        for (int i = n; i < n2; ++i) {
            ProcessOnCoalescentIntervalDelegate.TransitionMatrixOperation transitionMatrixOperation = list.get(i);
            GenericBastaLikelihoodDelegate.computeTransitionProbabilities(transitionMatrixOperation.time, this.matrices, transitionMatrixOperation.outputBuffer * this.stateCount * this.stateCount, this.decompositions[transitionMatrixOperation.decompositionBuffer], this.stateCount, dArray);
        }
    }

    @Override
    String getStamp() {
        return "generic";
    }

    @Override
    protected double computeCoalescentIntervalReduction(List<Integer> list, List<ProcessOnCoalescentIntervalDelegate.BranchIntervalOperation> list2) {
        int n;
        Arrays.fill(this.e, 0.0);
        Arrays.fill(this.f, 0.0);
        Arrays.fill(this.g, 0.0);
        Arrays.fill(this.h, 0.0);
        for (int i = 0; i < list.size() - 1; ++i) {
            int n2 = list.get(i);
            n = list.get(i + 1);
            for (int j = n2; j < n; ++j) {
                ProcessOnCoalescentIntervalDelegate.BranchIntervalOperation branchIntervalOperation = list2.get(j);
                GenericBastaLikelihoodDelegate.reduceWithinInterval(this.e, this.f, this.g, this.h, this.partials, branchIntervalOperation.inputBuffer1, branchIntervalOperation.inputBuffer2, branchIntervalOperation.accBuffer1, branchIntervalOperation.accBuffer2, branchIntervalOperation.intervalNumber, this.stateCount);
            }
        }
        double d = 0.0;
        for (n = 0; n < list.size() - 1; ++n) {
            ProcessOnCoalescentIntervalDelegate.BranchIntervalOperation branchIntervalOperation = list2.get(list.get(n));
            d += GenericBastaLikelihoodDelegate.reduceAcrossIntervals(this.e, this.f, this.g, this.h, branchIntervalOperation.intervalNumber, branchIntervalOperation.intervalLength, this.sizes, this.coalescent, this.stateCount);
        }
        return d;
    }

    @Override
    protected void computeBranchIntervalOperationsGrad(List<Integer> list, List<ProcessOnCoalescentIntervalDelegate.TransitionMatrixOperation> list2, List<ProcessOnCoalescentIntervalDelegate.BranchIntervalOperation> list3) {
        for (int i = 0; i < list.size() - 1; ++i) {
            int n = list.get(i);
            int n2 = list.get(i + 1);
            this.computeInnerBranchIntervalOperationsGrad(list3, list2, n, n2);
        }
    }

    protected void computeInnerBranchIntervalOperationsGrad(List<ProcessOnCoalescentIntervalDelegate.BranchIntervalOperation> list, List<ProcessOnCoalescentIntervalDelegate.TransitionMatrixOperation> list2, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            ProcessOnCoalescentIntervalDelegate.BranchIntervalOperation branchIntervalOperation = list.get(i);
            ProcessOnCoalescentIntervalDelegate.TransitionMatrixOperation transitionMatrixOperation = list2.get(branchIntervalOperation.intervalNumber);
            this.peelPartialsGrad(this.partials, transitionMatrixOperation.time, branchIntervalOperation.outputBuffer, branchIntervalOperation.inputBuffer1, branchIntervalOperation.inputBuffer2, this.matrices, branchIntervalOperation.inputMatrix1, branchIntervalOperation.inputMatrix2, branchIntervalOperation.accBuffer1, branchIntervalOperation.accBuffer2, this.coalescent, branchIntervalOperation.intervalNumber, this.sizes, 0, this.stateCount);
        }
    }

    private void peelPartialsGrad(double[] dArray, double d, int n, int n2, int n3, double[] dArray2, int n4, int n5, int n6, int n7, double[] dArray3, int n8, double[] dArray4, int n9, int n10) {
        int n11;
        int n12;
        n *= n10;
        n2 *= n10;
        n4 *= n10 * n10;
        n6 *= n10;
        for (n12 = 0; n12 < n10; ++n12) {
            for (n11 = 0; n11 < n10; ++n11) {
                int n13;
                int n14 = 0;
                if (n14 >= n10) continue;
                double d2 = 0.0;
                if (this.transpose && n14 == n11) {
                    d2 += dArray[n6 + n12] * d;
                }
                if (!this.transpose) {
                    for (n13 = 0; n13 < n10; ++n13) {
                        d2 += this.matricesGrad[n12][n11][n4 + n14 * n10 + n13] * dArray[n2 + n13];
                    }
                }
                for (n13 = 0; n13 < n10; ++n13) {
                    d2 += dArray2[n4 + n14 * n10 + n13] * this.partialsGrad[n12][n11][n2 + n13];
                }
                this.partialsGrad[n12][n11][n + n14] = d2;
                throw new RuntimeException("Function should not depend on `transpose`");
            }
        }
        for (n12 = 0; n12 < n10; ++n12) {
            for (n11 = 0; n11 < n10; ++n11) {
                double d3 = 0.0;
                for (int i = 0; i < n10; ++i) {
                    d3 += dArray2[n4 + n11 * n10 + i] * this.partialsGradPopSize[n12][n2 + i];
                }
                this.partialsGradPopSize[n12][n + n11] = d3;
            }
        }
        if (n3 >= 0) {
            n3 *= n10;
            n5 *= n10 * n10;
            n7 *= n10;
            n9 *= n9 * n10;
            for (n12 = 0; n12 < n10; ++n12) {
                for (n11 = 0; n11 < n10; ++n11) {
                    double d4;
                    double d5 = dArray3[n8];
                    double d6 = 0.0;
                    int n15 = 0;
                    if (n15 < n10) {
                        int n16;
                        d4 = 0.0;
                        if (this.transpose && n15 == n11) {
                            d4 += dArray[n7 + n12] * d;
                        }
                        if (!this.transpose) {
                            for (n16 = 0; n16 < n10; ++n16) {
                                d4 += this.matricesGrad[n12][n11][n5 + n15 * n10 + n16] * dArray[n3 + n16];
                            }
                        }
                        for (n16 = 0; n16 < n10; ++n16) {
                            d4 += dArray2[n5 + n15 * n10 + n16] * this.partialsGrad[n12][n11][n3 + n16];
                        }
                        double d7 = this.partialsGrad[n12][n11][n + n15];
                        double d8 = dArray[n6 + n15];
                        double d9 = dArray[n7 + n15];
                        double d10 = (d7 * d9 + d4 * d8) / dArray4[n9 + n15];
                        d6 += d10;
                        this.partialsGrad[n12][n11][n + n15] = d10 / d5;
                        this.partialsGrad[n12][n11][n6 + n15] = d7;
                        this.partialsGrad[n12][n11][n7 + n15] = d4;
                        throw new RuntimeException("Function should not depend on `transpose`");
                    }
                    for (n15 = 0; n15 < n10; ++n15) {
                        d4 = dArray[n + n15];
                        double[] dArray5 = this.partialsGrad[n12][n11];
                        int n17 = n + n15;
                        dArray5[n17] = dArray5[n17] - d6 * d4 / d5;
                    }
                    this.coalescentGrad[n12][n11][n8] = d6;
                }
            }
            for (n12 = 0; n12 < n10; ++n12) {
                int n18;
                double d11 = dArray3[n8];
                double d12 = 0.0;
                for (n18 = 0; n18 < n10; ++n18) {
                    double d13 = 0.0;
                    for (int i = 0; i < n10; ++i) {
                        d13 += dArray2[n5 + n18 * n10 + i] * this.partialsGradPopSize[n12][n3 + i];
                    }
                    double d14 = this.partialsGradPopSize[n12][n + n18];
                    double d15 = dArray[n6 + n18];
                    double d16 = dArray[n7 + n18];
                    double d17 = (d14 * d16 + d13 * d15) / dArray4[n9 + n18];
                    if (n18 == n12) {
                        d17 += d15 * d16;
                    }
                    d12 += d17;
                    this.partialsGradPopSize[n12][n + n18] = d17 / d11;
                    this.partialsGradPopSize[n12][n6 + n18] = d14;
                    this.partialsGradPopSize[n12][n7 + n18] = d13;
                }
                for (n18 = 0; n18 < n10; ++n18) {
                    double d18 = dArray[n + n18];
                    double[] dArray6 = this.partialsGradPopSize[n12];
                    int n19 = n + n18;
                    dArray6[n19] = dArray6[n19] - d12 * d18 / d11;
                }
                this.coalescentGradPopSize[n12][n8] = d12;
            }
        }
    }

    @Override
    protected void computeTransitionProbabilityOperationsGrad(List<ProcessOnCoalescentIntervalDelegate.TransitionMatrixOperation> list) {
        this.computeInnerTransitionProbabilityOperationsGrad(list, 0, list.size());
    }

    protected void computeInnerTransitionProbabilityOperationsGrad(List<ProcessOnCoalescentIntervalDelegate.TransitionMatrixOperation> list, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            ProcessOnCoalescentIntervalDelegate.TransitionMatrixOperation transitionMatrixOperation = list.get(i);
            this.computeTransitionProbabilitiesGrad(transitionMatrixOperation.time, transitionMatrixOperation.outputBuffer * this.stateCount * this.stateCount);
        }
    }

    private void computeTransitionProbabilitiesGrad(double d, int n) {
        for (int i = 0; i < this.stateCount; ++i) {
            for (int j = 0; j < this.stateCount; ++j) {
                for (int k = 0; k < this.stateCount; ++k) {
                    for (int i2 = 0; i2 < this.stateCount; ++i2) {
                        if (i2 == j) {
                            this.matricesGrad[i][j][n + k * this.stateCount + j] = d * this.matrices[n + k * this.stateCount + i];
                            continue;
                        }
                        this.matricesGrad[i][j][n + k * this.stateCount + i2] = 0.0;
                    }
                }
            }
        }
    }

    @Override
    protected double[][] computeCoalescentIntervalReductionGrad(List<Integer> list, List<ProcessOnCoalescentIntervalDelegate.BranchIntervalOperation> list2) {
        int n;
        for (int i = 0; i < list.size() - 1; ++i) {
            n = list.get(i);
            int n2 = list.get(i + 1);
            for (int j = n; j < n2; ++j) {
                ProcessOnCoalescentIntervalDelegate.BranchIntervalOperation branchIntervalOperation = list2.get(j);
                this.reduceWithinIntervalGrad(this.partials, this.partialsGrad, branchIntervalOperation.inputBuffer1, branchIntervalOperation.inputBuffer2, branchIntervalOperation.accBuffer1, branchIntervalOperation.accBuffer2, branchIntervalOperation.intervalNumber, this.stateCount);
            }
        }
        double[][] dArray = new double[this.stateCount][this.stateCount];
        for (n = 0; n < list.size() - 1; ++n) {
            ProcessOnCoalescentIntervalDelegate.BranchIntervalOperation branchIntervalOperation = list2.get(list.get(n));
            double[][] dArray2 = this.reduceAcrossIntervalsGrad(this.e, this.f, this.g, this.h, branchIntervalOperation.intervalNumber, branchIntervalOperation.intervalLength, this.sizes, this.coalescent, this.stateCount);
            for (int i = 0; i < this.stateCount; ++i) {
                for (int j = 0; j < this.stateCount; ++j) {
                    double[] dArray3 = dArray[i];
                    int n3 = j;
                    dArray3[n3] = dArray3[n3] + dArray2[i][j];
                }
            }
        }
        return dArray;
    }

    @Override
    protected double[] computeCoalescentIntervalReductionGradPopSize(List<Integer> list, List<ProcessOnCoalescentIntervalDelegate.BranchIntervalOperation> list2) {
        int n;
        Arrays.stream(this.eGradPopSize).forEach(dArray -> Arrays.fill(dArray, 0.0));
        Arrays.stream(this.fGradPopSize).forEach(dArray -> Arrays.fill(dArray, 0.0));
        Arrays.stream(this.gGradPopSize).forEach(dArray -> Arrays.fill(dArray, 0.0));
        Arrays.stream(this.hGradPopSize).forEach(dArray -> Arrays.fill(dArray, 0.0));
        for (int i = 0; i < list.size() - 1; ++i) {
            n = list.get(i);
            int n2 = list.get(i + 1);
            for (int j = n; j < n2; ++j) {
                ProcessOnCoalescentIntervalDelegate.BranchIntervalOperation branchIntervalOperation = list2.get(j);
                this.reduceWithinIntervalGrad(this.partials, this.partialsGrad, branchIntervalOperation.inputBuffer1, branchIntervalOperation.inputBuffer2, branchIntervalOperation.accBuffer1, branchIntervalOperation.accBuffer2, branchIntervalOperation.intervalNumber, this.stateCount);
            }
        }
        double[] dArray2 = new double[this.stateCount];
        for (n = 0; n < list.size() - 1; ++n) {
            ProcessOnCoalescentIntervalDelegate.BranchIntervalOperation branchIntervalOperation = list2.get(list.get(n));
            double[] dArray3 = this.reduceAcrossIntervalsGradPopSize(this.e, this.f, this.g, this.h, branchIntervalOperation.intervalNumber, branchIntervalOperation.intervalLength, this.sizes, this.coalescent, this.stateCount);
            for (int i = 0; i < this.stateCount; ++i) {
                int n3 = i;
                dArray2[n3] = dArray2[n3] + dArray3[i];
            }
        }
        return dArray2;
    }

    private double[][] reduceAcrossIntervalsGrad(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int n, double d, double[] dArray5, double[] dArray6, int n2) {
        int n3 = n * n2;
        double[][] dArray7 = new double[n2][n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d2 = 0.0;
                for (int k = 0; k < n2; ++k) {
                    d2 += (2.0 * dArray[n3 + k] * this.eGrad[i][j][n3 + k] - this.fGrad[i][j][n3 + k] + 2.0 * dArray3[n3 + k] * this.gGrad[i][j][n3 + k] - this.hGrad[i][j][n3 + k]) / dArray5[k];
                }
                dArray7[i][j] = -d * d2 / 4.0;
                double d3 = dArray6[n];
                if (d3 == 0.0) continue;
                double[] dArray8 = dArray7[i];
                int n4 = j;
                dArray8[n4] = dArray8[n4] + this.coalescentGrad[i][j][n] / d3;
            }
        }
        return dArray7;
    }

    private double[] reduceAcrossIntervalsGradPopSize(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int n, double d, double[] dArray5, double[] dArray6, int n2) {
        int n3 = n * n2;
        double[] dArray7 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < n2; ++j) {
                d2 += (2.0 * dArray[n3 + j] * this.eGradPopSize[i][n3 + j] - this.fGradPopSize[i][n3 + j] + 2.0 * dArray3[n3 + j] * this.gGradPopSize[i][n3 + j] - this.hGradPopSize[i][n3 + j]) / dArray5[j];
                if (j != i) continue;
                d2 += dArray[n3 + j] * dArray[n3 + j] - dArray2[n3 + j] + dArray3[n3 + j] * dArray3[n3 + j] - dArray4[n3 + j];
            }
            dArray7[i] = -d * d2 / 4.0;
            double d3 = dArray6[n];
            if (d3 == 0.0) continue;
            int n4 = i;
            dArray7[n4] = dArray7[n4] + this.coalescentGradPopSize[i][n] / d3;
        }
        return dArray7;
    }

    private void reduceWithinIntervalGrad(double[] dArray, double[][][] dArray2, int n, int n2, int n3, int n4, int n5, int n6) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        int n7;
        int n8;
        n5 *= n6;
        n *= n6;
        n3 *= n6;
        for (n8 = 0; n8 < n6; ++n8) {
            for (n7 = 0; n7 < n6; ++n7) {
                for (int i = 0; i < n6; ++i) {
                    d7 = dArray2[n8][n7][n + i];
                    d6 = dArray[n + i];
                    double[] dArray3 = this.eGrad[n8][n7];
                    int n9 = n5 + i;
                    dArray3[n9] = dArray3[n9] + d7;
                    double[] dArray4 = this.fGrad[n8][n7];
                    int n10 = n5 + i;
                    dArray4[n10] = dArray4[n10] + 2.0 * d6 * d7;
                    d5 = dArray2[n8][n7][n3 + i];
                    d4 = dArray[n3 + i];
                    double[] dArray5 = this.gGrad[n8][n7];
                    int n11 = n5 + i;
                    dArray5[n11] = dArray5[n11] + d5;
                    double[] dArray6 = this.hGrad[n8][n7];
                    int n12 = n5 + i;
                    dArray6[n12] = dArray6[n12] + 2.0 * d4 * d5;
                }
            }
        }
        for (n8 = 0; n8 < n6; ++n8) {
            for (n7 = 0; n7 < n6; ++n7) {
                double d8 = this.partialsGradPopSize[n8][n + n7];
                d3 = dArray[n + n7];
                double[] dArray7 = this.eGradPopSize[n8];
                int n13 = n5 + n7;
                dArray7[n13] = dArray7[n13] + d8;
                double[] dArray8 = this.fGradPopSize[n8];
                int n14 = n5 + n7;
                dArray8[n14] = dArray8[n14] + 2.0 * d3 * d8;
                d2 = this.partialsGradPopSize[n8][n3 + n7];
                d = dArray[n3 + n7];
                double[] dArray9 = this.gGradPopSize[n8];
                int n15 = n5 + n7;
                dArray9[n15] = dArray9[n15] + d2;
                double[] dArray10 = this.hGradPopSize[n8];
                int n16 = n5 + n7;
                dArray10[n16] = dArray10[n16] + 2.0 * d * d2;
            }
        }
        if (n2 >= 0) {
            n2 *= n6;
            n4 *= n6;
            for (n8 = 0; n8 < n6; ++n8) {
                for (n7 = 0; n7 < n6; ++n7) {
                    for (int i = 0; i < n6; ++i) {
                        d7 = dArray2[n8][n7][n2 + i];
                        d6 = dArray[n2 + i];
                        double[] dArray11 = this.eGrad[n8][n7];
                        int n17 = n5 + i;
                        dArray11[n17] = dArray11[n17] + d7;
                        double[] dArray12 = this.fGrad[n8][n7];
                        int n18 = n5 + i;
                        dArray12[n18] = dArray12[n18] + 2.0 * d6 * d7;
                        d5 = dArray2[n8][n7][n4 + i];
                        d4 = dArray[n4 + i];
                        double[] dArray13 = this.gGrad[n8][n7];
                        int n19 = n5 + i;
                        dArray13[n19] = dArray13[n19] + d5;
                        double[] dArray14 = this.hGrad[n8][n7];
                        int n20 = n5 + i;
                        dArray14[n20] = dArray14[n20] + 2.0 * d4 * d5;
                    }
                }
            }
            for (n8 = 0; n8 < n6; ++n8) {
                for (n7 = 0; n7 < n6; ++n7) {
                    double d9 = this.partialsGradPopSize[n8][n2 + n7];
                    d3 = dArray[n2 + n7];
                    double[] dArray15 = this.eGradPopSize[n8];
                    int n21 = n5 + n7;
                    dArray15[n21] = dArray15[n21] + d9;
                    double[] dArray16 = this.fGradPopSize[n8];
                    int n22 = n5 + n7;
                    dArray16[n22] = dArray16[n22] + 2.0 * d3 * d9;
                    d2 = this.partialsGradPopSize[n8][n4 + n7];
                    d = dArray[n4 + n7];
                    double[] dArray17 = this.gGradPopSize[n8];
                    int n23 = n5 + n7;
                    dArray17[n23] = dArray17[n23] + d2;
                    double[] dArray18 = this.hGradPopSize[n8];
                    int n24 = n5 + n7;
                    dArray18[n24] = dArray18[n24] + 2.0 * d * d2;
                }
            }
        }
    }

    @Override
    public void setPartials(int n, double[] dArray) {
        assert (dArray.length == this.stateCount);
        System.arraycopy(dArray, 0, this.partials, n * this.stateCount, this.stateCount);
    }

    @Override
    public void updateEigenDecomposition(int n, EigenDecomposition eigenDecomposition, boolean bl) {
        if (this.transpose) {
            eigenDecomposition = eigenDecomposition.transpose();
        }
        this.decompositions[n] = eigenDecomposition;
    }

    @Override
    public void updatePopulationSizes(int n, double[] dArray, boolean bl) {
        assert (dArray.length == this.stateCount);
        System.arraycopy(dArray, 0, this.sizes, n * this.stateCount, this.stateCount);
    }

    private static void peelPartials(double[] dArray, int n, int n2, int n3, double[] dArray2, int n4, int n5, int n6, int n7, double[] dArray3, int n8, double[] dArray4, int n9, int n10) {
        n *= n10;
        n2 *= n10;
        n4 *= n10 * n10;
        for (int i = 0; i < n10; ++i) {
            double d = 0.0;
            for (int j = 0; j < n10; ++j) {
                d += dArray2[n4 + i * n10 + j] * dArray[n2 + j];
            }
            dArray[n + i] = d;
        }
        if (n3 >= 0) {
            int n11;
            n3 *= n10;
            n5 *= n10 * n10;
            n6 *= n10;
            n7 *= n10;
            n9 *= n9 * n10;
            double d = 0.0;
            for (n11 = 0; n11 < n10; ++n11) {
                double d2;
                double d3 = 0.0;
                for (int i = 0; i < n10; ++i) {
                    d3 += dArray2[n5 + n11 * n10 + i] * dArray[n3 + i];
                }
                double d4 = dArray[n + n11];
                dArray[n + n11] = d2 = d4 * d3 / dArray4[n9 + n11];
                dArray[n6 + n11] = d4;
                dArray[n7 + n11] = d3;
                d += d2;
            }
            for (n11 = 0; n11 < n10; ++n11) {
                int n12 = n + n11;
                dArray[n12] = dArray[n12] / d;
            }
            dArray3[n8] = d;
        }
    }

    private static void computeTransitionProbabilities(double d, double[] dArray, int n, EigenDecomposition eigenDecomposition, int n2, double[] dArray2) {
        int n3;
        assert (dArray.length >= n + n2 * n2);
        assert (dArray2.length == n2 * n2);
        boolean bl = eigenDecomposition.getEigenValues().length == n2;
        double[] dArray3 = eigenDecomposition.getEigenVectors();
        double[] dArray4 = eigenDecomposition.getEigenValues();
        double[] dArray5 = eigenDecomposition.getInverseEigenVectors();
        for (n3 = 0; n3 < n2; ++n3) {
            if (bl || dArray4[n2 + n3] == 0.0) {
                double d2 = Math.exp(d * dArray4[n3]);
                for (int i = 0; i < n2; ++i) {
                    dArray2[n3 * n2 + i] = dArray5[n3 * n2 + i] * d2;
                }
                continue;
            }
            int n4 = n3 + 1;
            double d3 = dArray4[n2 + n3];
            double d4 = Math.exp(d * dArray4[n3]);
            double d5 = d4 * Math.cos(d * d3);
            double d6 = d4 * Math.sin(d * d3);
            for (int i = 0; i < n2; ++i) {
                dArray2[n3 * n2 + i] = d5 * dArray5[n3 * n2 + i] + d6 * dArray5[n4 * n2 + i];
                dArray2[n4 * n2 + i] = d5 * dArray5[n4 * n2 + i] - d6 * dArray5[n3 * n2 + i];
            }
            ++n3;
        }
        n3 = n;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d7 = 0.0;
                for (int k = 0; k < n2; ++k) {
                    d7 += dArray3[i * n2 + k] * dArray2[k * n2 + j];
                }
                dArray[n3] = Math.abs(d7);
                ++n3;
            }
        }
    }

    private static double reduceAcrossIntervals(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int n, double d, double[] dArray5, double[] dArray6, int n2) {
        int n3 = n * n2;
        double d2 = 0.0;
        for (int i = 0; i < n2; ++i) {
            d2 += (dArray[n3 + i] * dArray[n3 + i] - dArray2[n3 + i] + dArray3[n3 + i] * dArray3[n3 + i] - dArray4[n3 + i]) / dArray5[i];
        }
        double d3 = -d * d2 / 4.0;
        double d4 = dArray6[n];
        if (d4 != 0.0) {
            d3 += Math.log(d4);
        }
        return d3;
    }

    private static void reduceWithinInterval(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, int n, int n2, int n3, int n4, int n5, int n6) {
        double d;
        double d2;
        int n7;
        n5 *= n6;
        n *= n6;
        n3 *= n6;
        for (n7 = 0; n7 < n6; ++n7) {
            d2 = dArray5[n + n7];
            int n8 = n5 + n7;
            dArray[n8] = dArray[n8] + d2;
            int n9 = n5 + n7;
            dArray2[n9] = dArray2[n9] + d2 * d2;
            d = dArray5[n3 + n7];
            int n10 = n5 + n7;
            dArray3[n10] = dArray3[n10] + d;
            int n11 = n5 + n7;
            dArray4[n11] = dArray4[n11] + d * d;
        }
        if (n2 >= 0) {
            n2 *= n6;
            n4 *= n6;
            for (n7 = 0; n7 < n6; ++n7) {
                d2 = dArray5[n2 + n7];
                int n12 = n5 + n7;
                dArray[n12] = dArray[n12] + d2;
                int n13 = n5 + n7;
                dArray2[n13] = dArray2[n13] + d2 * d2;
                d = dArray5[n4 + n7];
                int n14 = n5 + n7;
                dArray3[n14] = dArray3[n14] + d;
                int n15 = n5 + n7;
                dArray4[n15] = dArray4[n15] + d * d;
            }
        }
    }
}

