/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.bigfasttree.thorney;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.bigfasttree.thorney.ConstrainableTreeOperator;
import dr.evomodel.operators.AbstractTreeOperator;
import dr.evomodel.tree.TreeModel;
import dr.math.MathUtils;
import java.util.ArrayList;
import java.util.List;

public class UniformSubtreePruneRegraft
extends AbstractTreeOperator
implements ConstrainableTreeOperator {
    private final TreeModel tree;
    private static final String UNIFORM_SUBTREE_PRUNE_REGRAFT = "UniformSubtreePruneRegraft";
    private double totalDistanceTraversed = 0.0;
    private static final boolean DEBUG = false;

    public UniformSubtreePruneRegraft(TreeModel treeModel, double d) {
        this.setWeight(d);
        this.tree = treeModel;
    }

    @Override
    public String getOperatorName() {
        return UNIFORM_SUBTREE_PRUNE_REGRAFT;
    }

    @Override
    public double doOperation() {
        return this.doOperation(this.tree);
    }

    @Override
    public double doOperation(TreeModel treeModel) {
        NodeRef nodeRef;
        NodeRef nodeRef2 = treeModel.getRoot();
        while ((nodeRef = treeModel.getNode(MathUtils.nextInt(treeModel.getNodeCount()))) == nodeRef2 || treeModel.getParent(nodeRef) == nodeRef2) {
        }
        NodeRef nodeRef3 = treeModel.getParent(nodeRef);
        NodeRef nodeRef4 = this.getOtherChild(treeModel, nodeRef3, nodeRef);
        NodeRef nodeRef5 = treeModel.getParent(nodeRef3);
        treeModel.beginTreeEdit();
        treeModel.removeChild(nodeRef3, nodeRef4);
        treeModel.removeChild(nodeRef5, nodeRef3);
        treeModel.addChild(nodeRef5, nodeRef4);
        this.totalDistanceTraversed = 0.0;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        ArrayList<NodeRef> arrayList3 = new ArrayList<NodeRef>();
        this.getDistances(treeModel, treeModel.getNodeHeight(nodeRef), treeModel.getRoot(), arrayList, arrayList2, arrayList3);
        double d = MathUtils.nextDouble() * this.totalDistanceTraversed;
        int n = 0;
        double d2 = (Double)arrayList.get(n);
        while (d2 < d) {
            d2 = (Double)arrayList.get(++n);
        }
        NodeRef nodeRef6 = (NodeRef)arrayList3.get(n);
        double d3 = (Double)arrayList2.get(n) + ((Double)arrayList.get(n) - d);
        NodeRef nodeRef7 = treeModel.getParent(nodeRef6);
        if (nodeRef7 == null) {
            treeModel.addChild(nodeRef3, nodeRef6);
            treeModel.setRoot(nodeRef3);
        } else {
            treeModel.removeChild(nodeRef7, nodeRef6);
            treeModel.addChild(nodeRef3, nodeRef6);
            treeModel.addChild(nodeRef7, nodeRef3);
        }
        treeModel.setNodeHeight(nodeRef3, d3);
        treeModel.endTreeEdit();
        if (treeModel.getParent(nodeRef3) != null && d3 > treeModel.getNodeHeight(treeModel.getParent(nodeRef3))) {
            throw new IllegalArgumentException("height error");
        }
        if (d3 < treeModel.getNodeHeight(nodeRef)) {
            throw new IllegalArgumentException("height error: new height above node");
        }
        if (d3 < treeModel.getNodeHeight(this.getOtherChild(treeModel, nodeRef3, nodeRef))) {
            assert (this.getOtherChild(treeModel, nodeRef3, nodeRef) == nodeRef6);
            throw new IllegalArgumentException("height error: new height above destination");
        }
        return 0.0;
    }

    private void getDistances(Tree tree, double d, NodeRef nodeRef, List<Double> list, List<Double> list2, List<NodeRef> list3) {
        boolean bl;
        double d2 = Math.max(tree.getNodeHeight(nodeRef), d);
        if (tree.getParent(nodeRef) == null) {
            this.totalDistanceTraversed += 0.0;
        } else {
            double d3 = tree.getNodeHeight(tree.getParent(nodeRef)) - d2;
            this.totalDistanceTraversed += d3;
        }
        list.add(this.totalDistanceTraversed);
        list3.add(nodeRef);
        list2.add(d2);
        boolean bl2 = bl = tree.getNodeHeight(nodeRef) > d;
        if (bl) {
            for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
                NodeRef nodeRef2 = tree.getChild(nodeRef, i);
                this.getDistances(tree, d, nodeRef2, list, list2, list3);
            }
        }
    }
}

