/*
 * Decompiled with CFR 0.152.
 */
package moa.tasks;

import com.github.javacliparser.FileOption;
import com.github.javacliparser.FlagOption;
import com.github.javacliparser.IntOption;
import moa.clusterers.AbstractClusterer;
import moa.core.ObjectRepository;
import moa.evaluation.preview.LearningCurve;
import moa.gui.BatchCmd;
import moa.options.ClassOption;
import moa.streams.clustering.ClusteringStream;
import moa.tasks.AuxiliarMainTask;
import moa.tasks.TaskMonitor;

public class EvaluateClustering
extends AuxiliarMainTask {
    private static final long serialVersionUID = 1L;
    public ClassOption learnerOption = new ClassOption("learner", 'l', "Clusterer to train.", AbstractClusterer.class, "clustream.Clustream");
    public ClassOption streamOption = new ClassOption("stream", 's', "Stream to learn from.", ClusteringStream.class, "RandomRBFGeneratorEvents");
    public IntOption instanceLimitOption = new IntOption("instanceLimit", 'i', "Maximum number of instances to test/train on  (-1 = no limit).", 100000, -1, Integer.MAX_VALUE);
    public FlagOption generalEvalOption = new FlagOption("General", 'g', "GPrecision, GRecall, Redundancy, numCluster, numClasses");
    public FlagOption f1Option = new FlagOption("F1", 'f', "F1-P, F1-R, Purity.");
    public FlagOption entropyOption = new FlagOption("Entropy", 'e', "GT cross entropy, FC cross entropy, Homogeneity, Completeness, V-Measure, VarInformation.");
    public FlagOption cmmOption = new FlagOption("CMM", 'c', "CMM, CMM Basic, CMM Missed, CMM Misplaced, CMM Noise, CA Seperability, CA Noise, CA Model.");
    public FlagOption ssqOption = new FlagOption("SSQ", 'q', "SSQ.");
    public FlagOption separationOption = new FlagOption("Separation", 'p', "BSS, BSS-GT, BSS-Ratio.");
    public FlagOption silhouetteOption = new FlagOption("Silhouette", 'h', "SilhCoeff.");
    public FlagOption statisticalOption = new FlagOption("Statistical", 't', "van Dongen, Rand statistic.");
    public FileOption dumpFileOption = new FileOption("dumpFile", 'd', "File to append intermediate csv reslts to.", "dumpClustering.csv", "csv", true);

    @Override
    public String getPurposeString() {
        return "Evaluates a clusterer on a stream.";
    }

    @Override
    public Class<?> getTaskResultType() {
        return LearningCurve.class;
    }

    protected void setMeasures(boolean[] measures) {
        this.generalEvalOption.setValue(measures[0]);
        this.f1Option.setValue(measures[1]);
        this.entropyOption.setValue(measures[2]);
        this.cmmOption.setValue(measures[3]);
        this.ssqOption.setValue(measures[4]);
        this.separationOption.setValue(measures[5]);
        this.silhouetteOption.setValue(measures[6]);
        this.statisticalOption.setValue(measures[7]);
    }

    @Override
    protected Object doMainTask(TaskMonitor monitor, ObjectRepository repository) {
        boolean[] measureCollection = new boolean[]{this.generalEvalOption.isSet(), this.f1Option.isSet(), this.entropyOption.isSet(), this.cmmOption.isSet(), this.ssqOption.isSet(), this.separationOption.isSet(), this.silhouetteOption.isSet(), this.statisticalOption.isSet()};
        BatchCmd.runBatch((ClusteringStream)this.getPreparedClassOption(this.streamOption), (AbstractClusterer)this.getPreparedClassOption(this.learnerOption), measureCollection, this.instanceLimitOption.getValue(), this.dumpFileOption.getValue());
        LearningCurve learningCurve = new LearningCurve("EvaluateClustering does not support custom output file (> [filename]).\nCheck out the dump file to see the results (if you haven't specified, dumpClustering.csv by default).");
        return learningCurve;
    }
}

