/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.api.tramo;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import jdplus.toolkit.base.api.design.InterchangeableProcessor;
import jdplus.toolkit.base.api.information.Explorable;
import jdplus.toolkit.base.api.processing.GenericResults;
import jdplus.toolkit.base.api.processing.ProcResults;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.regression.ModellingContext;
import jdplus.tramoseats.base.api.tramo.TramoException;
import jdplus.tramoseats.base.api.tramo.TramoLoader;
import jdplus.tramoseats.base.api.tramo.TramoSpec;
import lombok.Generated;

public final class Tramo {
    private static final TramoLoader.Processor ENGINE = new TramoLoader.Processor();
    private static final AtomicReference<Processor> LEGACYENGINE = new AtomicReference();

    public static void setEngine(Processor algorithm) {
        ENGINE.set(algorithm);
    }

    public static Processor getEngine() {
        return ENGINE.get();
    }

    public static ProcResults process(TsData series, TramoSpec spec, ModellingContext context, List<String> items) {
        return ENGINE.get().process(series, spec, context, items);
    }

    public static void setLegacyEngine(Processor algorithm) {
        LEGACYENGINE.set(algorithm);
    }

    public static Processor getLegacyEngine() {
        return LEGACYENGINE.get();
    }

    public static Explorable processLegacy(TsData series, TramoSpec spec, ModellingContext context, List<String> items) {
        Processor cp = LEGACYENGINE.get();
        if (cp == null) {
            throw new TramoException("No legacy engine");
        }
        return cp.process(series, spec, context, items);
    }

    @Generated
    private Tramo() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @FunctionalInterface
    @InterchangeableProcessor
    public static interface Processor {
        public ProcResults process(TsData var1, TramoSpec var2, ModellingContext var3, List<String> var4);
    }

    public static final class DefProcessor
    implements Processor {
        @Override
        public ProcResults process(TsData series, TramoSpec spec, ModellingContext context, List<String> items) {
            return GenericResults.notImplemented();
        }
    }
}

