/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui;

import com.qarks.util.PreferenceManagerImpl;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.SortedMap;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;

public class CharsetCombo
extends JComboBox {
    public CharsetCombo() {
        Charset charset = Charset.defaultCharset();
        SortedMap<String, Charset> sortedMap = Charset.availableCharsets();
        Iterator<Charset> iterator = sortedMap.values().iterator();
        while (iterator.hasNext()) {
            super.addItem(iterator.next());
        }
        super.setRenderer(new CharsetRenderer());
        String string = PreferenceManagerImpl.getInstance().getProperty("charset.default", charset.name());
        this.select(string);
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                String string = CharsetCombo.this.getSelectedCharset().name();
                PreferenceManagerImpl.getInstance().setProperty("charset.default", string);
                PreferenceManagerImpl.getInstance().flush();
            }
        });
    }

    public Charset getSelectedCharset() {
        return (Charset)super.getSelectedItem();
    }

    public void select(String string) {
        int n = -1;
        for (int i = 0; i < this.getItemCount() && n == -1; ++i) {
            Charset charset = (Charset)this.getItemAt(i);
            if (!charset.name().equalsIgnoreCase(string)) continue;
            n = i;
            this.setSelectedIndex(n);
        }
    }

    private class CharsetRenderer
    extends DefaultListCellRenderer {
        private CharsetRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof Charset) {
                Charset charset = (Charset)object;
                this.setText(charset.displayName());
            }
            return this;
        }
    }
}

