/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.bool.sum;

import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class BoolSumStructure {
    protected final IntDomainVar[] vars;
    protected final AbstractSConstraint<?> cstr;
    public final IStateInt nbz;
    public final IStateInt nbo;
    public final int bGap;
    public final int bValue;

    public BoolSumStructure(IEnvironment environment, AbstractSConstraint<?> cstr, IntDomainVar[] vars, int bValue) {
        this.cstr = cstr;
        for (IntDomainVar var : vars) {
            if (var.hasBooleanDomain()) continue;
            throw new SolverException("BoolSum takes only boolean variables: " + var.pretty());
        }
        this.vars = vars;
        this.bValue = bValue;
        this.bGap = vars.length - bValue;
        this.nbz = environment.makeInt(0);
        this.nbo = environment.makeInt(0);
    }

    public final IntDomainVar[] getBoolVars() {
        return this.vars;
    }

    public final IStateInt getNbZero() {
        return this.nbz;
    }

    public final IStateInt getNbOne() {
        return this.nbo;
    }

    public final int getbGap() {
        return this.bGap;
    }

    public final int getbValue() {
        return this.bValue;
    }

    public final void reset() {
        this.nbz.set(0);
        this.nbo.set(0);
    }

    public final boolean filterLeq() throws ContradictionException {
        if (this.bValue == 0) {
            this.forceAllZero();
            return false;
        }
        return true;
    }

    public final boolean filterGeq() throws ContradictionException {
        if (this.bValue == this.vars.length) {
            this.forceAllOne();
            return false;
        }
        return true;
    }

    public final void putAllZero() throws ContradictionException {
        for (int i = 0; i < this.vars.length; ++i) {
            if (this.vars[i].isInstantiated()) continue;
            this.vars[i].instantiate(0, this.cstr, false);
        }
    }

    public final void forceAllZero() throws ContradictionException {
        for (int i = 0; i < this.vars.length; ++i) {
            this.vars[i].instantiate(0, this.cstr, false);
        }
    }

    public final void putAllOne() throws ContradictionException {
        for (int i = 0; i < this.vars.length; ++i) {
            if (this.vars[i].isInstantiated()) continue;
            this.vars[i].instantiate(1, this.cstr, false);
        }
    }

    public final void forceAllOne() throws ContradictionException {
        for (int i = 0; i < this.vars.length; ++i) {
            this.vars[i].instantiate(1, this.cstr, false);
        }
    }

    public final void addOne() {
        this.nbo.add(1);
    }

    public final void addZero() {
        this.nbz.add(1);
    }

    public void awakeOnEq() throws ContradictionException {
        if (this.nbo.get() > this.bValue || this.nbz.get() > this.bGap) {
            this.cstr.fail();
        } else if (this.nbo.get() == this.bValue) {
            this.putAllZero();
        } else if (this.nbz.get() == this.bGap) {
            this.putAllOne();
        }
    }

    public void awakeOnGeq() throws ContradictionException {
        if (this.nbo.get() >= this.bValue) {
            this.cstr.setEntailed();
        } else if (this.nbz.get() > this.bGap) {
            this.cstr.fail();
        } else if (this.nbz.get() == this.bGap) {
            this.putAllOne();
        }
    }

    public void awakeOnLeq() throws ContradictionException {
        if (this.nbz.get() >= this.bGap) {
            this.cstr.setEntailed();
        } else if (this.nbo.get() > this.bValue) {
            this.cstr.fail();
        } else if (this.nbo.get() == this.bValue) {
            this.putAllZero();
        }
    }

    public void awakeOnNeq() throws ContradictionException {
        if (this.nbo.get() > this.bValue || this.nbz.get() > this.bGap) {
            this.cstr.setEntailed();
        } else if (this.nbo.get() == this.bValue) {
            if (this.nbz.get() == this.bGap - 1) {
                this.putAllOne();
            } else if (this.nbz.get() == this.bGap) {
                this.cstr.fail();
            }
        } else if (this.nbz.get() == this.bGap) {
            if (this.nbo.get() == this.bValue - 1) {
                this.putAllZero();
            } else if (this.nbo.get() == this.bValue) {
                this.cstr.fail();
            }
        }
    }

    public final int computeUbFromScratch() {
        int s = 0;
        for (int i = 0; i < this.vars.length; ++i) {
            s += this.vars[i].getSup();
        }
        return s;
    }

    public final int computeLbFromScratch() {
        int s = 0;
        for (int i = 0; i < this.vars.length; ++i) {
            s += this.vars[i].getInf();
        }
        return s;
    }

    public Boolean isEntailedEq() {
        int lb = this.computeLbFromScratch();
        int ub = this.computeUbFromScratch();
        if (lb > this.bValue || ub < this.bValue) {
            return Boolean.FALSE;
        }
        if (lb == ub && this.bValue == lb) {
            return Boolean.TRUE;
        }
        return null;
    }

    public Boolean isEntailedGeq() {
        if (this.computeLbFromScratch() >= this.bValue) {
            return Boolean.TRUE;
        }
        if (this.computeUbFromScratch() < this.bValue) {
            return Boolean.FALSE;
        }
        return null;
    }

    public Boolean isEntailedLeq() {
        if (this.computeUbFromScratch() <= this.bValue) {
            return Boolean.TRUE;
        }
        if (this.computeLbFromScratch() > this.bValue) {
            return Boolean.FALSE;
        }
        return null;
    }

    public Boolean isEntailedNeq() {
        int lb = this.computeLbFromScratch();
        int ub = this.computeUbFromScratch();
        if (lb > this.bValue || ub < this.bValue) {
            return Boolean.TRUE;
        }
        if (lb == ub && this.bValue == lb) {
            return Boolean.FALSE;
        }
        return null;
    }

    public String pretty(String operator) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.vars.length; ++i) {
            b.append(this.vars[i]).append(" + ");
        }
        b.delete(b.length() - 2, b.length());
        b.append(operator).append(' ').append(this.bValue);
        return b.toString();
    }
}

