## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(enaho)

## -----------------------------------------------------------------------------
dir <- system.file("extdata", package = "enaho")
leido <- leer.inei(encuesta = "ENAHO", modulo = 37, periodos = 2011, tipo = c("t1","t2"), directorio = dir)
leido

## -----------------------------------------------------------------------------
combinar.inei(x = leido, combinarsolocomunes = FALSE)

## -----------------------------------------------------------------------------
leer.inei.web(encuesta = "ENAHO", modulo = 37, periodos = 2011, tipo = c("t1"))

## -----------------------------------------------------------------------------
variablesxperiodo(modulo = 37, periodos = c(2011,2024),directorio = dir,tipo = "t1")

## -----------------------------------------------------------------------------
vars <- c("AÑO","UBIGEO","DOMINIO","ESTRATO","P702","FACTRIM","FACTOR")
leer.inei(modulo = 37, periodos = c(2011,2024),directorio = dir,tipo = "t1",columnas = vars)

## -----------------------------------------------------------------------------
leer.inei(modulo = 37, periodos = c(2011,2024),directorio = dir,tipo = "t1",solocomunes = TRUE)

