/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.syntaxtree;

import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.exprtree.IPrimitive;
import net.sourceforge.jclec.syntaxtree.NonTerminalNode;
import net.sourceforge.jclec.syntaxtree.SyntaxTree;
import net.sourceforge.jclec.syntaxtree.SyntaxTreeIndividual;
import net.sourceforge.jclec.syntaxtree.SyntaxTreeSchema;
import net.sourceforge.jclec.syntaxtree.SyntaxTreeSpecies;
import net.sourceforge.jclec.syntaxtree.TerminalNode;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.builder.EqualsBuilder;

public class SyntaxTreeIndividualSpecies
extends SyntaxTreeSpecies
implements IConfigure {
    private static final long serialVersionUID = -5659464424179862147L;

    public SyntaxTreeIndividualSpecies() {
        this.genotypeSchema = new SyntaxTreeSchema();
    }

    public void setRootSymbol(String rootSymbolName) {
        this.genotypeSchema.setRootSymbol(rootSymbolName);
    }

    public void setTerminals(TerminalNode[] terminals) {
        this.genotypeSchema.setTerminals(terminals);
    }

    public void setNonTerminals(NonTerminalNode[] nonTerminals) {
        this.genotypeSchema.setNonTerminals(nonTerminals);
    }

    public void setMaxDerivSize(int maxDerivSize) {
        this.genotypeSchema.setMaxDerivSize(maxDerivSize);
    }

    public SyntaxTreeIndividual createIndividual() {
        return new SyntaxTreeIndividual();
    }

    @Override
    public SyntaxTreeIndividual createIndividual(SyntaxTree genotype) {
        return new SyntaxTreeIndividual(genotype);
    }

    @Override
    public void configure(Configuration settings) {
        int numberOfTermSymbols = settings.getList("terminal-symbols.symbol.name").size();
        TerminalNode[] terminals = new TerminalNode[numberOfTermSymbols];
        int j = 0;
        while (j < numberOfTermSymbols) {
            TerminalNode termSymbol = new TerminalNode();
            termSymbol.symbol = settings.getString("terminal-symbols.symbol(" + j + ")" + ".name");
            try {
                String termSymbolCodeClassname = settings.getString("terminal-symbols.symbol(" + j + ")" + ".code");
                Class<?> termSymbolCodeClass = Class.forName(termSymbolCodeClassname);
                termSymbol.code = (IPrimitive)termSymbolCodeClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            terminals[j] = termSymbol;
            ++j;
        }
        this.setTerminals(terminals);
        int numberOfNonTermSymbols = settings.getList("non-terminal-symbols.symbol.name").size();
        NonTerminalNode[] nonTermSymbols = new NonTerminalNode[numberOfNonTermSymbols];
        int j2 = 0;
        while (j2 < numberOfNonTermSymbols) {
            NonTerminalNode nonTermSymbol = new NonTerminalNode();
            nonTermSymbol.symbol = settings.getString("non-terminal-symbols.symbol(" + j2 + ")" + ".name");
            nonTermSymbol.production = settings.getList("non-terminal-symbols.symbol(" + j2 + ")" + ".production-rule.element").toArray(new String[0]);
            nonTermSymbols[j2] = nonTermSymbol;
            ++j2;
        }
        this.setNonTerminals(nonTermSymbols);
        String rootSymbol = settings.getString("root-symbol");
        this.setRootSymbol(rootSymbol);
        int maxDerivSize = settings.getInt("max-deriv-size");
        this.setMaxDerivSize(maxDerivSize);
    }

    public boolean equals(Object other) {
        if (other instanceof SyntaxTreeIndividualSpecies) {
            SyntaxTreeIndividualSpecies cother = (SyntaxTreeIndividualSpecies)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.genotypeSchema, cother.genotypeSchema);
            return eb.isEquals();
        }
        return false;
    }
}

