/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Thrift;

import java.io.IOException;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;

public class myDataset {
    public static final int REAL = 0;
    public static final int INTEGER = 1;
    public static final int NOMINAL = 2;
    private double[][] X = null;
    private boolean[][] missing = null;
    private int[] outputInteger = null;
    private double[] outputReal = null;
    private String[] output = null;
    private double[] emax;
    private double[] emin;
    private int nData;
    private int nVars;
    private int nInputs;
    private int nClasses;
    private InstanceSet IS = new InstanceSet();
    private double[] stdev;
    private double[] average;
    private double[] variance;
    private int[] instancesCl;

    public double[][] getX() {
        return this.X;
    }

    public double[] getExample(int pos) {
        return this.X[pos];
    }

    public int[] getOutputAsInteger() {
        int[] output = new int[this.outputInteger.length];
        for (int i = 0; i < this.outputInteger.length; ++i) {
            output[i] = this.outputInteger[i];
        }
        return output;
    }

    public double[] getOutputAsReal() {
        double[] output = new double[this.outputReal.length];
        for (int i = 0; i < this.outputReal.length; ++i) {
            output[i] = this.outputInteger[i];
        }
        return output;
    }

    public String[] getOutputAsString() {
        String[] output = new String[this.output.length];
        for (int i = 0; i < this.output.length; ++i) {
            output[i] = this.output[i];
        }
        return output;
    }

    public String getOutputAsString(int pos) {
        return this.output[pos];
    }

    public int getOutputAsInteger(int pos) {
        return this.outputInteger[pos];
    }

    public double getOutputAsReal(int pos) {
        return this.outputReal[pos];
    }

    public double[] getemax() {
        return this.emax;
    }

    public double[] getemin() {
        return this.emin;
    }

    public double getMax(int variable) {
        return this.emax[variable];
    }

    public double getMin(int variable) {
        return this.emin[variable];
    }

    public int getnData() {
        return this.nData;
    }

    public int getnVars() {
        return this.nVars;
    }

    public int getnInputs() {
        return this.nInputs;
    }

    public int getnClasses() {
        return this.nClasses;
    }

    public boolean isMissing(int i, int j) {
        return this.missing[i][j];
    }

    public void readClassificationSet(String datasetFile, boolean train) throws IOException {
        try {
            int i;
            this.IS.readSet(datasetFile, train);
            this.nData = this.IS.getNumInstances();
            this.nInputs = Attributes.getInputNumAttributes();
            this.nVars = this.nInputs + Attributes.getOutputNumAttributes();
            if (Attributes.getOutputNumAttributes() > 1) {
                System.out.println("This algorithm can not process MIMO datasets");
                System.out.println("All outputs but the first one will be removed");
            }
            boolean noOutputs = false;
            if (Attributes.getOutputNumAttributes() < 1) {
                System.out.println("This algorithm can not process datasets without outputs");
                System.out.println("Zero-valued output generated");
                noOutputs = true;
            }
            this.X = new double[this.nData][this.nInputs];
            this.missing = new boolean[this.nData][this.nInputs];
            this.outputInteger = new int[this.nData];
            this.outputReal = new double[this.nData];
            this.output = new String[this.nData];
            this.emax = new double[this.nInputs];
            this.emin = new double[this.nInputs];
            for (i = 0; i < this.nInputs; ++i) {
                this.emax[i] = Attributes.getAttribute(i).getMaxAttribute();
                this.emin[i] = Attributes.getAttribute(i).getMinAttribute();
            }
            this.nClasses = 0;
            for (i = 0; i < this.nData; ++i) {
                Instance inst = this.IS.getInstance(i);
                for (int j = 0; j < this.nInputs; ++j) {
                    this.X[i][j] = this.IS.getInputNumericValue(i, j);
                    this.missing[i][j] = inst.getInputMissingValues(j);
                    if (!this.missing[i][j]) continue;
                    this.X[i][j] = this.emin[j] - 1.0;
                }
                if (noOutputs) {
                    this.outputInteger[i] = 0;
                    this.output[i] = "";
                } else {
                    this.outputInteger[i] = (int)this.IS.getOutputNumericValue(i, 0);
                    this.output[i] = this.IS.getOutputNominalValue(i, 0);
                }
                if (this.outputInteger[i] <= this.nClasses) continue;
                this.nClasses = this.outputInteger[i];
            }
            ++this.nClasses;
            System.out.println("Number of classes=" + this.nClasses);
        }
        catch (Exception e) {
            System.out.println("DBG: Exception in readSet");
            e.printStackTrace();
        }
        this.computeStatistics();
        this.computeInstancesPerClass();
    }

    public void readRegressionSet(String datasetFile, boolean train) throws IOException {
        try {
            int i;
            this.IS.readSet(datasetFile, train);
            this.nData = this.IS.getNumInstances();
            this.nInputs = Attributes.getInputNumAttributes();
            this.nVars = this.nInputs + Attributes.getOutputNumAttributes();
            if (Attributes.getOutputNumAttributes() > 1) {
                System.out.println("This algorithm can not process MIMO datasets");
                System.out.println("All outputs but the first one will be removed");
                System.exit(1);
            }
            boolean noOutputs = false;
            if (Attributes.getOutputNumAttributes() < 1) {
                System.out.println("This algorithm can not process datasets without outputs");
                System.out.println("Zero-valued output generated");
                noOutputs = true;
                System.exit(1);
            }
            this.X = new double[this.nData][this.nInputs];
            this.missing = new boolean[this.nData][this.nInputs];
            this.outputInteger = new int[this.nData];
            this.outputReal = new double[this.nData];
            this.emax = new double[this.nInputs];
            this.emin = new double[this.nInputs];
            for (i = 0; i < this.nInputs; ++i) {
                this.emax[i] = Attributes.getAttribute(i).getMaxAttribute();
                this.emin[i] = Attributes.getAttribute(i).getMinAttribute();
            }
            this.nClasses = 0;
            for (i = 0; i < this.nData; ++i) {
                Instance inst = this.IS.getInstance(i);
                for (int j = 0; j < this.nInputs; ++j) {
                    this.X[i][j] = this.IS.getInputNumericValue(i, j);
                    this.missing[i][j] = inst.getInputMissingValues(j);
                    if (!this.missing[i][j]) continue;
                    this.X[i][j] = this.emin[j] - 1.0;
                }
                if (noOutputs) {
                    this.outputInteger[i] = 0;
                    this.outputReal[i] = 0;
                    continue;
                }
                this.outputReal[i] = this.IS.getOutputNumericValue(i, 0);
                this.outputInteger[i] = (int)this.outputReal[i];
            }
        }
        catch (Exception e) {
            System.out.println("DBG: Exception in readSet");
            e.printStackTrace();
        }
        this.computeStatistics();
    }

    public String copyHeader() {
        String p = new String("");
        p = "@relation " + Attributes.getRelationName() + "\n";
        p = p + Attributes.getInputAttributesHeader();
        p = p + Attributes.getOutputAttributesHeader();
        p = p + Attributes.getInputHeader() + "\n";
        p = p + Attributes.getOutputHeader() + "\n";
        p = p + "@data\n";
        return p;
    }

    public void normalize() {
        int atts = this.getnInputs();
        double[] maxs = new double[atts];
        for (int j = 0; j < atts; ++j) {
            maxs[j] = 1.0 / (this.emax[j] - this.emin[j]);
        }
        for (int i = 0; i < this.getnData(); ++i) {
            for (int j = 0; j < atts; ++j) {
                if (this.isMissing(i, j)) continue;
                this.X[i][j] = (this.X[i][j] - this.emin[j]) * maxs[j];
            }
        }
    }

    public boolean hasRealAttributes() {
        return Attributes.hasRealAttributes();
    }

    public boolean hasNumericalAttributes() {
        return Attributes.hasIntegerAttributes() || Attributes.hasRealAttributes();
    }

    public boolean hasMissingAttributes() {
        return this.sizeWithoutMissing() < this.getnData();
    }

    public int sizeWithoutMissing() {
        int tam = 0;
        for (int i = 0; i < this.nData; ++i) {
            int j;
            for (j = 1; j < this.nInputs && !this.isMissing(i, j); ++j) {
            }
            if (j != this.nInputs) continue;
            ++tam;
        }
        return tam;
    }

    public int size() {
        return this.nData;
    }

    private void computeStatistics() {
        this.stdev = new double[this.getnVars()];
        this.average = new double[this.getnVars()];
        this.variance = new double[this.getnVars()];
        int i = 0;
        while (i < this.getnInputs()) {
            this.average[i] = 0.0;
            for (int j = 0; j < this.getnData(); ++j) {
                if (this.isMissing(j, i)) continue;
                int n = i;
                this.average[n] = this.average[n] + this.X[j][i];
            }
            int n = i++;
            this.average[n] = this.average[n] / (double)this.getnData();
        }
        this.average[this.average.length - 1] = 0.0;
        for (int j = 0; j < this.outputReal.length; ++j) {
            int n = this.average.length - 1;
            this.average[n] = this.average[n] + this.outputReal[j];
        }
        int n = this.average.length - 1;
        this.average[n] = this.average[n] / (double)this.outputReal.length;
        for (i = 0; i < this.getnInputs(); ++i) {
            double sum = 0.0;
            for (int j = 0; j < this.getnData(); ++j) {
                if (this.isMissing(j, i)) continue;
                sum += (this.X[j][i] - this.average[i]) * (this.X[j][i] - this.average[i]);
            }
            this.variance[i] = sum /= (double)this.getnData();
            this.stdev[i] = Math.sqrt(sum);
        }
        double sum = 0.0;
        for (int j = 0; j < this.outputReal.length; ++j) {
            sum += (this.outputReal[j] - this.average[this.average.length - 1]) * (this.outputReal[j] - this.average[this.average.length - 1]);
        }
        this.variance[this.variance.length - 1] = sum /= (double)this.outputReal.length;
        this.stdev[this.stdev.length - 1] = Math.sqrt(sum);
    }

    public double variance(int position) {
        return this.variance[position];
    }

    public double stdDev(int position) {
        return this.stdev[position];
    }

    public double average(int position) {
        return this.average[position];
    }

    public void computeInstancesPerClass() {
        this.instancesCl = new int[this.nClasses];
        for (int i = 0; i < this.getnData(); ++i) {
            int n = this.outputInteger[i];
            this.instancesCl[n] = this.instancesCl[n] + 1;
        }
    }

    public int numberInstances(int clas) {
        return this.instancesCl[clas];
    }

    public int numberValues(int attribute) {
        return Attributes.getInputAttribute(attribute).getNumNominalValues();
    }

    public String getOutputValue(int intValue) {
        return Attributes.getOutputAttribute(0).getNominalValue(intValue);
    }

    public int getTipo(int variable) {
        int n = Attributes.getAttribute(variable).getType();
        Attributes.getAttribute(0);
        if (n == 1) {
            return 1;
        }
        int n2 = Attributes.getAttribute(variable).getType();
        Attributes.getAttribute(0);
        if (n2 == 2) {
            return 0;
        }
        int n3 = Attributes.getAttribute(variable).getType();
        Attributes.getAttribute(0);
        if (n3 == 0) {
            return 2;
        }
        return 0;
    }

    public double[][] devuelveRangos() {
        double[][] rangos = new double[this.getnVars()][2];
        for (int i = 0; i < this.getnInputs(); ++i) {
            if (Attributes.getInputAttribute(i).getNumNominalValues() > 0) {
                rangos[i][0] = 0.0;
                rangos[i][1] = Attributes.getInputAttribute(i).getNumNominalValues() - 1;
                continue;
            }
            rangos[i][0] = Attributes.getInputAttribute(i).getMinAttribute();
            rangos[i][1] = Attributes.getInputAttribute(i).getMaxAttribute();
        }
        rangos[this.getnVars() - 1][0] = Attributes.getOutputAttribute(0).getMinAttribute();
        rangos[this.getnVars() - 1][1] = Attributes.getOutputAttribute(0).getMaxAttribute();
        return rangos;
    }
}

