/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Individual;

import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Individual.GeneticIndividual;
import keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy.FuzzyAlphaCut;
import keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy.FuzzyNumberTRIANG;
import keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy.FuzzyRegressor;
import keel.Algorithms.Shared.Exceptions.invalidFitness;

public abstract class GeneticIndividualForSymbRegr
extends GeneticIndividual {
    protected static FuzzyAlphaCut[][] Xfuzzy;
    protected static FuzzyAlphaCut[] Yfuzzy;
    protected static double[][] X;
    protected static double[] Y;
    protected static double[] Yo;
    protected FuzzyRegressor m;
    private static double ECM;
    private static final double MAXFIT = 1.0E8;

    public GeneticIndividualForSymbRegr(int tf) {
        super(tf);
    }

    @Override
    public double fitness() throws invalidFitness {
        FuzzyAlphaCut fECM = new FuzzyAlphaCut(new FuzzyNumberTRIANG(0.0, 0.0, 0.0));
        for (int i = 0; i < X.length; ++i) {
            FuzzyAlphaCut obtainedOutput = this.m.output(Xfuzzy[i]);
            FuzzyAlphaCut fERROR = obtainedOutput.subtract(Yfuzzy[i]);
            fECM = fECM.sum(fERROR.sqr());
        }
        fECM = fECM.multiply(1.0 / (double)X.length);
        return fECM.massCentre();
    }

    public void debug_fitness() {
        double ECMT = 0.0;
        for (int i = 0; i < X.length; ++i) {
            FuzzyAlphaCut obtainedOutput = this.m.output(Xfuzzy[i]);
            double y = obtainedOutput.massCentre();
            double error = y - Y[i];
            ECMT += error * error;
        }
        System.out.println(" Error cuadratico medio defuzzificado=" + (ECMT /= (double)X.length));
    }

    @Override
    public void debug() {
        this.g.debug();
        this.m.debug();
    }

    public void asignaejemplos(double[][] pX, double[] pY, double tolerance) {
        X = pX;
        Y = pY;
        Xfuzzy = new FuzzyAlphaCut[pX.length][];
        Yfuzzy = new FuzzyAlphaCut[pY.length];
        for (int i = 0; i < pX.length; ++i) {
            GeneticIndividualForSymbRegr.Xfuzzy[i] = new FuzzyAlphaCut[pX[i].length];
            for (int j = 0; j < X[i].length; ++j) {
                GeneticIndividualForSymbRegr.Xfuzzy[i][j] = new FuzzyAlphaCut(new FuzzyNumberTRIANG(pX[i][j] * (1.0 - tolerance), pX[i][j], pX[i][j] * (1.0 + tolerance)));
            }
            GeneticIndividualForSymbRegr.Yfuzzy[i] = new FuzzyAlphaCut(new FuzzyNumberTRIANG(pY[i], pY[i], pY[i]));
        }
    }

    public double[] getYo() {
        Yo = new double[X.length];
        for (int i = 0; i < X.length; ++i) {
            FuzzyAlphaCut obtainedOutput = this.m.output(Xfuzzy[i]);
            GeneticIndividualForSymbRegr.Yo[i] = obtainedOutput.massCentre();
        }
        return Yo;
    }

    public double MSE() {
        double error = 0.0;
        double sumY = 0.0;
        for (int i = 0; i < X.length; ++i) {
            FuzzyAlphaCut obtainedOutput = this.m.output(Xfuzzy[i]);
            error = Math.abs(Y[i] - obtainedOutput.massCentre());
            sumY += Y[i];
            ECM += error * error;
        }
        return ECM /= (double)X.length;
    }

    static {
        ECM = 0.0;
    }
}

