/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.M5;

import java.io.Serializable;
import keel.Algorithms.Decision_Trees.M5.Impurity;
import keel.Algorithms.Decision_Trees.M5.M5;
import keel.Algorithms.Decision_Trees.M5.M5Instances;

public final class SplitInfo
implements Serializable {
    int number;
    int first;
    int last;
    int position;
    double maxImpurity;
    double leftAve;
    double rightAve;
    int splitAttr;
    double splitValue;

    public SplitInfo(int low, int high, int attr) {
        this.number = high - low + 1;
        this.first = low;
        this.last = high;
        this.position = -1;
        this.maxImpurity = -1.0E20;
        this.splitAttr = attr;
        this.splitValue = 0.0;
    }

    public final SplitInfo copy() {
        SplitInfo s = new SplitInfo(this.first, this.last, -1);
        s.number = this.number;
        s.first = this.first;
        s.last = this.last;
        s.position = this.position;
        s.maxImpurity = this.maxImpurity;
        s.leftAve = this.leftAve;
        s.rightAve = this.rightAve;
        s.splitAttr = this.splitAttr;
        s.splitValue = this.splitValue;
        return s;
    }

    public final void initialize(int low, int high, int attr) {
        this.number = high - low + 1;
        this.first = low;
        this.last = high;
        this.position = -1;
        this.maxImpurity = -1.0E20;
        this.splitAttr = attr;
        this.splitValue = 0.0;
    }

    public final String toString(M5Instances inst) {
        StringBuffer text = new StringBuffer();
        text.append("Print SplitInfo:\n");
        text.append("    Instances:\t\t" + this.number + " (" + this.first + "-" + this.position + "," + (this.position + 1) + "-" + this.last + ")\n");
        text.append("    Maximum Impurity Reduction:\t" + M5.doubleToStringG(this.maxImpurity, 1, 4) + "\n");
        text.append("    Left average:\t" + this.leftAve + "\n");
        text.append("    Right average:\t" + this.rightAve + "\n");
        if (this.maxImpurity > 0.0) {
            text.append("    Splitting function:\t" + inst.attribute(this.splitAttr).name() + " = " + this.splitValue + "\n");
        } else {
            text.append("    Splitting function:\tnull\n");
        }
        return text.toString();
    }

    public final void attrSplit(int attr, M5Instances inst) throws Exception {
        int low = 0;
        int high = inst.numInstances() - 1;
        this.initialize(low, high, attr);
        if (this.number < 4) {
            return;
        }
        int len = high - low + 1 < 5 ? 1 : (high - low + 1) / 5;
        this.position = low;
        int part = low + len - 1;
        Impurity imp = new Impurity(part, attr, inst, 5);
        int count = 0;
        for (int i = low + len; i <= high - len - 1; ++i) {
            imp.incremental(inst.instance(i).classValue(), 1);
            if (M5.eqDouble(inst.instance(i + 1).value(attr), inst.instance(i).value(attr))) continue;
            count = i;
            if (!(imp.impurity > this.maxImpurity)) continue;
            this.maxImpurity = imp.impurity;
            this.splitValue = (inst.instance(i).value(attr) + inst.instance(i + 1).value(attr)) * 0.5;
            this.leftAve = imp.sl / imp.nl;
            this.rightAve = imp.sr / imp.nr;
            this.position = i;
        }
    }
}

