/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.calendars;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.DayOfWeek;
import ec.tstoolkit.timeseries.calendars.DefaultGregorianCalendarProvider;
import ec.tstoolkit.timeseries.calendars.GregorianCalendarManager;
import ec.tstoolkit.timeseries.calendars.IDayInfo;
import ec.tstoolkit.timeseries.calendars.ISpecialDay;
import ec.tstoolkit.timeseries.calendars.NationalCalendar;
import ec.tstoolkit.timeseries.calendars.SpecialDayEvent;
import ec.tstoolkit.timeseries.calendars.TradingDaysType;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class NationalCalendarProvider
extends DefaultGregorianCalendarProvider {
    private NationalCalendar ncal;
    private boolean m_locked;
    public static final double EPS = 1.0E-9;

    public NationalCalendarProvider() {
        this(true, false);
    }

    public NationalCalendarProvider(boolean mean, boolean julian) {
        this.ncal = new NationalCalendar(mean, julian);
    }

    public NationalCalendarProvider(Collection<SpecialDayEvent> sd) {
        this(sd, true, false);
    }

    public NationalCalendarProvider(Collection<SpecialDayEvent> sd, boolean mean, boolean julian) {
        this.ncal = new NationalCalendar(mean, julian);
        for (SpecialDayEvent d : sd) {
            this.ncal.add(d);
        }
    }

    public NationalCalendarProvider(NationalCalendar ncal) {
        this.ncal = ncal.clone();
    }

    public Collection<SpecialDayEvent> events() {
        return this.ncal.elements();
    }

    @Override
    public List<DataBlock> holidays(TradingDaysType dtype, TsDomain domain) {
        switch (dtype) {
            case TradingDays: {
                double[][] h = this.TDHolidays(domain);
                ArrayList<DataBlock> rslt = new ArrayList<DataBlock>();
                for (int i = 0; i < h.length; ++i) {
                    rslt.add(new DataBlock(h[i]));
                }
                return rslt;
            }
            case WorkingDays: {
                double[] h2 = this.WHolidays(domain);
                ArrayList<DataBlock> rslt2 = new ArrayList<DataBlock>();
                rslt2.add(new DataBlock(h2));
                return rslt2;
            }
        }
        return null;
    }

    private double[] WHolidays(TsDomain domain) {
        double[][] tdh = this.holidays(domain);
        double[] wh = new double[domain.getLength()];
        for (int i = 0; i < wh.length; ++i) {
            int sum = 0;
            for (int j = 0; j < 5; ++j) {
                sum = (int)((double)sum + tdh[j][i]);
            }
            double d = sum;
            if (Math.abs(d) < 1.0E-9) {
                d = 0.0;
            }
            wh[i] = d;
        }
        if (this.ncal.getContext().isLongTermMeanCorrection()) {
            int ifreq = domain.getFrequency().intValue();
            for (SpecialDayEvent day : this.ncal.elements()) {
                double[][] cur;
                Day start = day.getStart();
                Day end = day.getEnd();
                TsDomain xdomain = day.day.getSignificantDomain(domain.getFrequency(), start, end);
                TsDomain cdomain = domain.intersection(xdomain);
                if (cdomain.isEmpty() || (cur = day.day.getLongTermMeanEffect(ifreq)) == null) continue;
                int del = cdomain.getStart().minus(domain.getStart());
                for (int p = 0; p < ifreq; ++p) {
                    if (cur[p] == null) continue;
                    int i = p - cdomain.getStart().getPosition();
                    if (i < 0) {
                        i += ifreq;
                    }
                    double m = 0.0;
                    for (int j = 0; j < 5; ++j) {
                        m += cur[p][j];
                    }
                    if (!(Math.abs(m) > 1.0E-9)) continue;
                    while (i < cdomain.getLength()) {
                        int n = i + del;
                        wh[n] = wh[n] - m;
                        i += ifreq;
                    }
                }
            }
        }
        return wh;
    }

    private double[][] TDHolidays(TsDomain domain) {
        double[][] h = this.holidays(domain);
        double[][] tdh = new double[6][];
        for (int i = 0; i < 6; ++i) {
            double[] tmp = new double[domain.getLength()];
            for (int j = 0; j < tmp.length; ++j) {
                tmp[j] = h[i][j];
            }
            tdh[i] = tmp;
        }
        if (this.ncal.getContext().isLongTermMeanCorrection()) {
            int ifreq = domain.getFrequency().intValue();
            for (SpecialDayEvent day : this.ncal.elements()) {
                double[][] cur;
                Day start = day.getStart();
                Day end = day.getEnd();
                TsDomain xdomain = day.day.getSignificantDomain(domain.getFrequency(), start, end);
                TsDomain cdomain = domain.intersection(xdomain);
                if (cdomain.isEmpty() || (cur = day.day.getLongTermMeanEffect(ifreq)) == null) continue;
                int del = cdomain.getStart().minus(domain.getStart());
                for (int p = 0; p < ifreq; ++p) {
                    if (cur[p] == null) continue;
                    int i = p - cdomain.getStart().getPosition();
                    if (i < 0) {
                        i += ifreq;
                    }
                    while (i < cdomain.getLength()) {
                        for (int j = 0; j < 6; ++j) {
                            double[] dArray = tdh[j];
                            int n = i + del;
                            dArray[n] = dArray[n] - cur[p][j];
                        }
                        i += ifreq;
                    }
                }
            }
        }
        return tdh;
    }

    private double[][] holidays(TsDomain domain) {
        double[][] h = new double[6][];
        for (int i = 0; i < 6; ++i) {
            h[i] = new double[domain.getLength()];
        }
        Day dstart = domain.getStart().firstday();
        Day dend = domain.getLast().lastday();
        HashMap<Day, Double> used = new HashMap<Day, Double>();
        for (SpecialDayEvent ev : this.ncal.elements()) {
            Day start = ev.getStart();
            Day end = ev.getEnd();
            if (start.isBefore(dstart)) {
                start = dstart;
            }
            if (end.isAfter(dend)) {
                end = dend;
            }
            if (!start.isBefore(end)) continue;
            for (IDayInfo info : ev.day.getIterable(domain.getFrequency(), start, end)) {
                int pos;
                Day curday = info.getDay();
                Double Weight = (Double)used.get(curday);
                double weight = ev.day.getWeight();
                if (Weight != null && !(weight > Weight)) continue;
                used.put(curday, weight);
                TsPeriod cur = info.getPeriod();
                DayOfWeek w = info.getDayOfWeek();
                if (w == DayOfWeek.Sunday || (pos = domain.search(cur)) < 0) continue;
                int col = -1 + w.intValue();
                double[] dArray = h[col];
                int n = pos;
                dArray[n] = dArray[n] + (Weight == null ? weight : weight - Weight);
            }
        }
        return h;
    }

    @Override
    protected void tradingDays(TsDomain domain, List<DataBlock> buffer) {
        int n = domain.getLength();
        super.tradingDays(domain, buffer);
        double[][] h = this.TDHolidays(domain);
        for (int j = 0; j < n; ++j) {
            int i;
            double s = 0.0;
            for (i = 0; i < h.length; ++i) {
                s -= h[i][j];
            }
            for (i = 0; i < h.length; ++i) {
                double del = s - h[i][j];
                double idel = Math.round(del);
                if (Math.abs(del - idel) < 1.0E-9) {
                    del = idel;
                }
                if (del == 0.0) continue;
                buffer.get(i).add(j, del);
            }
        }
    }

    @Override
    protected void workingDays(TsDomain domain, DataBlock buffer) {
        int n = domain.getLength();
        super.workingDays(domain, buffer);
        double[] h = this.WHolidays(domain);
        for (int i = 0; i < h.length; ++i) {
            if (h[i] == 0.0) continue;
            buffer.add(i, -3.5 * h[i]);
        }
    }

    public boolean isLocked() {
        return this.m_locked;
    }

    public void setLocked() {
        this.m_locked = true;
    }

    public boolean add(ISpecialDay day) {
        if (!this.m_locked) {
            return this.ncal.add(day);
        }
        return false;
    }

    public boolean add(SpecialDayEvent evday) {
        if (!this.m_locked) {
            return this.ncal.add(evday);
        }
        return false;
    }

    public boolean isLongTermMeanCorrection() {
        return this.ncal.getContext().isLongTermMeanCorrection();
    }

    public boolean isJulianEaster() {
        return this.ncal.getContext().isJulianEaster();
    }

    public boolean contentEquals(NationalCalendarProvider other) {
        return this.ncal.contentEquals(other.ncal);
    }

    @Override
    public NationalCalendarProvider withCalendarManager(GregorianCalendarManager manager) {
        return this;
    }
}

