/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf.ucarima;

import ec.tstoolkit.arima.ArimaModel;
import ec.tstoolkit.arima.AutoCovarianceFunction;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.polynomials.RationalFunction;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.arima.SsfArima;
import ec.tstoolkit.ucarima.UcarimaModel;

public final class SsfUcarimaWithMean
implements ISsf {
    private UcarimaModel m_ucm;
    private int m_tr;
    private double m_tvar;
    private double[] m_tdif;
    private double[] m_tphi;
    private double[] m_tacgf;
    private double[] m_tpsi;
    private DataBlock m_tPhi;
    private int m_ncmps;
    private int m_dim;
    private double[][] m_dif;
    private double[][] m_phi;
    private double[][] m_psi;
    private double[][] m_stacgf;
    private double[][] m_stpsi;
    private double[] m_var;
    private int[] m_r;
    private DataBlock[] m_Phi;
    private DataBlock m_ctmp;

    public static ISsf build(UcarimaModel ucm) {
        return new SsfUcarimaWithMean(ucm);
    }

    public SsfUcarimaWithMean() {
    }

    public SsfUcarimaWithMean(UcarimaModel ucm) {
        this.m_ucm = ucm;
        this.initModel();
    }

    public int cmpDim(int cmp) {
        if (cmp >= this.m_ucm.getComponentsCount() || this.m_ucm.getComponent(cmp).isNull()) {
            return 0;
        }
        if (cmp == 0) {
            return this.m_tr;
        }
        int j = 0;
        for (int i = 1; i < cmp; ++i) {
            if (this.m_ucm.getComponent(i).isNull()) continue;
            ++j;
        }
        return this.m_r[j];
    }

    public int cmpPos(int cmp) {
        if (cmp >= this.m_ucm.getComponentsCount() || this.m_ucm.getComponent(cmp).isNull()) {
            return -1;
        }
        if (cmp == 0) {
            return 0;
        }
        int pos = this.m_tr;
        int j = 0;
        for (int i = 1; i < cmp; ++i) {
            if (this.m_ucm.getComponent(i).isNull()) continue;
            pos += this.m_r[j++];
        }
        return pos;
    }

    @Override
    public void diffuseConstraints(SubMatrix b) {
        b.diagonal().range(0, this.m_tdif.length).set(1.0);
        int s = this.m_tr;
        int t = this.m_tdif.length;
        for (int c = 0; c < this.m_ncmps; ++c) {
            int dim = this.m_r[c];
            int d = this.m_dif[c].length - 1;
            if (d > 0) {
                SsfArima.B0(b.extract(s, s + dim, t, t + d), this.m_dif[c]);
                t += d;
            }
            s += dim;
        }
    }

    private int dtot() {
        int nd = this.m_tdif.length;
        for (int i = 0; i < this.m_ncmps; ++i) {
            nd += this.m_dif[i].length - 1;
        }
        return nd;
    }

    @Override
    public void fullQ(int pos, SubMatrix qm) {
        int s;
        if (this.m_tvar != 0.0) {
            int dim = this.m_tpsi.length;
            s = this.m_tdif.length;
            for (int i = 0; i < dim; ++i) {
                for (int j = 0; j <= i; ++j) {
                    qm.set(s + i, s + j, this.m_tpsi[i] * this.m_tpsi[j] * this.m_tvar);
                }
            }
        }
        s = this.m_tr;
        for (int cmp = 0; cmp < this.m_ncmps; ++cmp) {
            int dim = this.m_r[cmp];
            for (int i = 0; i < dim; ++i) {
                for (int j = 0; j <= i; ++j) {
                    qm.set(s + i, s + j, this.m_psi[cmp][i] * this.m_psi[cmp][j] * this.m_var[cmp]);
                }
            }
            s += dim;
        }
        SymmetricMatrix.fromLower(qm);
    }

    @Override
    public int getNonStationaryDim() {
        return this.dtot();
    }

    @Override
    public int getStateDim() {
        return this.m_dim;
    }

    @Override
    public int getTransitionResCount() {
        return this.m_dim - this.m_tdif.length;
    }

    @Override
    public int getTransitionResDim() {
        return this.m_ncmps + 1;
    }

    public UcarimaModel getUCModel() {
        return this.m_ucm;
    }

    public double H(int pos) {
        return 0.0;
    }

    public boolean hasH() {
        return false;
    }

    @Override
    public boolean hasR() {
        return true;
    }

    @Override
    public boolean hasTransitionRes(int pos) {
        return true;
    }

    @Override
    public boolean hasW() {
        return true;
    }

    private void initModel() {
        int i;
        this.m_ncmps = 0;
        this.m_dim = 0;
        this.initTModel();
        for (i = 1; i < this.m_ucm.getComponentsCount(); ++i) {
            if (this.m_ucm.getComponent(i).isNull()) continue;
            ++this.m_ncmps;
        }
        this.m_dif = new double[this.m_ncmps][];
        this.m_phi = new double[this.m_ncmps][];
        this.m_Phi = new DataBlock[this.m_ncmps];
        this.m_psi = new double[this.m_ncmps][];
        this.m_r = new int[this.m_ncmps];
        this.m_stacgf = new double[this.m_ncmps][];
        this.m_stpsi = new double[this.m_ncmps][];
        this.m_var = new double[this.m_ncmps];
        int j = 0;
        for (i = 1; i < this.m_ucm.getComponentsCount(); ++i) {
            if (this.m_ucm.getComponent(i).isNull()) continue;
            this.initModel(j++, i);
        }
        this.m_ctmp = new DataBlock(this.m_dim);
    }

    private void initModel(int i, int cmp) {
        ArimaModel model = this.m_ucm.getComponent(cmp);
        this.m_var[i] = model.getInnovationVariance();
        BackFilter ur = model.getNonStationaryAR();
        this.m_dif[i] = ur.getCoefficients();
        Polynomial phi = model.getAR().getPolynomial();
        this.m_phi[i] = phi.getCoefficients();
        this.m_Phi[i] = new DataBlock(this.m_phi[i], 1, this.m_phi[i].length, 1);
        Polynomial theta = model.getMA().getPolynomial();
        this.m_r[i] = Math.max(phi.getDegree(), theta.getDegree() + 1);
        this.m_dim += this.m_r[i];
        this.m_psi[i] = new RationalFunction(theta, phi).coefficients(this.m_r[i]);
        Polynomial stphi = model.getStationaryAR().getPolynomial();
        this.m_stacgf[i] = new AutoCovarianceFunction(theta, stphi, this.m_var[i]).values(this.m_r[i]);
        this.m_stpsi[i] = new RationalFunction(theta, stphi).coefficients(this.m_r[i]);
    }

    private void initTModel() {
        ArimaModel model = this.m_ucm.getComponent(0);
        this.m_tvar = model.getInnovationVariance();
        BackFilter ur = model.getNonStationaryAR();
        this.m_tdif = ur.getCoefficients();
        if (this.m_tvar != 0.0) {
            Polynomial tphi = model.getStationaryAR().getPolynomial();
            this.m_tphi = tphi.getCoefficients();
            this.m_tPhi = new DataBlock(this.m_tphi, 1, this.m_tphi.length, 1);
            Polynomial theta = model.getMA().getPolynomial();
            int r = Math.max(tphi.getDegree(), theta.getDegree() + 1);
            this.m_tr = r + this.m_tdif.length;
            this.m_dim += this.m_tr;
            this.m_tacgf = new AutoCovarianceFunction(theta, tphi, this.m_tvar).values(r);
            this.m_tpsi = new RationalFunction(theta, tphi).coefficients(r);
        } else {
            this.m_tr = this.m_tdif.length;
            this.m_dim += this.m_tr;
        }
    }

    @Override
    public boolean isDiffuse() {
        return true;
    }

    @Override
    public boolean isMeasurementEquationTimeInvariant() {
        return true;
    }

    @Override
    public boolean isTimeInvariant() {
        return true;
    }

    @Override
    public boolean isTransitionEquationTimeInvariant() {
        return true;
    }

    @Override
    public boolean isTransitionResidualTimeInvariant() {
        return true;
    }

    @Override
    public boolean isValid() {
        return this.m_ucm != null;
    }

    @Override
    public void L(int pos, DataBlock k, SubMatrix lm) {
        this.T(pos, lm);
        lm.column(0).sub(k);
        int ndif = this.m_tdif.length;
        for (int j = 1; j < ndif; ++j) {
            lm.column(j).addAY(this.m_tdif[j], k);
        }
        if (this.m_tvar != 0.0) {
            lm.column(ndif).sub(k);
        }
        int c = this.m_tr;
        for (int cmp = 0; cmp < this.m_ncmps; ++cmp) {
            lm.column(c).sub(k);
            c += this.m_r[cmp];
        }
    }

    @Override
    public void Pf0(SubMatrix pf0) {
        int s;
        if (this.m_tvar != 0.0) {
            int j;
            int dim = this.m_tpsi.length;
            s = this.m_tdif.length;
            for (j = 0; j < dim; ++j) {
                pf0.set(s + j, s, this.m_tacgf[j]);
            }
            for (j = 0; j < dim - 1; ++j) {
                pf0.set(s + j + 1, s + j + 1, pf0.get(s + j, s + j) - this.m_tpsi[j] * this.m_tpsi[j] * this.m_tvar);
                for (int k = 0; k < j; ++k) {
                    pf0.set(s + j + 1, s + k + 1, pf0.get(s + j, s + k) - this.m_tpsi[j] * this.m_tpsi[k] * this.m_tvar);
                }
            }
            SymmetricMatrix.fromLower(pf0.extract(s, s + dim, s, s + dim));
        }
        s = this.m_tr;
        for (int c = 0; c < this.m_ncmps; ++c) {
            int dim = this.m_r[c];
            Matrix stV = new Matrix(dim, dim);
            SsfArima.stVar(stV.subMatrix(), this.m_stpsi[c], this.m_stacgf[c], this.m_var[c]);
            Matrix K = new Matrix(dim, dim);
            SsfArima.Ksi(K.subMatrix(), this.m_dif[c]);
            SymmetricMatrix.quadraticFormT(stV.subMatrix(), K.subMatrix(), pf0.extract(s, s + dim, s, s + dim));
            s += dim;
        }
    }

    @Override
    public void Pi0(SubMatrix pi0) {
        Matrix B = new Matrix(this.m_dim, this.dtot());
        this.diffuseConstraints(B.subMatrix());
        SymmetricMatrix.XXt(B.subMatrix(), pi0);
    }

    @Override
    public void Q(int pos, SubMatrix qm) {
        if (this.m_tvar != 0.0) {
            qm.set(0, 0, this.m_tvar);
            qm.diagonal().drop(1, 0).copyFrom(this.m_var, 0);
        } else {
            qm.diagonal().copyFrom(this.m_var, 0);
        }
    }

    @Override
    public void R(int pos, SubArrayOfInt rv) {
        int start = this.m_tdif.length;
        int n = this.getTransitionResCount();
        for (int i = 0; i < n; ++i) {
            rv.set(i, start + i);
        }
    }

    @Override
    public void T(int pos, SubMatrix tr) {
        int j;
        tr.set(0, 0, 1.0);
        tr.set(1, 0, 1.0);
        int ndif = this.m_tdif.length;
        for (j = 1; j < ndif; ++j) {
            tr.set(1, j, -this.m_tdif[j]);
        }
        for (j = 2; j < ndif; ++j) {
            tr.set(j, j - 1, 1.0);
        }
        if (this.m_tvar != 0.0) {
            int i;
            tr.set(1, ndif, 1.0);
            int n = this.m_tr;
            for (i = ndif + 1; i < n; ++i) {
                tr.set(i - 1, i, 1.0);
            }
            for (i = 1; i < this.m_tphi.length; ++i) {
                tr.set(n - 1, n - i, -this.m_tphi[i]);
            }
        }
        int s = this.m_tr;
        for (int cmp = 0; cmp < this.m_ncmps; ++cmp) {
            int n = this.m_r[cmp];
            int sn = s + n;
            for (int i = 1; i < n; ++i) {
                tr.set(s + i - 1, s + i, 1.0);
            }
            double[] phi = this.m_phi[cmp];
            for (int i = 1; i < phi.length; ++i) {
                tr.set(sn - 1, sn - i, -phi[i]);
            }
            s += n;
        }
    }

    @Override
    public void TVT(int pos, SubMatrix vm) {
        DataBlockIterator cols = vm.columns();
        DataBlock col = cols.getData();
        do {
            this.TX(pos, col);
        } while (cols.next());
        DataBlockIterator rows = vm.rows();
        DataBlock row = rows.getData();
        do {
            this.TX(pos, row);
        } while (rows.next());
    }

    @Override
    public void TX(int pos, DataBlock x) {
        int s;
        int ndif = this.m_tdif.length;
        double x1 = x.get(0);
        for (int j = 1; j < ndif; ++j) {
            x1 -= x.get(j) * this.m_tdif[j];
        }
        if (this.m_tvar != 0.0) {
            x1 += x.get(ndif);
        }
        if (ndif > 2) {
            x.range(1, ndif).fshift(DataBlock.ShiftOption.Zero);
        }
        x.set(1, x1);
        if (this.m_tvar != 0.0) {
            int n = this.m_tpsi.length;
            s = ndif;
            DataBlock xc = x.range(s, s + n);
            double last = this.m_tPhi.dotReverse(xc);
            xc.bshift(DataBlock.ShiftOption.None);
            xc.set(n - 1, -last);
        }
        s = this.m_tr;
        for (int c = 0; c < this.m_ncmps; ++c) {
            int n = this.m_r[c];
            DataBlock xc = x.range(s, s + n);
            double last = this.m_Phi[c].dotReverse(xc);
            xc.bshift(DataBlock.ShiftOption.None);
            xc.set(n - 1, -last);
            s += n;
        }
    }

    @Override
    public void VpZdZ(int pos, SubMatrix vm, double d) {
        int n = this.m_tdif.length;
        for (int r = 0; r < n; ++r) {
            double xr = 1.0;
            if (r > 0) {
                xr = -this.m_tdif[r];
            }
            if (xr == 0.0) continue;
            xr *= d;
            for (int c = 0; c <= r; ++c) {
                double xc = 1.0;
                if (c > 0) {
                    xc = -this.m_tdif[c];
                }
                if (xc == 0.0) continue;
                double x = xr * xc;
                vm.add(r, c, x);
                if (r == c) continue;
                vm.add(c, r, x);
            }
            if (this.m_tvar == 0.0) continue;
            vm.add(r, n, xr);
            vm.add(n, r, xr);
        }
        if (this.m_tvar != 0.0) {
            vm.add(n, n, d);
        }
        int c = this.m_tr;
        for (int ccmp = 0; ccmp < this.m_ncmps; ++ccmp) {
            for (int r = 0; r < n; ++r) {
                double xr = 1.0;
                if (r > 0) {
                    xr = -this.m_tdif[r];
                }
                if (xr == 0.0) continue;
                vm.add(r, c, xr *= d);
                vm.add(c, r, xr);
            }
            if (this.m_tvar != 0.0) {
                vm.add(n, c, d);
                vm.add(c, n, d);
            }
            c += this.m_r[ccmp];
        }
        int r = this.m_tr;
        for (int rcmp = 0; rcmp < this.m_ncmps; ++rcmp) {
            int c2 = this.m_tr;
            for (int ccmp = 0; ccmp <= rcmp; ++ccmp) {
                vm.add(r, c2, d);
                if (r != c2) {
                    vm.add(c2, r, d);
                }
                c2 += this.m_r[ccmp];
            }
            r += this.m_r[rcmp];
        }
    }

    @Override
    public void W(int pos, SubMatrix wv) {
        int istart = 0;
        int jstart = 0;
        if (this.m_tvar != 0.0) {
            int n = this.m_tpsi.length;
            wv.column(0).range(0, n).copyFrom(this.m_tpsi, 0);
            istart = 1;
            jstart = n;
        }
        int j = jstart;
        for (int i = 0; i < this.m_ncmps; ++i) {
            int n = this.m_r[i];
            wv.column(i + istart).range(j, j + n).copyFrom(this.m_psi[i], 0);
            j += n;
        }
    }

    @Override
    public void XpZd(int pos, DataBlock x, double d) {
        x.add(0, d);
        int ndif = this.m_tdif.length;
        for (int j = 1; j < ndif; ++j) {
            x.add(j, -d * this.m_tdif[j]);
        }
        if (this.m_tvar != 0.0) {
            x.add(ndif, d);
        }
        int s = this.m_tr;
        for (int cmp = 0; cmp < this.m_ncmps; ++cmp) {
            x.add(s, d);
            s += this.m_r[cmp];
        }
    }

    @Override
    public void XT(int pos, DataBlock x) {
        double x1 = x.get(1);
        x.add(0, x1);
        int ndif = this.m_tdif.length;
        for (int i = 1; i < ndif - 1; ++i) {
            x.set(i, x.get(i + 1) - this.m_tdif[i] * x1);
        }
        x.set(ndif - 1, -this.m_tdif[ndif - 1] * x1);
        if (this.m_tvar != 0.0) {
            int n = this.m_tpsi.length;
            DataBlock xc = x.range(ndif, ndif + n);
            double last = -xc.get(n - 1);
            xc.fshift(DataBlock.ShiftOption.None);
            xc.set(0, 0.0);
            if (last != 0.0) {
                for (int i = 1; i < this.m_tphi.length; ++i) {
                    if (this.m_tphi[i] == 0.0) continue;
                    xc.add(n - i, last * this.m_tphi[i]);
                }
            }
            xc.add(0, x1);
        }
        int s = this.m_tr;
        for (int c = 0; c < this.m_ncmps; ++c) {
            int n = this.m_r[c];
            DataBlock xc = x.range(s, s + n);
            double last = -xc.get(n - 1);
            xc.fshift(DataBlock.ShiftOption.None);
            xc.set(0, 0.0);
            if (last != 0.0) {
                for (int i = 1; i < this.m_phi[c].length; ++i) {
                    if (this.m_phi[c][i] == 0.0) continue;
                    xc.add(n - i, last * this.m_phi[c][i]);
                }
            }
            s += n;
        }
    }

    @Override
    public void Z(int pos, DataBlock x) {
        x.set(0, 1.0);
        int ndif = this.m_tdif.length;
        for (int j = 1; j < ndif; ++j) {
            x.set(j, -this.m_tdif[j]);
        }
        if (this.m_tvar != 0.0) {
            x.set(ndif, 1.0);
        }
        int s = this.m_tr;
        for (int cmp = 0; cmp < this.m_ncmps; ++cmp) {
            x.set(s, 1.0);
            s += this.m_r[cmp];
        }
    }

    @Override
    public void ZM(int pos, SubMatrix m, DataBlock x) {
        x.copy(m.row(0));
        int ndif = this.m_tdif.length;
        for (int j = 1; j < ndif; ++j) {
            x.addAY(-this.m_tdif[j], m.row(j));
        }
        if (this.m_tvar != 0.0) {
            x.add(m.row(ndif));
        }
        int c = this.m_tr;
        for (int i = 0; i < this.m_ncmps; ++i) {
            x.add(m.row(c));
            c += this.m_r[i];
        }
    }

    @Override
    public double ZVZ(int pos, SubMatrix vm) {
        this.ZM(pos, vm, this.m_ctmp);
        return this.ZX(pos, this.m_ctmp);
    }

    @Override
    public double ZX(int pos, DataBlock x) {
        double r = x.get(0);
        int ndif = this.m_tdif.length;
        for (int j = 1; j < ndif; ++j) {
            r -= x.get(j) * this.m_tdif[j];
        }
        if (this.m_tvar != 0.0) {
            r += x.get(ndif);
        }
        int c = this.m_tr;
        for (int i = 0; i < this.m_ncmps; ++i) {
            r += x.get(c);
            c += this.m_r[i];
        }
        return r;
    }
}

