/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.algorithm;

import ec.tstoolkit.algorithm.AlgorithmDescriptor;
import ec.tstoolkit.algorithm.IAlgorithmManager;
import ec.tstoolkit.algorithm.IDiagnostics;
import ec.tstoolkit.algorithm.IDiagnosticsFactory;
import ec.tstoolkit.algorithm.IOutputFactory;
import ec.tstoolkit.algorithm.IProcDocument;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.algorithm.IProcessing;
import ec.tstoolkit.algorithm.IProcessingFactory;
import ec.tstoolkit.algorithm.ProcDiagnostic;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.design.InterfaceLoader;
import ec.tstoolkit.information.Information;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class AlgorithmManager<S extends IProcSpecification, I, R extends IProcResults, D extends IProcDocument<? extends S, ?, ? extends R>, P extends IProcessingFactory<? extends S, I, R>, O extends IOutputFactory<? extends D>, T extends IDiagnosticsFactory<R>>
implements IAlgorithmManager<S, I, R, P> {
    private final List<P> processors_ = new CopyOnWriteArrayList<P>();
    private final List<O> output_ = new CopyOnWriteArrayList<O>();
    private final List<T> tests_ = new CopyOnWriteArrayList<T>();

    public static InformationSet getActiveContext() {
        return null;
    }

    public InformationSet diagnostic(R sa) {
        InformationSet summary = new InformationSet();
        for (IDiagnosticsFactory diag : this.tests_) {
            boolean isHalfYearly;
            TsData y = sa.getData("y", TsData.class);
            boolean bl = isHalfYearly = y != null && y.getFrequency().intValue() == 2;
            if (!diag.isEnabled() || diag.getName().equals("M-Statistics") && isHalfYearly || diag.getName().equals("Regarima residuals") && isHalfYearly) continue;
            summary.add(this.create(diag, sa));
        }
        return summary;
    }

    private Information<InformationSet> create(IDiagnosticsFactory<R> dfac, R sa) {
        if (sa == null) {
            return null;
        }
        IDiagnostics diags = dfac.create(sa);
        if (diags == null) {
            return null;
        }
        InformationSet set = new InformationSet();
        for (String test : diags.getTests()) {
            double val = diags.getValue(test);
            ProcDiagnostic item = new ProcDiagnostic(val, diags.getDiagnostic(test));
            set.set(test.toLowerCase(), item);
        }
        List<String> warnings = diags.getWarnings();
        if (warnings != null) {
            for (String w : warnings) {
                set.addWarning(w);
            }
        }
        return new Information<InformationSet>(diags.getName().toLowerCase(), set);
    }

    public void sortProcessors(Comparator<P> cmp) {
        Collections.sort(this.processors_, cmp);
    }

    public void sortOutput(Comparator<O> cmp) {
        Collections.sort(this.output_, cmp);
    }

    public void sortDiagnostics(Comparator<T> cmp) {
        Collections.sort(this.tests_, cmp);
    }

    public <T extends S> R process(T spec, I input) {
        return this.process(spec, input, ProcessingContext.getActiveContext());
    }

    public <T extends S> R process(T spec, I input, ProcessingContext context) {
        for (IProcessingFactory processor : this.processors_) {
            if (!processor.canHandle((IProcSpecification)spec)) continue;
            IProcessing processing = processor.generateProcessing(spec, context);
            return processing.process(input);
        }
        return null;
    }

    public <T extends S> IProcessingFactory find(T spec) {
        for (IProcessingFactory processor : this.processors_) {
            if (!processor.canHandle((IProcSpecification)spec)) continue;
            return processor;
        }
        return null;
    }

    @Override
    public List<P> getProcessors() {
        return Collections.unmodifiableList(this.processors_);
    }

    public List<O> getOutput() {
        return Collections.unmodifiableList(this.output_);
    }

    public List<T> getDiagnostics() {
        return Collections.unmodifiableList(this.tests_);
    }

    public P getProcessor(AlgorithmDescriptor desc) {
        if (desc == null) {
            return null;
        }
        for (IProcessingFactory processor : this.processors_) {
            if (!desc.isCompatible(processor.getInformation())) continue;
            return (P)processor;
        }
        return null;
    }

    protected T addDiagnostics(String module, String impl) {
        IDiagnosticsFactory diag = InterfaceLoader.create(module, IDiagnosticsFactory.class, impl);
        if (diag != null) {
            this.tests_.add(diag);
        }
        return (T)diag;
    }

    protected O addOutput(String module, String impl) {
        IOutputFactory o = InterfaceLoader.create(module, IOutputFactory.class, impl);
        if (o != null) {
            this.output_.add(o);
        }
        return (O)o;
    }

    protected void addDiagnostics(T diag) {
        for (IDiagnosticsFactory t : this.tests_) {
            if (!t.getClass().equals(diag.getClass())) continue;
            return;
        }
        this.tests_.add(diag);
    }

    protected void addOutput(O diag) {
        for (IOutputFactory o : this.output_) {
            if (!o.getClass().equals(diag.getClass())) continue;
            return;
        }
        this.output_.add(diag);
    }

    protected void addProcessor(P proc) {
        this.processors_.add(proc);
    }

    @Override
    public void dispose() {
        for (IOutputFactory output : this.output_) {
            output.dispose();
        }
        for (IDiagnosticsFactory t : this.tests_) {
            for (IDiagnosticsFactory diag : this.tests_) {
                diag.dispose();
            }
        }
        for (IProcessingFactory processor : this.processors_) {
            processor.dispose();
        }
    }
}

