/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.decomposition;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DenseDoubleAlgebra;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.algo.SparseDoubleAlgebra;
import cern.colt.matrix.tdouble.algo.decomposition.SparseDoubleCholeskyDecomposition;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SparseCCDoubleMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;
import java.util.Random;

public class TestSparseDoubleCholeskyDecomposition {
    public static void main(String[] stringArray) {
        int n;
        int n2;
        int n3 = 200;
        Random random = new Random(0L);
        SparseCCDoubleMatrix2D sparseCCDoubleMatrix2D = new SparseCCDoubleMatrix2D(n3, n3);
        SparseCCDoubleMatrix2D sparseCCDoubleMatrix2D2 = new SparseCCDoubleMatrix2D(n3, n3);
        DenseDoubleMatrix1D denseDoubleMatrix1D = new DenseDoubleMatrix1D(n3);
        DenseDoubleMatrix1D denseDoubleMatrix1D2 = new DenseDoubleMatrix1D(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                ((DoubleMatrix2D)sparseCCDoubleMatrix2D).setQuick(n2, n, 0.5 - random.nextDouble());
                ((DoubleMatrix2D)sparseCCDoubleMatrix2D2).setQuick(n2, n, ((DoubleMatrix2D)sparseCCDoubleMatrix2D).getQuick(n2, n));
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            ((DoubleMatrix2D)sparseCCDoubleMatrix2D).setQuick(n2, n2, ((DoubleMatrix2D)sparseCCDoubleMatrix2D).getQuick(n2, n2) + (double)n3);
            ((DoubleMatrix2D)sparseCCDoubleMatrix2D2).setQuick(n2, n2, ((DoubleMatrix2D)sparseCCDoubleMatrix2D).getQuick(n2, n2));
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                ((DoubleMatrix2D)sparseCCDoubleMatrix2D).setQuick(n2, n, ((DoubleMatrix2D)sparseCCDoubleMatrix2D).getQuick(n, n2));
                ((DoubleMatrix2D)sparseCCDoubleMatrix2D2).setQuick(n2, n, ((DoubleMatrix2D)sparseCCDoubleMatrix2D).getQuick(n, n2));
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            ((DoubleMatrix1D)denseDoubleMatrix1D).setQuick(n2, 0.5 - random.nextDouble());
            ((DoubleMatrix1D)denseDoubleMatrix1D2).setQuick(n2, ((DoubleMatrix1D)denseDoubleMatrix1D).getQuick(n2));
        }
        TestSparseDoubleCholeskyDecomposition.testCholesky(sparseCCDoubleMatrix2D, sparseCCDoubleMatrix2D2, denseDoubleMatrix1D, denseDoubleMatrix1D2);
        System.exit(0);
    }

    private static void testCholesky(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        int n = doubleMatrix2D.rows();
        double d = 1.0E-10;
        SparseDoubleCholeskyDecomposition sparseDoubleCholeskyDecomposition = new SparseDoubleCholeskyDecomposition(doubleMatrix2D2, 0);
        DoubleMatrix2D doubleMatrix2D3 = sparseDoubleCholeskyDecomposition.getL();
        DoubleMatrix1D doubleMatrix1D3 = doubleMatrix1D2.copy();
        sparseDoubleCholeskyDecomposition.solve(doubleMatrix1D3);
        System.out.print("\n");
        System.out.print("------ SparseDoubleCholeskyFactorization tests-------  \n");
        System.out.print(String.format("            Size of the Matrix %d by %d\n", n, n));
        System.out.print("\n");
        System.out.print(" The matrix A is randomly generated for each test.\n");
        System.out.print("============\n");
        System.out.print(String.format(" The relative machine precision (eps) is to be %e \n", d));
        System.out.print(" Computational tests pass if scaled residuals are less than 10.\n");
        int n2 = TestSparseDoubleCholeskyDecomposition.checkFactorization(doubleMatrix2D, doubleMatrix2D3, d);
        int n3 = TestSparseDoubleCholeskyDecomposition.checkSolution(doubleMatrix2D, doubleMatrix1D, doubleMatrix1D3, d);
        if (n3 == 0 & n2 == 0) {
            System.out.print("***************************************************\n");
            System.out.print(" ---- SparseDoubleCholeskyFactorization tests... PASSED !\n");
            System.out.print("***************************************************\n");
        } else {
            System.err.print("***************************************************\n");
            System.err.print(" ---- SparseDoubleCholeskyFactorization tests... FAILED !\n");
            System.err.print("***************************************************\n");
        }
    }

    private static int checkFactorization(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, double d) {
        int n;
        DoubleProperty.DEFAULT.checkSparse(doubleMatrix2D);
        DoubleProperty.DEFAULT.checkSparse(doubleMatrix2D2);
        int n2 = doubleMatrix2D.rows();
        DoubleMatrix2D doubleMatrix2D3 = doubleMatrix2D2.copy();
        DoubleMatrix2D doubleMatrix2D4 = doubleMatrix2D2.copy();
        double d2 = 1.0;
        DoubleMatrix2D doubleMatrix2D5 = doubleMatrix2D.copy();
        doubleMatrix2D4 = doubleMatrix2D3.zMult(doubleMatrix2D4, null, d2, 0.0, false, true);
        doubleMatrix2D5.assign(doubleMatrix2D4, DoubleFunctions.plusMultFirst(-1.0));
        double d3 = SparseDoubleAlgebra.DEFAULT.normInfinity(doubleMatrix2D5);
        double d4 = SparseDoubleAlgebra.DEFAULT.normInfinity(doubleMatrix2D);
        System.out.print("============\n");
        System.out.print("Checking the Cholesky Factorization \n");
        System.out.print(String.format("-- ||L'L-A||_oo/(||A||_oo.N.eps) = %e \n", d3 / (d4 * (double)n2 * d)));
        if (d3 / (d4 * (double)n2 * d) > 10.0) {
            System.out.print("-- Factorization is suspicious ! \n");
            n = 1;
        } else {
            System.out.print("-- Factorization is CORRECT ! \n");
            n = 0;
        }
        return n;
    }

    private static int checkSolution(DoubleMatrix2D doubleMatrix2D, DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2, double d) {
        int n;
        DoubleProperty.DEFAULT.checkSparse(doubleMatrix2D);
        DoubleProperty.DEFAULT.checkDense(doubleMatrix1D);
        DoubleProperty.DEFAULT.checkDense(doubleMatrix1D2);
        int n2 = doubleMatrix2D.rows();
        double d2 = 1.0;
        double d3 = -1.0;
        double d4 = DenseDoubleAlgebra.DEFAULT.normInfinity(doubleMatrix1D2);
        double d5 = SparseDoubleAlgebra.DEFAULT.normInfinity(doubleMatrix2D);
        double d6 = DenseDoubleAlgebra.DEFAULT.normInfinity(doubleMatrix1D);
        doubleMatrix2D.zMult(doubleMatrix1D2, doubleMatrix1D, d2, d3, false);
        double d7 = DenseDoubleAlgebra.DEFAULT.normInfinity(doubleMatrix1D);
        System.out.print("============\n");
        System.out.print("Checking the Residual of the solution \n");
        System.out.print(String.format("-- ||Ax-B||_oo/((||A||_oo||x||_oo+||B||_oo).N.eps) = %e \n", d7 / ((d5 * d4 + d6) * (double)n2 * d)));
        if (d7 / ((d5 * d4 + d6) * (double)n2 * d) > 10.0) {
            System.out.print("-- The solution is suspicious ! \n");
            n = 1;
        } else {
            System.out.print("-- The solution is CORRECT ! \n");
            n = 0;
        }
        return n;
    }
}

