/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.check.checkers;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Range;
import org.ohdsi.circe.check.WarningSeverity;
import org.ohdsi.circe.check.checkers.BaseCorelatedCriteriaCheck;
import org.ohdsi.circe.check.checkers.Comparisons;
import org.ohdsi.circe.check.checkers.WarningReporter;
import org.ohdsi.circe.check.utils.CriteriaNameHelper;
import org.ohdsi.circe.cohortdefinition.CohortExpression;
import org.ohdsi.circe.cohortdefinition.CorelatedCriteria;
import org.ohdsi.circe.cohortdefinition.Occurrence;

public class CriteriaContradictionsCheck
extends BaseCorelatedCriteriaCheck {
    private static final String WARNING = "%s might be contradicted with %s and possibly will lead to 0 records";
    private List<CriteriaInto> criteriaList = new ArrayList<CriteriaInto>();

    @Override
    protected WarningSeverity defineSeverity() {
        return WarningSeverity.WARNING;
    }

    @Override
    protected void afterCheck(WarningReporter reporter, CohortExpression expression) {
        if (this.criteriaList.size() > 1) {
            int size = this.criteriaList.size();
            for (int i = 0; i < size - 2; ++i) {
                CriteriaInto info = this.criteriaList.get(i);
                this.criteriaList.subList(i + 1, size).stream().filter(ci -> Comparisons.compare(((CriteriaInto)info).criteria.criteria, ((CriteriaInto)ci).criteria.criteria)).filter(ci -> this.checkContradiction(((CriteriaInto)info).criteria.occurrence, ((CriteriaInto)ci).criteria.occurrence)).forEach(ci -> reporter.add(WARNING, info.name, ((CriteriaInto)ci).name));
            }
        }
    }

    private boolean checkContradiction(Occurrence o1, Occurrence o2) {
        Range<Integer> range2;
        Range<Integer> range1 = this.getOccurrenceRange(o1);
        return !range1.isOverlappedBy(range2 = this.getOccurrenceRange(o2));
    }

    private Range<Integer> getOccurrenceRange(Occurrence occurrence) {
        Range result = null;
        switch (occurrence.type) {
            case 0: {
                result = Range.between((Comparable)Integer.valueOf(occurrence.count), (Comparable)Integer.valueOf(occurrence.count));
                break;
            }
            case 1: {
                result = Range.between((Comparable)Integer.valueOf(Integer.MIN_VALUE), (Comparable)Integer.valueOf(occurrence.count));
                break;
            }
            case 2: {
                result = Range.between((Comparable)Integer.valueOf(occurrence.count), (Comparable)Integer.valueOf(Integer.MAX_VALUE));
            }
        }
        return result;
    }

    @Override
    protected void checkCriteria(CorelatedCriteria criteria, String groupName, WarningReporter reporter) {
        String name = groupName + " " + CriteriaNameHelper.getCriteriaName(criteria.criteria);
        this.criteriaList.add(new CriteriaInto(name, criteria));
    }

    class CriteriaInto {
        private String name;
        private CorelatedCriteria criteria;

        public CriteriaInto(String name, CorelatedCriteria criteria) {
            this.name = name;
            this.criteria = criteria;
        }

        public String getName() {
            return this.name;
        }

        public CorelatedCriteria getCriteria() {
            return this.criteria;
        }
    }
}

